/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.aoe_data.database.spells.builders;

import com.robertx22.mine_and_slash.database.data.spells.components.ComponentPart;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SpellAction;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.vanity.ParticleMotion;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.vanity.ParticleShape;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import net.minecraft.core.particles.SimpleParticleType;

public class ParticleBuilder {
    private float radius;
    private float randomY = 0.0f;
    private SimpleParticleType type;
    private float height = 0.0f;
    private int amount = 1;
    private ParticleMotion motion = ParticleMotion.None;
    private int everyXticks = 1;
    public ParticleShape shape = ParticleShape.CIRCLE;

    public static ParticleBuilder of(SimpleParticleType type, Float radius) {
        ParticleBuilder b = new ParticleBuilder();
        b.radius = radius.floatValue();
        b.type = type;
        return b;
    }

    public ParticleBuilder shape(ParticleShape shape) {
        this.shape = shape;
        return this;
    }

    public ParticleBuilder motion(ParticleMotion motion) {
        this.motion = motion;
        return this;
    }

    public ParticleBuilder randomY(float randomY) {
        this.randomY = randomY;
        return this;
    }

    public ParticleBuilder amount(int amount) {
        this.amount = amount;
        return this;
    }

    public ParticleBuilder height(float height) {
        this.height = height;
        return this;
    }

    public ParticleBuilder tickReq(int ticks) {
        this.everyXticks = this.everyXticks;
        return this;
    }

    public ComponentPart build() {
        ComponentPart c = new ComponentPart();
        c.acts.add(SpellAction.PARTICLES_IN_RADIUS.create(this.type, Double.valueOf(this.amount), Double.valueOf(this.radius)).put(MapField.PARTICLE_SHAPE, this.shape.name()).put(MapField.MOTION, this.motion.name()).put(MapField.HEIGHT, Double.valueOf(this.height)).put(MapField.Y_RANDOM, Double.valueOf(this.randomY)));
        if (this.everyXticks > 1) {
            c.tick(Double.valueOf(this.everyXticks));
        }
        return c;
    }
}

