/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.aoe_data.database.prophecies;

import com.robertx22.library_of_exile.registry.DataGenKey;
import com.robertx22.library_of_exile.registry.ExileRegistryInit;
import com.robertx22.mine_and_slash.aoe_data.database.base_gear_types.BaseGearTypes;
import com.robertx22.mine_and_slash.database.data.gear_types.bases.BaseGearType;
import com.robertx22.mine_and_slash.database.data.prophecy.ProphecyModifier;
import com.robertx22.mine_and_slash.database.data.prophecy.ProphecyModifierType;

public class ProphecyModifiers
implements ExileRegistryInit {
    public void registerAll() {
        ProphecyModifiers.of("uncommon", 100, ProphecyModifierType.GEAR_RARITY, "uncommon", 1.1f);
        ProphecyModifiers.of("rare", 500, ProphecyModifierType.GEAR_RARITY, "rare", 1.5f);
        ProphecyModifiers.of("epic", 1000, ProphecyModifierType.GEAR_RARITY, "epic", 2.0f).levelReq(25).tierReq(20);
        ProphecyModifiers.of("legendary", 500, ProphecyModifierType.GEAR_RARITY, "legendary", 3.0f).levelReq(40).tierReq(25);
        ProphecyModifiers.of("mythic", 100, ProphecyModifierType.GEAR_RARITY, "mythic", 4.0f).levelReq(50).tierReq(50);
        ProphecyModifiers.of("unique", 50, ProphecyModifierType.GEAR_RARITY, "unique", 4.0f).levelReq(25).tierReq(25);
        BaseGearTypes.init();
        for (DataGenKey<BaseGearType> e : BaseGearTypes.ALL) {
            ProphecyModifiers.of(e.GUID(), 1000, ProphecyModifierType.GEAR_TYPE, e.GUID(), 2.0f);
        }
    }

    public static Builder of(String id, int weight, ProphecyModifierType modifier, String data, float costmulti) {
        ProphecyModifier m = new ProphecyModifier();
        m.id = id;
        m.weight = weight;
        m.modifier_type = modifier;
        m.data = data;
        m.cost_multi = costmulti;
        m.addToSerializables();
        return new Builder(m);
    }

    public static class Builder {
        ProphecyModifier m = new ProphecyModifier();

        public Builder(ProphecyModifier m) {
            this.m = m;
        }

        public Builder tierReq(int tier) {
            this.m.tier_req = tier;
            return this;
        }

        public Builder levelReq(int lvl) {
            this.m.lvl_req = lvl;
            return this;
        }
    }
}

