/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.aoe_data.database.entity_configs;

import com.robertx22.library_of_exile.registry.ExileRegistryInit;
import com.robertx22.mine_and_slash.database.data.EntityConfig;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityTypeUtils;
import java.util.Locale;
import net.minecraft.world.entity.EntityType;

public class EntityConfigs
implements ExileRegistryInit {
    void setupBroadClasses() {
        new EntityConfig(EntityTypeUtils.EntityClassification.MOB.name().toLowerCase(Locale.ROOT), 1.0f).addToSerializables();
        EntityConfig animal = new EntityConfig(EntityTypeUtils.EntityClassification.ANIMAL.name().toLowerCase(Locale.ROOT), 0.0f);
        animal.hp_multi -= 0.5;
        animal.addToSerializables();
        EntityConfig npc = new EntityConfig(EntityTypeUtils.EntityClassification.NPC.name().toLowerCase(Locale.ROOT), 0.0f);
        npc.hp_multi += (double)0.2f;
        npc.addToSerializables();
        new EntityConfig(EntityTypeUtils.EntityClassification.OTHER.name().toLowerCase(Locale.ROOT), 0.0f).addToSerializables();
        new EntityConfig(EntityTypeUtils.EntityClassification.AMBIENT.name().toLowerCase(Locale.ROOT), 0.0f).addToSerializables();
        new EntityConfig(EntityTypeUtils.EntityClassification.PLAYER.name().toLowerCase(Locale.ROOT), 0.0f).addToSerializables();
    }

    void setupSpecificMobs() {
        EntityConfig irongolem = new EntityConfig(EntityType.f_20460_, 0.0f);
        irongolem.addToSerializables();
        EntityConfig polarbear = new EntityConfig(EntityType.f_20514_, 0.0f);
        polarbear.addToSerializables();
        new EntityConfig(EntityType.f_20531_, 0.5f).addToSerializables();
        EntityConfig zombie = new EntityConfig(EntityType.f_20501_, 0.75f);
        zombie.addToSerializables();
        new EntityConfig(EntityType.f_20562_, 0.75f).addToSerializables();
        new EntityConfig(EntityType.f_20550_, 0.8f).addToSerializables();
        new EntityConfig(EntityType.f_20499_, 0.5f).addToSerializables();
        EntityConfig enderman = new EntityConfig(EntityType.f_20566_, 1.0f);
        enderman.addToSerializables();
        EntityConfig wither = this.mob(EntityType.f_20496_, new EntityConfig.SpecialMobStats());
        wither.min_lvl = 30;
        EntityConfig dragon = this.mob(EntityType.f_20565_, new EntityConfig.SpecialMobStats());
        dragon.min_lvl = 40;
    }

    void setupWholeMods() {
        new EntityConfig("lycanite_mobs", 1.2f).addToSerializables();
        EntityConfig blue = new EntityConfig("blue_skies", 1.0f);
        blue.set_health_damage_override = true;
        blue.addToSerializables();
    }

    void setupMyMobs() {
    }

    public void registerAll() {
        this.setupBroadClasses();
        this.setupMyMobs();
        this.setupSpecificMobs();
        this.setupWholeMods();
    }

    private EntityConfig mob(EntityType type, EntityConfig.SpecialMobStats stats) {
        EntityConfig c = new EntityConfig(type, 1.0f);
        c.stats = stats;
        c.addToSerializables();
        return c;
    }
}

