/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.aoe_data.database.base_stats;

import com.robertx22.library_of_exile.registry.ExileRegistryInit;
import com.robertx22.mine_and_slash.aoe_data.database.stats.OffenseStats;
import com.robertx22.mine_and_slash.aoe_data.database.stats.ResourceStats;
import com.robertx22.mine_and_slash.aoe_data.database.stats.SpellChangeStats;
import com.robertx22.mine_and_slash.database.data.base_stats.BaseStatsConfig;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.types.offense.WeaponDamage;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.RegeneratePercentStat;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.energy.Energy;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.energy.EnergyRegen;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.health.Health;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.health.HealthRegen;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.magic_shield.MagicShieldRegen;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.mana.Mana;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.mana.ManaRegen;

public class BaseStatsAdder
implements ExileRegistryInit {
    public static String PLAYER = "player";
    public static String MOB = "mob";
    public static String EMPTY = "empty";

    public void registerAll() {
        BaseStatsAdder.playerStats().addToSerializables();
        BaseStatsAdder.mob().addToSerializables();
        BaseStatsAdder.empty().addToSerializables();
    }

    public static BaseStatsConfig mob() {
        BaseStatsConfig c = new BaseStatsConfig();
        c.id = MOB;
        c.scaled(OffenseStats.ACCURACY.get(), 5.0f);
        return c;
    }

    public static BaseStatsConfig empty() {
        BaseStatsConfig c = new BaseStatsConfig();
        c.id = EMPTY;
        return c;
    }

    public static BaseStatsConfig playerStats() {
        BaseStatsConfig c = new BaseStatsConfig();
        c.id = PLAYER;
        c.nonScaled(RegeneratePercentStat.MAGIC_SHIELD, 2.0f);
        c.scaled(WeaponDamage.getInstance(), 3.0f);
        c.nonScaled(WeaponDamage.getInstance(), 2.0f);
        c.scaled(Health.getInstance(), 50.0f);
        c.scaled(Mana.getInstance(), 50.0f);
        c.scaled(Energy.getInstance(), 50.0f);
        c.scaled(HealthRegen.getInstance(), 2.0f);
        c.scaled(MagicShieldRegen.getInstance(), 2.0f);
        c.scaled(ManaRegen.getInstance(), 3.0f);
        c.scaled(EnergyRegen.getInstance(), 5.0f);
        c.nonScaled(SpellChangeStats.MAX_SUMMON_CAPACITY.get(), 3.0f);
        c.nonScaled(OffenseStats.CRIT_CHANCE.get(), 1.0f);
        c.nonScaled(OffenseStats.CRIT_DAMAGE.get(), 1.0f);
        for (Stat cap : ResourceStats.LEECH_CAP.getAll()) {
            c.nonScaled(cap, 5.0f);
        }
        return c;
    }
}

