/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.aoe_data.database.affixes.adders.corruption;

import com.robertx22.mine_and_slash.aoe_data.database.affixes.AffixBuilder;
import com.robertx22.mine_and_slash.aoe_data.database.exile_effects.adders.ModEffects;
import com.robertx22.mine_and_slash.aoe_data.database.stats.OffenseStats;
import com.robertx22.mine_and_slash.aoe_data.database.stats.SpellChangeStats;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.effects.defense.MaxElementalResist;
import com.robertx22.mine_and_slash.database.data.stats.types.MaximumChargesStat;
import com.robertx22.mine_and_slash.database.data.stats.types.generated.ElementalResist;
import com.robertx22.mine_and_slash.database.data.stats.types.spirit.AuraCapacity;
import com.robertx22.mine_and_slash.database.data.stats.types.spirit.AuraEffect;
import com.robertx22.mine_and_slash.tags.all.SlotTags;
import com.robertx22.mine_and_slash.tags.imp.SlotTag;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;

public class CorruptionAffixes {
    static String PREFIX = "gear_corrupt";

    public static void init() {
        CorruptionAffixes.of(new MaximumChargesStat(ModEffects.POWER_CHARGE), 1.0f, 1.0f, SlotTags.helmet, SlotTags.ring).Build();
        CorruptionAffixes.of(new MaximumChargesStat(ModEffects.ENDURANCE_CHARGE), 1.0f, 1.0f, SlotTags.boots, SlotTags.ring).Build();
        CorruptionAffixes.of(new MaximumChargesStat(ModEffects.FRENZY_CHARGE), 1.0f, 1.0f, SlotTags.pants, SlotTags.ring).Build();
        CorruptionAffixes.of(AuraCapacity.getInstance(), 1.0f, 3.0f, SlotTags.jewelry_family).Build();
        CorruptionAffixes.of(AuraEffect.getInstance(), 1.0f, 3.0f, SlotTags.jewelry_family).Build();
        CorruptionAffixes.of(OffenseStats.CRIT_DAMAGE.get(), 3.0f, 15.0f, SlotTags.weapon_family).Build();
        CorruptionAffixes.of(OffenseStats.CRIT_CHANCE.get(), 1.0f, 3.0f, SlotTags.weapon_family).Build();
        CorruptionAffixes.of(SpellChangeStats.CAST_SPEED.get(), 1.0f, 3.0f, SlotTags.jewelry_family).Build();
        CorruptionAffixes.of(SpellChangeStats.COOLDOWN_REDUCTION.get(), 1.0f, 3.0f, SlotTags.jewelry_family).Build();
        CorruptionAffixes.of(new ElementalResist(Elements.Physical), 2.0f, 5.0f, SlotTags.armor_family).Build();
        for (Elements ele : Elements.getAllSingleElemental()) {
            if (ele == Elements.Physical) continue;
            CorruptionAffixes.of(new MaxElementalResist(ele), 1.0f, 1.0f, SlotTags.armor_family).Build();
            CorruptionAffixes.of(new ElementalResist(ele), 2.0f, 5.0f, SlotTags.armor_family).Build();
        }
    }

    static AffixBuilder of(Stat stat, float v1, float v2, SlotTag ... fam) {
        return AffixBuilder.Normal(PREFIX + stat.GUID()).stat(stat.mod(v1, v2)).includesTags(fam).GearCorrupt().Weight(1000);
    }
}

