/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.aoe_data.database.affixes;

import com.robertx22.mine_and_slash.database.data.StatMod;
import com.robertx22.mine_and_slash.database.data.affixes.Affix;
import com.robertx22.mine_and_slash.database.data.requirements.Requirements;
import com.robertx22.mine_and_slash.database.data.requirements.TagRequirement;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.tags.TagType;
import com.robertx22.mine_and_slash.tags.imp.SlotTag;
import com.robertx22.mine_and_slash.uncommon.enumclasses.ModType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class AffixBuilder {
    String guid;
    List<StatMod> stats = new ArrayList<StatMod>();
    String langName = "";
    boolean allowDupli = false;
    int weight = 1000;
    public Affix.Type type;
    public String auraReq = "";
    TagRequirement tagRequirement = new TagRequirement(TagType.GearSlot, new ArrayList<String>(), new ArrayList<String>());

    private AffixBuilder(String id) {
        this.guid = id;
    }

    public static AffixBuilder Normal(String id) {
        return new AffixBuilder(id);
    }

    public AffixBuilder Named(String name) {
        this.langName = name;
        return this;
    }

    public AffixBuilder AuraReq(String aura) {
        this.auraReq = aura;
        return this;
    }

    public AffixBuilder includesTags(SlotTag ... tags) {
        this.tagRequirement.included.addAll(Arrays.stream(tags).map(x -> x.GUID()).collect(Collectors.toList()));
        return this;
    }

    public AffixBuilder mustIncludesAllTags(SlotTag ... tags) {
        this.tagRequirement.included.addAll(Arrays.stream(tags).map(x -> x.GUID()).collect(Collectors.toList()));
        this.tagRequirement.req_type = TagRequirement.ReqType.HAS_ALL;
        return this;
    }

    public AffixBuilder excludesTags(SlotTag ... tags) {
        this.tagRequirement.excluded.addAll(Arrays.stream(tags).map(x -> x.GUID()).collect(Collectors.toList()));
        return this;
    }

    public AffixBuilder Weight(int weight) {
        this.weight = weight;
        return this;
    }

    public AffixBuilder coreStat(Stat stat) {
        return this.stats(new StatMod(2.0f, 15.0f, stat, ModType.FLAT));
    }

    public AffixBuilder bigCoreStat(Stat stat) {
        return this.stats(new StatMod(3.0f, 25.0f, stat, ModType.FLAT));
    }

    public AffixBuilder stats(StatMod ... stats) {
        this.stats.addAll(Arrays.asList(stats));
        return this;
    }

    public AffixBuilder stat(StatMod stat) {
        this.stats.add(stat);
        return this;
    }

    public AffixBuilder AllowDuplicatesOnSameItem() {
        this.allowDupli = true;
        return this;
    }

    public AffixBuilder WatchersEye() {
        this.type = Affix.Type.watcher_eye;
        return this;
    }

    public AffixBuilder JewelCorruption() {
        this.type = Affix.Type.jewel_corruption;
        return this;
    }

    public AffixBuilder GearCorrupt() {
        this.type = Affix.Type.chaos_stat;
        return this;
    }

    public AffixBuilder Prefix() {
        this.type = Affix.Type.prefix;
        return this;
    }

    public AffixBuilder Tool() {
        this.type = Affix.Type.tool;
        return this;
    }

    public AffixBuilder Suffix() {
        this.type = Affix.Type.suffix;
        return this;
    }

    public AffixBuilder Enchant() {
        this.type = Affix.Type.enchant;
        return this;
    }

    public AffixBuilder Implicit() {
        this.type = Affix.Type.implicit;
        return this;
    }

    public void Build() {
        Affix affix = new Affix();
        affix.guid = this.guid;
        affix.requirements = new Requirements(this.tagRequirement);
        affix.stats = this.stats;
        affix.only_one_per_item = !this.allowDupli;
        affix.type = this.type;
        affix.weight = this.weight;
        affix.loc_name = this.langName;
        affix.eye_aura_req = this.auraReq;
        affix.addToSerializables();
    }
}

