/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.registry;

import com.google.gson.JsonObject;
import com.robertx22.library_of_exile.registry.Database;
import com.robertx22.library_of_exile.registry.ExileRegistryContainer;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IGUID;
import com.robertx22.library_of_exile.registry.IWeighted;

public interface ExileRegistry<C>
extends IGUID,
IWeighted {
    public ExileRegistryType getExileRegistryType();

    default public void registerToExileRegistry() {
        Database.getRegistry(this.getExileRegistryType()).register(this);
    }

    default public void compareLoadedJsonAndFinalClass(JsonObject json, Boolean editmode) {
    }

    default public void unregisterFromExileRegistry() {
        Database.getRegistry(this.getExileRegistryType()).unRegister(this);
    }

    default public boolean isEmpty() {
        ExileRegistryContainer db = Database.getRegistry(this.getExileRegistryType());
        Object em = db.getDefault();
        if (em != null && em.GUID().equals(this.GUID())) {
            return true;
        }
        return db.isRegistered(this.GUID());
    }

    default public void unregisterDueToInvalidity() {
        Database.getRegistry(this.getExileRegistryType()).unRegister(this);
        try {
            throw new Exception("Registry Entry: " + this.GUID() + " of type: " + this.getExileRegistryType().id + " is invalid! Unregistering");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    default public boolean isFromDatapack() {
        return false;
    }

    default public boolean isRegistryEntryValid() {
        return true;
    }

    default public String getInvalidGuidMessage() {
        return "Non [a-z0-9_.-] character in Mine and Slash GUID: " + this.GUID() + " of type " + this.getExileRegistryType().id;
    }
}

