/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.registry;

import com.google.gson.JsonElement;
import com.robertx22.library_of_exile.registry.BaseDatapackGenerator;
import com.robertx22.library_of_exile.registry.IGUID;
import com.robertx22.library_of_exile.registry.serialization.ISerializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;

public class ExileDatapackGenerator<T extends IGUID & ISerializable<T>>
extends BaseDatapackGenerator<T>
implements DataProvider {
    String modid;

    public ExileDatapackGenerator(String modid, List<T> list, String category) {
        super(list, category);
        this.modid = modid;
    }

    public Path resolve(Path path, T object) {
        return path.resolve("data/" + this.modid + "/" + this.category + "/" + ((ISerializable)object).datapackFolder() + object.getFileName().replaceAll(":", "_") + ".json");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CompletableFuture<?> generateAll(CachedOutput cache) {
        try {
            Path path = this.gameDirPath();
            for (IGUID entry : this.list) {
                if (!((ISerializable)((Object)entry)).shouldGenerateJson()) continue;
                Path target = this.movePath(this.resolve(path, entry));
                target = Paths.get(target.toString().replace("\\.\\", "\\"), new String[0]);
                try {
                    DataProvider.m_253162_((CachedOutput)cache, (JsonElement)((ISerializable)((Object)entry)).toJson(), (Path)target);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                    return CompletableFuture.completedFuture(Optional.empty());
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    public CompletableFuture<?> m_213708_(CachedOutput pOutput) {
        return this.generateAll(pOutput);
    }

    public String m_6055_() {
        return this.category;
    }
}

