/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.registry;

import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.ExileRegistryContainer;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.SyncTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class Database {
    private static HashMap<ExileRegistryType, ExileRegistryContainer> SERVER = new HashMap();

    public static boolean areDatapacksLoaded(Level world) {
        return ExileRegistryType.getInRegisterOrder(SyncTime.ON_LOGIN).stream().allMatch(x -> Database.getRegistry(x).isRegistrationDone());
    }

    public static List<ExileRegistryContainer> getAllRegistries() {
        return new ArrayList<ExileRegistryContainer>(SERVER.values());
    }

    public static ExileRegistryContainer getRegistry(ExileRegistryType type) {
        return SERVER.get(type);
    }

    public static ExileRegistry get(ExileRegistryType type, String guid) {
        return Database.getRegistry(type).get(guid);
    }

    public static void sendPacketsToClient(ServerPlayer player, SyncTime sync) {
        List<ExileRegistryType> list = ExileRegistryType.getInRegisterOrder(sync);
        list.forEach(x -> Database.getRegistry(x).sendUpdatePacket(player));
    }

    public static void checkGuidValidity() {
        SERVER.values().forEach(c -> c.getAllIncludingSeriazable().forEach(x -> {
            ExileRegistry entry = (ExileRegistry)x;
            if (!entry.isGuidFormattedCorrectly()) {
                throw new RuntimeException(entry.getInvalidGuidMessage());
            }
        }));
    }

    public static void unregisterInvalidEntries() {
        ArrayList invalid = new ArrayList();
        SERVER.values().forEach(c -> c.getList().forEach(x -> {
            ExileRegistry entry = (ExileRegistry)x;
            if (!entry.isRegistryEntryValid()) {
                invalid.add(entry);
            }
        }));
        invalid.forEach(x -> x.unregisterDueToInvalidity());
        if (invalid.isEmpty()) {
            ExileLog.get().debug("All Mine and Slash registries appear valid.", new Object[0]);
        } else {
            ExileLog.get().warn(invalid.size() + " Mine and Slash entries are INVALID!", new Object[0]);
        }
    }

    public static void addRegistry(ExileRegistryContainer cont) {
        SERVER.put(cont.getType(), cont);
    }

    public static void initRegistries() {
        SERVER = new HashMap();
        ExileRegistryType.init();
    }
}

