/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.packets.registry;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.packets.ExilePacketContext;
import com.robertx22.library_of_exile.registry.Database;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.ExileRegistryContainer;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.library_of_exile.registry.serialization.ISerializable;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class EfficientRegistryPacket<T extends ISerializable & JsonExileRegistry>
extends MyPacket<EfficientRegistryPacket> {
    public static final JsonParser PARSER = new JsonParser();
    public static ResourceLocation ID = new ResourceLocation("library_of_exile", "eff_reg");
    private List<T> items;
    ExileRegistryType type;

    public EfficientRegistryPacket() {
    }

    public EfficientRegistryPacket(ExileRegistryType type, List<T> list) {
        this.type = type;
        this.items = list;
    }

    @Override
    public ResourceLocation getIdentifier() {
        return ID;
    }

    @Override
    public void loadFromData(FriendlyByteBuf buf) {
        this.type = ExileRegistryType.get(buf.m_130136_(40));
        ISerializable serializer = this.type.getSerializer();
        this.items = Lists.newArrayList();
        int i = buf.m_130242_();
        for (int j = 0; j < i; ++j) {
            JsonObject json = (JsonObject)PARSER.parse(buf.m_130136_(Integer.MAX_VALUE));
            this.items.add((ISerializable)serializer.fromJson(json));
        }
    }

    @Override
    public void saveToData(FriendlyByteBuf buf) {
        buf.m_130072_(this.type.id, 40);
        buf.m_130130_(this.items.size());
        this.items.forEach(x -> {
            if (((JsonExileRegistry)((Object)x)).isFromDatapack()) {
                buf.m_130072_(x.toJsonString(), Integer.MAX_VALUE);
            }
        });
    }

    @Override
    public void onReceived(ExilePacketContext ctx) {
        ExileRegistryContainer reg = Database.getRegistry(this.type);
        this.items.forEach(x -> {
            ((ExileRegistry)((Object)x)).unregisterFromExileRegistry();
            ((ExileRegistry)((Object)x)).registerToExileRegistry();
        });
        ExileLog.get().onlyInConsole("Efficient " + this.type.id + " reg load on client success with: " + reg.getSize() + " entries.");
    }

    @Override
    public MyPacket<EfficientRegistryPacket> newInstance() {
        return new EfficientRegistryPacket<T>();
    }
}

