/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.components;

import com.robertx22.library_of_exile.components.EntityDmgStatsData;
import com.robertx22.library_of_exile.components.ICap;
import com.robertx22.library_of_exile.components.MySpawnReason;
import com.robertx22.library_of_exile.utils.LoadSave;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class EntityInfoComponent {
    public static final ResourceLocation RESOURCE = new ResourceLocation("library_of_exile", "entity_info");
    public static Capability<DefaultImpl> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<DefaultImpl>(){});
    private static final String DMG_STATS = "dmg_stats";
    private static final String SPAWN_POS = "spawn_pos";
    private static final String SPAWN_REASON = "spawn";

    public static IEntityInfo get(LivingEntity entity) {
        return (IEntityInfo)entity.getCapability(INSTANCE).orElse((Object)new DefaultImpl(entity));
    }

    public static class DefaultImpl
    implements ICap,
    IEntityInfo {
        final LazyOptional<DefaultImpl> supp = LazyOptional.of(() -> this);
        EntityDmgStatsData dmgStats = new EntityDmgStatsData();
        private BlockPos spawnPos;
        public MySpawnReason spawnReason = null;
        public LivingEntity owner;

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (cap == INSTANCE) {
                return this.supp.cast();
            }
            return LazyOptional.empty();
        }

        public DefaultImpl(LivingEntity en) {
            this.owner = en;
        }

        @Override
        public BlockPos getSpawnPos() {
            if (this.isSpawnInit()) {
                return this.spawnPos;
            }
            return this.owner.m_20183_();
        }

        private boolean isSpawnInit() {
            return this.spawnPos != null && !this.spawnPos.equals((Object)BlockPos.f_121853_);
        }

        @Override
        public void spawnInit(Entity entity) {
            if (this.isSpawnInit()) {
                this.spawnPos = entity.m_20183_();
            }
        }

        @Override
        public MySpawnReason getSpawnReason() {
            return this.spawnReason == null ? MySpawnReason.OTHER : this.spawnReason;
        }

        @Override
        public void setSpawnReasonOnCreate(MobSpawnType reason) {
            if (this.spawnReason == null) {
                this.spawnReason = MySpawnReason.get(reason);
            }
        }

        @Override
        public EntityDmgStatsData getDamageStats() {
            return this.dmgStats;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            try {
                if (this.dmgStats != null) {
                    LoadSave.Save(this.dmgStats, nbt, EntityInfoComponent.DMG_STATS);
                }
                if (this.spawnPos != null) {
                    nbt.m_128356_(EntityInfoComponent.SPAWN_POS, this.spawnPos.m_121878_());
                }
                nbt.m_128359_(this.getSpawnReason().name(), EntityInfoComponent.SPAWN_REASON);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            try {
                this.dmgStats = LoadSave.Load(EntityDmgStatsData.class, new EntityDmgStatsData(), nbt, EntityInfoComponent.DMG_STATS);
                if (this.dmgStats == null) {
                    this.dmgStats = new EntityDmgStatsData();
                }
                this.spawnPos = BlockPos.m_122022_((long)nbt.m_128454_(EntityInfoComponent.SPAWN_POS));
                String res = nbt.m_128461_(EntityInfoComponent.SPAWN_REASON);
                this.spawnReason = res != null && !res.isEmpty() ? MySpawnReason.valueOf(res) : MySpawnReason.OTHER;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getCapIdForSyncing() {
            return "entity_info";
        }
    }

    public static interface IEntityInfo {
        public EntityDmgStatsData getDamageStats();

        public BlockPos getSpawnPos();

        public void spawnInit(Entity var1);

        public MySpawnReason getSpawnReason();

        public void setSpawnReasonOnCreate(MobSpawnType var1);
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onEntityConstruct(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof LivingEntity) {
                event.addCapability(RESOURCE, (ICapabilityProvider)new DefaultImpl((LivingEntity)event.getObject()));
            }
        }
    }
}

