/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform.services;

import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.loot.modifier.ILootModifier;
import com.blamejared.crafttweaker.api.mod.Mod;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.villager.CTTradeObject;
import com.blamejared.crafttweaker.api.villager.trade.type.IBasicItemListing;
import com.blamejared.crafttweaker.mixin.common.access.item.AccessIngredient;
import com.blamejared.crafttweaker.platform.helper.inventory.IInventoryWrapper;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_3853;
import net.minecraft.class_4174;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public interface IPlatformHelper {
    default public String getLogFormat() {
        return "[%d{HH:mm:ss.SSS}][%level][%markerSimpleName]: %msg%n%throwable";
    }

    public String getPlatformName();

    public boolean isModLoaded(String var1);

    public boolean isDevelopmentEnvironment();

    public boolean isDataGen();

    public List<Mod> getMods();

    public Optional<Mod> getMod(String var1);

    public IItemStack createItemStack(class_1799 var1);

    public IItemStack createItemStackMutable(class_1799 var1);

    public IFluidStack createFluidStack(class_3611 var1, long var2, @Nullable class_2487 var4);

    public IFluidStack createFluidStackMutable(class_3611 var1, long var2, @Nullable class_2487 var4);

    public <T> IFluidStack createFluidStack(T var1);

    public <T> IFluidStack createFluidStackMutable(T var1);

    public class_3611 getBucketContent(class_1755 var1);

    public Path getGameDirectory();

    public <T extends Annotation> Stream<? extends Class<?>> findClassesWithAnnotation(Class<T> var1, Consumer<Mod> var2, Predicate<Either<T, Map<String, Object>>> var3);

    public String findMappedMethodName(Class<?> var1, String var2, Class<?> var3, Class<?> ... var4);

    public String findMappedFieldName(Class<?> var1, String var2, Class<?> var3);

    default public void registerCustomTradeConverters(Map<Class<? extends class_3853.class_1652>, Function<class_3853.class_1652, CTTradeObject>> classFunctionMap) {
    }

    public Map<class_2960, ILootModifier> getLootModifiersMap();

    public IInventoryWrapper getPlayerInventory(class_1657 var1);

    default public boolean canItemStacksStack(class_1799 first, class_1799 second) {
        if (first.method_7960() || !class_1799.method_7984((class_1799)first, (class_1799)second) || first.method_7985() != second.method_7985()) {
            return false;
        }
        return !first.method_7985() || first.method_7969().equals((Object)second.method_7969());
    }

    public boolean doCraftingTableRecipesConflict(IRecipeManager<?> var1, class_1860<?> var2, class_1860<?> var3);

    public Set<class_5250> getFluidsForDump(class_1799 var1, class_1657 var2, class_1268 var3);

    public class_2487 getCustomData(class_1297 var1);

    public class_2487 getPersistentData(class_3222 var1);

    default public void addFoodPropertiesEffect(class_4174 internal, class_1293 effect, float probability) {
        internal.method_19235().add(Pair.of((Object)effect, (Object)Float.valueOf(probability)));
    }

    default public void removeFoodPropertiesEffect(class_4174 internal, class_1293 effect) {
        internal.method_19235().removeIf(pair -> ((class_1293)pair.getFirst()).equals((Object)effect));
    }

    default public void removeFoodPropertiesEffect(class_4174 internal, class_1291 effect) {
        internal.method_19235().removeIf(pair -> ((class_1293)pair.getFirst()).method_5579() == effect);
    }

    default public void invalidateIngredients(List<class_1856> ingredients) {
        ingredients.forEach(ingredient -> ((AccessIngredient)ingredient).crafttweaker$setItemStacks(null));
        ingredients.clear();
    }

    public Stream<GameProfile> fakePlayers();

    public boolean isFakePlayer(class_1657 var1);

    default public class_1799 getBasicTradePrice(IBasicItemListing internal) {
        throw new UnsupportedOperationException("Unable to get price for '%s'".formatted(internal));
    }

    default public class_1799 getBasicTradePrice2(IBasicItemListing internal) {
        throw new UnsupportedOperationException("Unable to get price2 for '%s'".formatted(internal));
    }

    default public class_1799 getBasicTradeForSale(IBasicItemListing internal) {
        throw new UnsupportedOperationException("Unable to get forSale for '%s'".formatted(internal));
    }

    default public int getBasicTradeMaxTrades(IBasicItemListing internal) {
        throw new UnsupportedOperationException("Unable to get maxTrades for '%s'".formatted(internal));
    }

    default public int getBasicTradeXp(IBasicItemListing internal) {
        throw new UnsupportedOperationException("Unable to get xp for '%s'".formatted(internal));
    }

    default public float getBasicTradePriceMult(IBasicItemListing internal) {
        throw new UnsupportedOperationException("Unable to get priceMult for '%s'".formatted(internal));
    }
}

