/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipe.handler.type.vanilla;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import com.blamejared.crafttweaker.impl.recipe.handler.helper.SmithingRecipeConflictChecker;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessSmithingTransformRecipe;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_8059;
import net.minecraft.class_8060;

@IRecipeHandler.For(value=class_8060.class)
public final class SmithingTransformRecipeHandler
implements IRecipeHandler<class_8060> {
    @Override
    public String dumpToCommandString(IRecipeManager<? super class_8060> manager, class_8060 recipe) {
        Object[] objectArray = new Object[5];
        objectArray[0] = StringUtil.quoteAndEscape(recipe.method_8114());
        objectArray[1] = ItemStackUtil.getCommandString(AccessibleElementsProvider.get().registryAccess(arg_0 -> ((class_8060)recipe).method_8110(arg_0)));
        objectArray[2] = IIngredient.fromIngredient(((AccessSmithingTransformRecipe)recipe).crafttweaker$getTemplate()).getCommandString();
        objectArray[3] = IIngredient.fromIngredient(((AccessSmithingTransformRecipe)recipe).crafttweaker$getBase()).getCommandString();
        objectArray[4] = IIngredient.fromIngredient(((AccessSmithingTransformRecipe)recipe).crafttweaker$getAddition()).getCommandString();
        return String.format("smithing.addTransformRecipe(%s, %s, %s, %s, %s);", objectArray);
    }

    @Override
    public <U extends class_1860<?>> boolean doesConflict(IRecipeManager<? super class_8060> manager, class_8060 firstRecipe, U secondRecipe) {
        if (!(secondRecipe instanceof class_8059)) {
            return false;
        }
        class_8059 secondSmithing = (class_8059)secondRecipe;
        return SmithingRecipeConflictChecker.doesConflict(manager, (class_8059)firstRecipe, secondSmithing);
    }

    @Override
    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super class_8060> manager, class_8060 recipe) {
        AccessSmithingTransformRecipe access = (AccessSmithingTransformRecipe)recipe;
        IIngredient template = IIngredient.fromIngredient(access.crafttweaker$getTemplate());
        IIngredient base = IIngredient.fromIngredient(access.crafttweaker$getBase());
        IIngredient addition = IIngredient.fromIngredient(access.crafttweaker$getAddition());
        IDecomposedRecipe decomposed = IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Input.INGREDIENTS, List.of(template, base, addition)).with(BuiltinRecipeComponents.Output.ITEMS, IItemStack.of(AccessibleElementsProvider.get().registryAccess(arg_0 -> ((class_8060)recipe).method_8110(arg_0)))).build();
        return Optional.of(decomposed);
    }

    @Override
    public Optional<class_8060> recompose(IRecipeManager<? super class_8060> manager, class_2960 name, IDecomposedRecipe recipe) {
        List<IIngredient> ingredients = recipe.getOrThrow(BuiltinRecipeComponents.Input.INGREDIENTS);
        IItemStack output = recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.ITEMS);
        if (ingredients.size() != 3) {
            throw new IllegalArgumentException("Invalid inputs: expected three ingredients for recipe, but got " + ingredients.size() + ": " + ingredients);
        }
        if (ingredients.stream().anyMatch(IIngredient::isEmpty)) {
            throw new IllegalArgumentException("Invalid inputs: empty ingredients");
        }
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Invalid outputs: empty item");
        }
        class_1856 template = ingredients.get(0).asVanillaIngredient();
        class_1856 base = ingredients.get(1).asVanillaIngredient();
        class_1856 addition = ingredients.get(2).asVanillaIngredient();
        return Optional.of(new class_8060(name, template, base, addition, output.getInternal()));
    }
}

