/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.plugin.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.bracket.custom.EnumConstantBracketHandler;
import com.blamejared.crafttweaker.api.bracket.custom.RecipeComponentBracketHandler;
import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.bracket.custom.TagBracketHandler;
import com.blamejared.crafttweaker.api.bracket.custom.TagManagerBracketHandler;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.plugin.CraftTweakerPlugin;
import com.blamejared.crafttweaker.api.plugin.IBracketParserRegistrationHandler;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.api.plugin.ICraftTweakerPlugin;
import com.blamejared.crafttweaker.api.plugin.IEventRegistrationHandler;
import com.blamejared.crafttweaker.api.plugin.IJavaNativeIntegrationRegistrationHandler;
import com.blamejared.crafttweaker.api.plugin.ILoaderRegistrationHandler;
import com.blamejared.crafttweaker.api.plugin.IRecipeComponentRegistrationHandler;
import com.blamejared.crafttweaker.api.plugin.IRecipeHandlerRegistrationHandler;
import com.blamejared.crafttweaker.api.plugin.IReplacerComponentRegistrationHandler;
import com.blamejared.crafttweaker.api.plugin.IScriptLoadSourceRegistrationHandler;
import com.blamejared.crafttweaker.api.plugin.IScriptRunModuleConfiguratorRegistrationHandler;
import com.blamejared.crafttweaker.api.plugin.ITaggableElementRegistrationHandler;
import com.blamejared.crafttweaker.api.plugin.IVillagerTradeRegistrationHandler;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.replacement.ITargetingStrategy;
import com.blamejared.crafttweaker.api.villager.CTTradeObject;
import com.blamejared.crafttweaker.api.zencode.scriptrun.IScriptRunModuleConfigurator;
import com.blamejared.crafttweaker.impl.command.type.DumpCommands;
import com.blamejared.crafttweaker.impl.command.type.HandCommands;
import com.blamejared.crafttweaker.impl.command.type.InventoryCommands;
import com.blamejared.crafttweaker.impl.command.type.MiscCommands;
import com.blamejared.crafttweaker.impl.command.type.ModCommands;
import com.blamejared.crafttweaker.impl.command.type.RecipeCommands;
import com.blamejared.crafttweaker.impl.command.type.conflict.ConflictCommand;
import com.blamejared.crafttweaker.impl.command.type.script.ScriptCommands;
import com.blamejared.crafttweaker.impl.command.type.script.example.ExamplesCommand;
import com.blamejared.crafttweaker.impl.plugin.crafttweaker.BracketParserRegistrationManager;
import com.blamejared.crafttweaker.impl.plugin.crafttweaker.EnumBracketParserRegistrationManager;
import com.blamejared.crafttweaker.impl.plugin.crafttweaker.EventRegistrationManager;
import com.blamejared.crafttweaker.impl.plugin.crafttweaker.RecipeHandlerGatherer;
import com.blamejared.crafttweaker.impl.plugin.crafttweaker.TaggableElementsRegistrationManager;
import com.blamejared.crafttweaker.impl.plugin.crafttweaker.ZenClassGatherer;
import com.blamejared.crafttweaker.impl.plugin.crafttweaker.ZenClassRegistrationManager;
import com.blamejared.crafttweaker.impl.recipe.replacement.DefaultTargetingFilters;
import com.blamejared.crafttweaker.impl.recipe.replacement.DefaultTargetingStrategies;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessDyedArmorForEmeralds;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessEmeraldForItems;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessEnchantedItemForEmeralds;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessItemsAndEmeraldsToItems;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessItemsForEmeralds;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessTippedArrowForItemsAndEmeralds;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_3853;

@CraftTweakerPlugin(value="crafttweaker:builtin")
public final class BuiltinCraftTweakerPlugin
implements ICraftTweakerPlugin {
    private final BracketParserRegistrationManager bracketParserRegistrationManager = new BracketParserRegistrationManager();
    private final EnumBracketParserRegistrationManager enumBracketParserRegistrationManager = new EnumBracketParserRegistrationManager();
    private final EventRegistrationManager eventRegistrationManager = new EventRegistrationManager();
    private final RecipeHandlerGatherer handlerGatherer = new RecipeHandlerGatherer();
    private final TaggableElementsRegistrationManager taggableElementsRegistrationManager = new TaggableElementsRegistrationManager();
    private final ZenClassGatherer zenGatherer = new ZenClassGatherer();
    private final ZenClassRegistrationManager zenClassRegistrationManager = new ZenClassRegistrationManager();

    @Override
    public void initialize() {
        this.zenGatherer.gatherCandidates();
    }

    @Override
    public void registerLoaders(ILoaderRegistrationHandler handler) {
        handler.registerLoader("initialize", new String[0]);
        handler.registerLoader("crafttweaker", new String[0]);
        handler.registerLoader("tags", new String[0]);
    }

    @Override
    public void registerLoadSource(IScriptLoadSourceRegistrationHandler handler) {
        handler.registerLoadSource(CraftTweakerConstants.RELOAD_LISTENER_SOURCE_ID);
        handler.registerLoadSource(CraftTweakerConstants.CLIENT_RECIPES_UPDATED_SOURCE_ID);
    }

    @Override
    public void registerModuleConfigurators(IScriptRunModuleConfiguratorRegistrationHandler handler) {
        IScriptRunModuleConfigurator defaultConfig = IScriptRunModuleConfigurator.createDefault("crafttweaker");
        handler.registerConfigurator("crafttweaker", defaultConfig);
        handler.registerConfigurator("initialize", defaultConfig);
        handler.registerConfigurator("tags", defaultConfig);
    }

    @Override
    public void manageJavaNativeIntegration(IJavaNativeIntegrationRegistrationHandler handler) {
        this.zenGatherer.listProviders();
        this.zenGatherer.onCandidates(candidate -> this.zenClassRegistrationManager.attemptRegistration(candidate.loader(), candidate.clazz(), handler));
        this.zenClassRegistrationManager.attemptDeferredRegistration(handler);
    }

    @Override
    public void registerBracketParsers(IBracketParserRegistrationHandler handler) {
        this.zenGatherer.onCandidates(candidate -> {
            this.bracketParserRegistrationManager.addRegistrationCandidate(candidate.clazz(), candidate.loader());
            this.enumBracketParserRegistrationManager.attemptRegistration(candidate.clazz(), candidate.loader(), handler);
        });
        this.bracketParserRegistrationManager.attemptRegistration(handler);
        handler.registerParserFor("*", "constant", new EnumConstantBracketHandler(), new IBracketParserRegistrationHandler.DumperData("constant", EnumConstantBracketHandler.getDumperData()));
        handler.registerParserFor("crafttweaker", "recipecomponent", new RecipeComponentBracketHandler(), new IBracketParserRegistrationHandler.DumperData("recipecomponent", RecipeComponentBracketHandler.getDumperData()));
        handler.registerParserFor("crafttweaker", "recipetype", new RecipeTypeBracketHandler(), new IBracketParserRegistrationHandler.DumperData("recipetype", RecipeTypeBracketHandler.getDumperData()));
        handler.registerParserFor("crafttweaker", "tag", new TagBracketHandler(), new IBracketParserRegistrationHandler.DumperData("tag", TagBracketHandler.getDumperData()));
        handler.registerParserFor("crafttweaker", "tagmanager", new TagManagerBracketHandler(), new IBracketParserRegistrationHandler.DumperData("tagmanager", TagManagerBracketHandler.getDumperData()));
        handler.registerParserFor("tags", "tag", new TagBracketHandler());
        handler.registerParserFor("tags", "tagmanager", new TagManagerBracketHandler());
    }

    @Override
    public void registerRecipeComponents(IRecipeComponentRegistrationHandler handler) {
        handler.registerRecipeComponent(BuiltinRecipeComponents.Metadata.GROUP);
        handler.registerRecipeComponent(BuiltinRecipeComponents.Metadata.COOKING_BOOK_CATEGORY);
        handler.registerRecipeComponent(BuiltinRecipeComponents.Metadata.CRAFTING_BOOK_CATEGORY);
        handler.registerRecipeComponent(BuiltinRecipeComponents.Metadata.MIRROR_AXIS);
        handler.registerRecipeComponent(BuiltinRecipeComponents.Metadata.SHAPE_SIZE_2D);
        handler.registerRecipeComponent(BuiltinRecipeComponents.Input.INGREDIENTS);
        handler.registerRecipeComponent(BuiltinRecipeComponents.Input.FLUID_INGREDIENTS);
        handler.registerRecipeComponent(BuiltinRecipeComponents.Processing.FUNCTION_0D);
        handler.registerRecipeComponent(BuiltinRecipeComponents.Processing.FUNCTION_1D);
        handler.registerRecipeComponent(BuiltinRecipeComponents.Processing.FUNCTION_2D);
        handler.registerRecipeComponent(BuiltinRecipeComponents.Processing.TIME);
        handler.registerRecipeComponent(BuiltinRecipeComponents.Output.CHANCED_ITEMS);
        handler.registerRecipeComponent(BuiltinRecipeComponents.Output.EXPERIENCE);
        handler.registerRecipeComponent(BuiltinRecipeComponents.Output.FLUIDS);
        handler.registerRecipeComponent(BuiltinRecipeComponents.Output.ITEMS);
    }

    @Override
    public void registerRecipeHandlers(IRecipeHandlerRegistrationHandler handler) {
        this.handlerGatherer.gatherAndRegisterHandlers(handler);
    }

    @Override
    public void registerVillagerTradeConverters(IVillagerTradeRegistrationHandler handler) {
        IItemStack emerald = IItemStack.of(new class_1799((class_1935)class_1802.field_8687));
        IItemStack compass = IItemStack.of(new class_1799((class_1935)class_1802.field_8251));
        IItemStack book = IItemStack.of(new class_1799((class_1935)class_1802.field_8529));
        IItemStack enchantedBook = IItemStack.of(new class_1799((class_1935)class_1802.field_8598));
        IItemStack filledMap = IItemStack.of(new class_1799((class_1935)class_1802.field_8204));
        IItemStack suspiciousStew = IItemStack.of(new class_1799((class_1935)class_1802.field_8766));
        handler.registerTradeConverter(class_3853.class_4160.class, trade -> new CTTradeObject(emerald, IItemStack.empty(), IItemStack.of(((AccessDyedArmorForEmeralds)trade).crafttweaker$getItem().method_7854())));
        handler.registerTradeConverter(class_3853.class_4161.class, trade -> new CTTradeObject(IItemStack.of(((AccessEmeraldForItems)trade).crafttweaker$getItem().method_7854()), IItemStack.empty(), emerald));
        handler.registerTradeConverter(class_3853.class_1654.class, trade -> new CTTradeObject(emerald, compass, filledMap));
        handler.registerTradeConverter(class_3853.class_4162.class, trade -> new CTTradeObject(IItemStack.empty(), IItemStack.empty(), emerald));
        handler.registerTradeConverter(class_3853.class_1648.class, trade -> new CTTradeObject(emerald, book, enchantedBook));
        handler.registerTradeConverter(class_3853.class_4163.class, trade -> new CTTradeObject(emerald, IItemStack.empty(), IItemStack.ofMutable(((AccessEnchantedItemForEmeralds)trade).crafttweaker$getItemStack())));
        handler.registerTradeConverter(class_3853.class_4167.class, trade -> new CTTradeObject(emerald, IItemStack.ofMutable(((AccessTippedArrowForItemsAndEmeralds)trade).crafttweaker$getFromItem().method_7854()), IItemStack.ofMutable(((AccessTippedArrowForItemsAndEmeralds)trade).crafttweaker$getToItem())));
        handler.registerTradeConverter(class_3853.class_4164.class, trade -> new CTTradeObject(emerald, IItemStack.ofMutable(((AccessItemsAndEmeraldsToItems)trade).crafttweaker$getFromItem()), IItemStack.ofMutable(((AccessItemsAndEmeraldsToItems)trade).crafttweaker$getToItem())));
        handler.registerTradeConverter(class_3853.class_4165.class, trade -> new CTTradeObject(emerald, IItemStack.empty(), IItemStack.ofMutable(((AccessItemsForEmeralds)trade).crafttweaker$getItemStack())));
        handler.registerTradeConverter(class_3853.class_4166.class, trade -> new CTTradeObject(emerald, IItemStack.empty(), suspiciousStew));
    }

    @Override
    public void registerCommands(ICommandRegistrationHandler handler) {
        ConflictCommand.registerCommands(handler);
        DumpCommands.registerCommands(handler);
        InventoryCommands.registerCommands(handler);
        HandCommands.registerCommands(handler);
        ScriptCommands.registerCommands(handler);
        MiscCommands.registerCommands(handler);
        ModCommands.registerCommands(handler);
        RecipeCommands.registerCommands(handler);
        ExamplesCommand.registerCommand(handler);
        DumpCommands.registerDumpers(handler);
    }

    @Override
    public void registerTaggableElements(ITaggableElementRegistrationHandler handler) {
        this.zenGatherer.onCandidates(candidate -> this.taggableElementsRegistrationManager.attemptRegistration(candidate.clazz(), handler));
    }

    @Override
    public void registerReplacerComponents(IReplacerComponentRegistrationHandler handler) {
        handler.registerTargetingFilter(DefaultTargetingFilters::scripts);
        handler.registerTargetingFilter(DefaultTargetingFilters::vanillaSpecial);
        handler.registerTargetingStrategy(ITargetingStrategy.DEFAULT_STRATEGY_ID, DefaultTargetingStrategies::shallow);
        handler.registerTargetingStrategy(CraftTweakerConstants.rl("deep"), DefaultTargetingStrategies::deep);
    }

    @Override
    public void registerEvents(IEventRegistrationHandler handler) {
        this.zenGatherer.onCandidates(candidate -> this.eventRegistrationManager.attemptRegistration(candidate.clazz(), handler));
    }
}

