/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type.conflict;

import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.command.argument.RecipeTypeArgument;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandlerRegistry;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.impl.command.type.conflict.DescriptiveFilter;
import com.blamejared.crafttweaker.impl.command.type.conflict.RecipeLongIterator;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessRecipeManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.ToIntBiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3956;

public final class ConflictCommand {
    private static final ExecutorService OFF_THREAD_SERVICE = Executors.newFixedThreadPool(1, r -> {
        Thread t = new Thread(r, "crafttweaker:conflict_resolution_thread");
        t.setDaemon(true);
        t.setContextClassLoader(ConflictCommand.class.getClassLoader());
        return t;
    });

    private ConflictCommand() {
    }

    public static void registerCommands(ICommandRegistrationHandler handler) {
        handler.registerRootCommand("conflicts", class_2561.method_43471((String)"crafttweaker.command.description.conflicts"), builder -> ((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(class_2170.method_9244((String)"type", (ArgumentType)RecipeTypeArgument.get()).executes(context -> ConflictCommand.conflicts((class_1657)((class_2168)context.getSource()).method_9207(), DescriptiveFilter.of((IRecipeManager)context.getArgument("type", IRecipeManager.class)))))).then(class_2170.method_9247((String)"hand").executes(context -> ConflictCommand.ifNotEmpty((CommandContext<class_2168>)context, (player, item) -> ConflictCommand.conflicts(player, DescriptiveFilter.of(item)))))).executes(context -> ConflictCommand.conflicts((class_1657)((class_2168)context.getSource()).method_9207(), DescriptiveFilter.of())));
    }

    private static int ifNotEmpty(CommandContext<class_2168> source, ToIntBiFunction<class_1657, class_1799> command) throws CommandSyntaxException {
        class_3222 player = ((class_2168)source.getSource()).method_9207();
        class_1799 stack = player.method_6047();
        if (stack.method_7960()) {
            CommandUtilities.send((class_2561)class_2561.method_43471((String)"crafttweaker.command.conflict.hand.empty").method_27692(class_124.field_1061), (class_1657)player);
            return -1;
        }
        return command.applyAsInt((class_1657)player, stack);
    }

    private static int conflicts(class_1657 player, DescriptiveFilter filter) {
        CommandUtilities.send((class_2561)class_2561.method_43469((String)"crafttweaker.command.conflict.begin", (Object[])new Object[]{filter.description()}).method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43471((String)"crafttweaker.command.conflict.warnings").method_27692(class_124.field_1061)), player);
        ConflictCommand.runConflicts(player, player.method_37908().method_8433(), filter);
        return 0;
    }

    private static void runConflicts(class_1657 player, class_1863 manager, DescriptiveFilter filter) {
        Map<class_3956<?>, Map<class_2960, class_1860<?>>> recipes = ConflictCommand.deepCopy(((AccessRecipeManager)manager).crafttweaker$getRecipes(), filter);
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> ConflictCommand.computeConflicts(recipes), OFF_THREAD_SERVICE).thenAcceptAsync(message -> ConflictCommand.dispatchCompletionTo(message, player), (Executor)OFF_THREAD_SERVICE)).exceptionallyAsync(exception -> ConflictCommand.dispatchExceptionTo(exception, player), (Executor)OFF_THREAD_SERVICE);
    }

    private static Map<class_3956<?>, Map<class_2960, class_1860<?>>> deepCopy(Map<class_3956<?>, Map<class_2960, class_1860<?>>> original, DescriptiveFilter filter) {
        HashMap clone = new HashMap();
        original.forEach((type, map) -> {
            Map cloneMap = clone.computeIfAbsent((class_3956<?>)type, it -> new HashMap());
            map.entrySet().stream().filter(filter).forEach(it -> cloneMap.put((class_2960)it.getKey(), (class_1860)it.getValue()));
        });
        return clone;
    }

    private static String computeConflicts(Map<class_3956<?>, Map<class_2960, class_1860<?>>> recipes) {
        return recipes.entrySet().stream().flatMap(ConflictCommand::computeConflictsFor).map(it -> "- " + it).collect(Collectors.joining("\n"));
    }

    private static Stream<String> computeConflictsFor(Map.Entry<class_3956<?>, Map<class_2960, class_1860<?>>> entry) {
        IRecipeManager<class_1860<?>> manager = RecipeTypeBracketHandler.getOrDefault(entry.getKey());
        if (manager == null) {
            return Stream.empty();
        }
        ArrayList recipes = new ArrayList(entry.getValue().entrySet());
        RecipeLongIterator iterator = new RecipeLongIterator(recipes.size());
        int characteristics = 1300;
        return StreamSupport.longStream(Spliterators.spliterator(iterator, iterator.estimateLength(), 1300), false).filter(it -> ConflictCommand.conflictsWith(manager, (class_1860)((Map.Entry)recipes.get(RecipeLongIterator.first(it))).getValue(), (class_1860)((Map.Entry)recipes.get(RecipeLongIterator.second(it))).getValue())).mapToObj(it -> ConflictCommand.formatConflict(manager, (class_2960)((Map.Entry)recipes.get(RecipeLongIterator.first(it))).getKey(), (class_2960)((Map.Entry)recipes.get(RecipeLongIterator.second(it))).getKey()));
    }

    private static <T extends class_1860<?>> boolean conflictsWith(IRecipeManager<?> manager, T first, class_1860<?> second) {
        return first != second && IRecipeHandlerRegistry.getHandlerFor(first).doesConflict((IRecipeManager)GenericUtil.uncheck(manager), first, second);
    }

    private static String formatConflict(IRecipeManager<?> manager, class_2960 firstName, class_2960 secondName) {
        return String.format("Recipes '%s' and '%s' in type '%s' have conflicting inputs", firstName, secondName, manager.getCommandString());
    }

    private static void dispatchCompletionTo(String message, class_1657 player) {
        try {
            CommandUtilities.COMMAND_LOGGER.info(message.isEmpty() ? "No conflicts identified" : message);
            CommandUtilities.send(CommandUtilities.openingLogFile(class_2561.method_43471((String)"crafttweaker.command.conflict.complete").method_27692(class_124.field_1060)), player);
        }
        catch (Exception e) {
            try {
                CommandUtilities.COMMAND_LOGGER.error("An error occurred while reporting conflicts, hopefully it does not happen again", (Throwable)e);
            }
            catch (Exception another) {
                e.addSuppressed(another);
                e.printStackTrace(System.err);
            }
        }
    }

    private static Void dispatchExceptionTo(Throwable exception, class_1657 player) {
        try {
            CommandUtilities.COMMAND_LOGGER.error("Unable to verify for conflicts due to an exception", exception);
            CommandUtilities.send(CommandUtilities.openingLogFile(class_2561.method_43471((String)"crafttweaker.command.conflict.error").method_27692(class_124.field_1061)), player);
        }
        catch (Exception e) {
            try {
                CommandUtilities.COMMAND_LOGGER.error("An error occurred while reporting conflicts, hopefully it does not happen again", (Throwable)e);
            }
            catch (Exception another) {
                e.addSuppressed(another);
                e.printStackTrace(System.err);
            }
        }
        return null;
    }
}

