/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.recipe.replace;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IRuntimeAction;
import com.blamejared.crafttweaker.api.action.internal.CraftTweakerAction;
import com.blamejared.crafttweaker.api.action.recipe.replace.ActionReplaceRecipe;
import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.GenericRecipesManager;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.recipe.replacement.IFilteringRule;
import com.blamejared.crafttweaker.api.recipe.replacement.IReplacerRegistry;
import com.blamejared.crafttweaker.api.recipe.replacement.ReplacementRequest;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import java.util.Collection;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1860;
import net.minecraft.class_2960;

public final class ActionBatchReplacement
extends CraftTweakerAction
implements IRuntimeAction {
    private final Collection<IFilteringRule> targetingRules;
    private final Collection<ReplacementRequest<?>> requests;
    private final IReplacerRegistry registry;

    private ActionBatchReplacement(Collection<IFilteringRule> targetingRules, Collection<ReplacementRequest<?>> requests) {
        this.targetingRules = targetingRules;
        this.requests = requests;
        this.registry = CraftTweakerAPI.getRegistry().getReplacerRegistry();
    }

    public static ActionBatchReplacement of(Collection<IFilteringRule> targetingRules, Collection<ReplacementRequest<?>> requests) {
        return new ActionBatchReplacement(targetingRules, requests);
    }

    @Override
    public void apply() {
        this.castFilters(GenericRecipesManager.INSTANCE.getAllRecipes().stream()).forEach(this::replace);
    }

    @Override
    public String describe() {
        Collector<CharSequence, ?, String> joiner = Collectors.joining(",", "{", "}");
        return "Replacing in %s according to requests %s".formatted(this.targetingRules.isEmpty() ? "everything" : this.targetingRules.stream().map(IFilteringRule::describe).collect(joiner), this.requests.stream().map(ReplacementRequest::describe).collect(joiner));
    }

    private Stream<? extends class_1860<?>> castFilters(Stream<? extends class_1860<?>> recipeStream) {
        return Stream.concat(this.registry.filters().stream(), this.targetingRules.stream()).reduce((a, b) -> it -> b.castFilter(a.castFilter(it))).map(it -> it.castFilter(recipeStream)).orElseGet(() -> (Stream)GenericUtil.uncheck(recipeStream));
    }

    private <C extends class_1263, T extends class_1860<C>> void replace(T recipe) {
        IRecipeHandler handler = CraftTweakerAPI.getRegistry().getRecipeHandlerFor(recipe);
        IRecipeManager manager = (IRecipeManager)GenericUtil.uncheck(RecipeTypeBracketHandler.getOrDefault(recipe.method_17716()));
        handler.decompose(manager, recipe).ifPresent(it -> this.replace(manager, handler, recipe.method_8114(), (IDecomposedRecipe)it));
    }

    private <C extends class_1263, T extends class_1860<C>> void replace(IRecipeManager<? super T> manager, IRecipeHandler<T> handler, class_2960 name, IDecomposedRecipe recipe) {
        if (this.apply(recipe)) {
            CraftTweakerAPI.apply(new ActionReplaceRecipe<class_1860>(name, manager, newName -> this.rebuild(recipe, manager, handler, (class_2960)newName)));
        }
    }

    private boolean apply(IDecomposedRecipe recipe) {
        boolean any = false;
        for (ReplacementRequest<?> request : this.requests) {
            any |= request.applyRequest(recipe);
        }
        return any;
    }

    private <C extends class_1263, T extends class_1860<C>> T rebuild(IDecomposedRecipe recipe, IRecipeManager<? super T> manager, IRecipeHandler<T> handler, class_2960 newName) {
        return (T)((class_1860)handler.recompose(manager, newName, recipe).orElseThrow(() -> new IllegalStateException("Recomposition failed due to an error")));
    }
}

