/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.recipe.jei;

import com.cyanogen.experienceobelisk.recipe.MolecularMetamorpherRecipe;
import com.cyanogen.experienceobelisk.registries.RegisterItems;
import com.cyanogen.experienceobelisk.utils.ExperienceUtils;
import com.cyanogen.experienceobelisk.utils.RecipeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class MolecularMetamorpherCategory
implements IRecipeCategory<MolecularMetamorpherRecipe> {
    IRecipeCategoryRegistration registration;
    IGuiHelper guiHelper;
    private final ResourceLocation texture = new ResourceLocation("experienceobelisk:textures/gui/recipes/molecular_metamorpher_jei.png");
    private final IDrawableAnimated arrow;

    public MolecularMetamorpherCategory(IRecipeCategoryRegistration registration) {
        this.registration = registration;
        this.guiHelper = registration.getJeiHelpers().getGuiHelper();
        this.arrow = this.guiHelper.drawableBuilder(this.texture, 0, 87, 29, 5).buildAnimated(100, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<MolecularMetamorpherRecipe> getRecipeType() {
        return RecipeType.create((String)"molecular_metamorphosis", (String)"experienceobelisk", MolecularMetamorpherRecipe.class);
    }

    public Component getTitle() {
        return Component.m_237115_((String)"title.experienceobelisk.molecular_metamorpher");
    }

    public IDrawable getBackground() {
        return this.guiHelper.createDrawable(this.texture, 0, 0, 176, 87);
    }

    @Nullable
    public ResourceLocation getRegistryName(MolecularMetamorpherRecipe recipe) {
        return super.getRegistryName((Object)recipe);
    }

    public IDrawable getIcon() {
        ItemStack icon = new ItemStack((ItemLike)RegisterItems.MOLECULAR_METAMORPHER_ITEM.get());
        return this.guiHelper.createDrawableItemStack(icon);
    }

    public void draw(MolecularMetamorpherRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 108, 47);
        Font font = Minecraft.m_91087_().f_91062_;
        int cost = recipe.getCost();
        int levelCost = ExperienceUtils.xpToLevels(cost);
        int xpBarLength = 61;
        double progress = ExperienceUtils.getProgressToNextLevel(cost, levelCost);
        if (progress == 0.0) {
            progress = 1.0;
        }
        guiGraphics.m_280218_(this.texture, this.getWidth() - 66, this.getHeight() - 12, 0, 92, (int)((double)xpBarLength * progress) + 2, 10);
        guiGraphics.m_280653_(font, (Component)Component.m_237113_((String)String.valueOf(levelCost)).m_130940_(ChatFormatting.GREEN), this.getWidth() - 31, this.getHeight() - 11, 0xFFFFFF);
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
    }

    public List<Component> getTooltipStrings(MolecularMetamorpherRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        int cost = recipe.getCost();
        int time = recipe.getProcessTime() / 20;
        MutableComponent c2 = Component.m_237113_((String)String.valueOf(cost)).m_130940_(ChatFormatting.GREEN);
        MutableComponent c3 = Component.m_237113_((String)(time + "s")).m_130940_(ChatFormatting.GOLD);
        MutableComponent costXP = Component.m_237110_((String)"jei.experienceobelisk.metamorpher.cost_xp", (Object[])new Object[]{c2});
        MutableComponent processTime = Component.m_237110_((String)"jei.experienceobelisk.metamorpher.process_time", (Object[])new Object[]{c3});
        ArrayList<Component> tooltip = new ArrayList<Component>();
        int x1 = this.getWidth() - 67;
        int x2 = this.getWidth();
        int y1 = this.getHeight() - 14;
        int y2 = this.getHeight();
        if (mouseX >= (double)x1 && mouseX <= (double)x2 && mouseY >= (double)y1 && mouseY <= (double)y2) {
            tooltip.add((Component)costXP);
            tooltip.add((Component)processTime);
            return tooltip;
        }
        return super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MolecularMetamorpherRecipe recipe, IFocusGroup focuses) {
        ItemStack result = recipe.m_8043_(null);
        int[] x = new int[]{19, 50, 70};
        int[] y = new int[]{35, 52, 18};
        for (Map.Entry<Ingredient, Tuple<Integer, Integer>> entry : recipe.getIngredientMapNoFiller().entrySet()) {
            int position = (Integer)entry.getValue().m_14418_() - 1;
            int count = (Integer)entry.getValue().m_14419_();
            Ingredient ingredient = entry.getKey();
            builder.addSlot(RecipeIngredientRole.INPUT, x[position], y[position]).setSlotName("input" + position).addItemStacks(RecipeUtils.getItemListWithCounts(ingredient, count));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 140, 35).setSlotName("output").addItemStack(result);
        if (!recipe.m_6423_().equals((Object)new ResourceLocation("experienceobelisk", "item_name_formatting"))) {
            builder.setShapeless();
        }
    }
}

