/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.network.experience_obelisk;

import com.cyanogen.experienceobelisk.block_entities.ExperienceObeliskEntity;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class UpdateRadius {
    public static BlockPos pos;
    public static double changeInRadius;

    public UpdateRadius(BlockPos pos, double changeInRadius) {
        UpdateRadius.pos = pos;
        UpdateRadius.changeInRadius = changeInRadius;
    }

    public UpdateRadius(FriendlyByteBuf buffer) {
        pos = buffer.m_130135_();
        changeInRadius = buffer.readDouble();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(pos);
        buffer.writeDouble(changeInRadius);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            assert (sender != null);
            BlockEntity serverEntity = sender.m_9236_().m_7702_(pos);
            if (serverEntity instanceof ExperienceObeliskEntity) {
                ExperienceObeliskEntity xpobelisk = (ExperienceObeliskEntity)serverEntity;
                double finalRadius = xpobelisk.getRadius() + changeInRadius;
                if (changeInRadius == 0.0) {
                    xpobelisk.setRadius(2.5);
                } else if (finalRadius >= 1.0 && finalRadius <= 5.0) {
                    xpobelisk.setRadius(finalRadius);
                }
            }
            success.set(true);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

