/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.thedragonlib.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.client.resources.language.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.text.WordUtils;

@OnlyIn(value=Dist.CLIENT)
public class TextHelper {
    public static String getFormattedText(String string) {
        return string.replaceAll("&", "\u00a7");
    }

    public static String localize(String input, Object ... format) {
        return I18n.m_118938_((String)input, (Object[])format);
    }

    public static String localizeEffect(String input, Object ... format) {
        return TextHelper.getFormattedText(TextHelper.localize(input, format));
    }

    public static String[] localizeAll(String[] input) {
        return (String[])Arrays.stream(input).map(x$0 -> TextHelper.localize(x$0, new Object[0])).toArray(String[]::new);
    }

    public static String[] localizeAllEffect(String[] input) {
        return (String[])Arrays.stream(input).map(x$0 -> TextHelper.localizeEffect(x$0, new Object[0])).toArray(String[]::new);
    }

    public static List<String> localizeAll(List<String> input) {
        ArrayList<String> ret = new ArrayList<String>(input.size());
        IntStream.range(0, input.size()).forEachOrdered(i -> ret.add(i, TextHelper.localize((String)input.get(i), new Object[0])));
        return ret;
    }

    public static List<String> localizeAllEffect(List<String> input) {
        ArrayList<String> ret = new ArrayList<String>(input.size());
        IntStream.range(0, input.size()).forEachOrdered(i -> ret.add(i, TextHelper.localizeEffect((String)input.get(i), new Object[0])));
        return ret;
    }

    public static String[] cutLongString(String string, int characters) {
        return WordUtils.wrap((String)string, (int)characters, (String)"/cut", (boolean)false).split("/cut");
    }

    public static String[] cutLongString(String string) {
        return TextHelper.cutLongString(string, 30);
    }
}

