/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.thedragonlib.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemStackUtils {
    public static Item getItemByName(String name) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
    }

    public static ItemStack getTICItemStack(String name, int meta) {
        return ItemStackUtils.getItemStack("tconstruct", name, meta);
    }

    public static ItemStack getAPItemStack(String name, int meta) {
        return ItemStackUtils.getItemStack("armorplus", name, meta);
    }

    public static ItemStack getAPItemStack(String name) {
        return ItemStackUtils.getAPItemStack(name, 0);
    }

    public static ItemStack getItemStack(String modid, String itemName, int meta) {
        return ItemStackUtils.getItemStack(ItemStackUtils.getItemByName(modid + ":" + itemName), meta);
    }

    public static ItemStack getItemStack(String modid, String itemName) {
        return ItemStackUtils.getItemStack(modid, itemName, 0);
    }

    public static ItemStack getItemStack(Object type, int amount) {
        if (type instanceof String) {
            return new ItemStack((ItemLike)Objects.requireNonNull(ItemStackUtils.getItemByName((String)type)), amount);
        }
        if (type instanceof Block) {
            return new ItemStack((ItemLike)((Block)type), amount);
        }
        if (type instanceof Item) {
            return new ItemStack((ItemLike)((Item)type), amount);
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getItemStack(Object type) {
        if (type instanceof String) {
            return ItemStackUtils.getItemStack(ItemStackUtils.getItemByName((String)type), 0);
        }
        if (type instanceof Block) {
            return ItemStackUtils.getItemStack(type, 0);
        }
        if (type instanceof Item) {
            return ItemStackUtils.getItemStack(type, 0);
        }
        if (type instanceof ItemStack) {
            return (ItemStack)type;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getEmptyStack() {
        return ItemStack.f_41583_;
    }

    public static Item getItem(Object type) {
        if (type instanceof String) {
            return ItemStackUtils.getItemByName((String)type);
        }
        if (type instanceof ItemStack) {
            return ((ItemStack)type).m_41720_();
        }
        return ItemStack.f_41583_.m_41720_();
    }

    public static Item getItem(String modName, String itemName) {
        return ItemStackUtils.getItemByName(modName + ":" + itemName);
    }

    public static Item getEmptyItem() {
        return ItemStack.f_41583_.m_41720_();
    }

    public static ItemStack validateCopy(ItemStack stack) {
        return ItemStackUtils.isValid(stack) ? stack.m_41777_() : ItemStackUtils.getNull();
    }

    public static ItemStack validateCheck(ItemStack stack) {
        return ItemStackUtils.isValid(stack) ? stack : ItemStackUtils.getNull();
    }

    public static boolean isValid(ItemStack stack) {
        return stack != null && !stack.m_41619_();
    }

    public static ItemStack getNull() {
        return ItemStack.f_41583_;
    }

    public static int getStackSize(ItemStack stack) {
        return !ItemStackUtils.isValid(stack) ? 0 : stack.m_41613_();
    }

    public static ItemStack setStackSize(ItemStack stack, int size) {
        return ItemStackUtils.setStackSize(stack, size, false);
    }

    public static ItemStack setStackSize(ItemStack stack, int size, boolean containerOnEmpty) {
        if (size <= 0) {
            return ItemStackUtils.isValid(stack) && containerOnEmpty ? stack.m_41720_().getCraftingRemainingItem(stack) : ItemStackUtils.getNull();
        }
        stack.m_41764_(size);
        return stack;
    }

    public static ItemStack addStackSize(ItemStack stack, int size) {
        return ItemStackUtils.addStackSize(stack, size, false);
    }

    public static ItemStack addStackSize(ItemStack stack, int size, boolean containerOnEmpty) {
        return ItemStackUtils.setStackSize(stack, ItemStackUtils.getStackSize(stack) + size, containerOnEmpty);
    }

    public static boolean isIInvEmpty(NonNullList<ItemStack> slots) {
        return slots.stream().noneMatch(ItemStackUtils::isValid);
    }

    public static NonNullList<ItemStack> createSlots(int size) {
        return NonNullList.m_122780_((int)size, (Object)ItemStackUtils.getNull());
    }

    public static NonNullList<ItemStack> getItemStacks(Item ... items) {
        NonNullList list = NonNullList.m_122779_();
        Arrays.stream(items).map(ItemStackUtils::getItemStack).forEachOrdered(arg_0 -> list.add(arg_0));
        return list;
    }

    public static NonNullList<ItemStack> getItemStacks(ItemStack ... itemStacks) {
        NonNullList list = NonNullList.m_122779_();
        Collections.addAll(list, itemStacks);
        return list;
    }
}

