/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.subnauticaflow.network;

import java.util.function.Supplier;
import net.mcreator.subnauticaflow.SubnauticaFlowMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SubnauticaFlowModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        SubnauticaFlowMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        SubnauticaFlowMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.scannedseamonkey = message.data.scannedseamonkey;
                    variables.scannedbleeder = message.data.scannedbleeder;
                    variables.scannedcrabsnake = message.data.scannedcrabsnake;
                    variables.scannedgasopod = message.data.scannedgasopod;
                    variables.scannedshadowleviathan = message.data.scannedshadowleviathan;
                    variables.scannedlilypaddler = message.data.scannedlilypaddler;
                    variables.psykey = message.data.psykey;
                    variables.scannedsquidleviathan = message.data.scannedsquidleviathan;
                    variables.peeper = message.data.peeper;
                    variables.oculus = message.data.oculus;
                    variables.khaaraactive = message.data.khaaraactive;
                    variables.khaaratimer = message.data.khaaratimer;
                    variables.khaaraspawncool = message.data.khaaraspawncool;
                    variables.scannedkhaara = message.data.scannedkhaara;
                    variables.cured = message.data.cured;
                    variables.khaarastage5 = message.data.khaarastage5;
                    variables.scannedpengwing = message.data.scannedpengwing;
                    variables.playerx = message.data.playerx;
                    variables.playery = message.data.playery;
                    variables.playerz = message.data.playerz;
                    variables.IsScannedSnowStalker = message.data.IsScannedSnowStalker;
                    variables.IsScannedHoverfish = message.data.IsScannedHoverfish;
                    variables.IsScannedEmperor = message.data.IsScannedEmperor;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean scannedseamonkey = false;
        public boolean scannedbleeder = false;
        public boolean scannedcrabsnake = false;
        public boolean scannedgasopod = false;
        public boolean scannedshadowleviathan = false;
        public boolean scannedlilypaddler = false;
        public double psykey = 0.0;
        public boolean scannedsquidleviathan = false;
        public boolean peeper = false;
        public boolean oculus = false;
        public boolean khaaraactive = false;
        public double khaaratimer = 0.0;
        public double khaaraspawncool = 0.0;
        public boolean scannedkhaara = false;
        public boolean cured = false;
        public boolean khaarastage5 = false;
        public boolean scannedpengwing = false;
        public double playerx = 0.0;
        public double playery = 0.0;
        public double playerz = 0.0;
        public boolean IsScannedSnowStalker = false;
        public boolean IsScannedHoverfish = false;
        public boolean IsScannedEmperor = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                SubnauticaFlowMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("scannedseamonkey", this.scannedseamonkey);
            nbt.m_128379_("scannedbleeder", this.scannedbleeder);
            nbt.m_128379_("scannedcrabsnake", this.scannedcrabsnake);
            nbt.m_128379_("scannedgasopod", this.scannedgasopod);
            nbt.m_128379_("scannedshadowleviathan", this.scannedshadowleviathan);
            nbt.m_128379_("scannedlilypaddler", this.scannedlilypaddler);
            nbt.m_128347_("psykey", this.psykey);
            nbt.m_128379_("scannedsquidleviathan", this.scannedsquidleviathan);
            nbt.m_128379_("peeper", this.peeper);
            nbt.m_128379_("oculus", this.oculus);
            nbt.m_128379_("khaaraactive", this.khaaraactive);
            nbt.m_128347_("khaaratimer", this.khaaratimer);
            nbt.m_128347_("khaaraspawncool", this.khaaraspawncool);
            nbt.m_128379_("scannedkhaara", this.scannedkhaara);
            nbt.m_128379_("cured", this.cured);
            nbt.m_128379_("khaarastage5", this.khaarastage5);
            nbt.m_128379_("scannedpengwing", this.scannedpengwing);
            nbt.m_128347_("playerx", this.playerx);
            nbt.m_128347_("playery", this.playery);
            nbt.m_128347_("playerz", this.playerz);
            nbt.m_128379_("IsScannedSnowStalker", this.IsScannedSnowStalker);
            nbt.m_128379_("IsScannedHoverfish", this.IsScannedHoverfish);
            nbt.m_128379_("IsScannedEmperor", this.IsScannedEmperor);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.scannedseamonkey = nbt.m_128471_("scannedseamonkey");
            this.scannedbleeder = nbt.m_128471_("scannedbleeder");
            this.scannedcrabsnake = nbt.m_128471_("scannedcrabsnake");
            this.scannedgasopod = nbt.m_128471_("scannedgasopod");
            this.scannedshadowleviathan = nbt.m_128471_("scannedshadowleviathan");
            this.scannedlilypaddler = nbt.m_128471_("scannedlilypaddler");
            this.psykey = nbt.m_128459_("psykey");
            this.scannedsquidleviathan = nbt.m_128471_("scannedsquidleviathan");
            this.peeper = nbt.m_128471_("peeper");
            this.oculus = nbt.m_128471_("oculus");
            this.khaaraactive = nbt.m_128471_("khaaraactive");
            this.khaaratimer = nbt.m_128459_("khaaratimer");
            this.khaaraspawncool = nbt.m_128459_("khaaraspawncool");
            this.scannedkhaara = nbt.m_128471_("scannedkhaara");
            this.cured = nbt.m_128471_("cured");
            this.khaarastage5 = nbt.m_128471_("khaarastage5");
            this.scannedpengwing = nbt.m_128471_("scannedpengwing");
            this.playerx = nbt.m_128459_("playerx");
            this.playery = nbt.m_128459_("playery");
            this.playerz = nbt.m_128459_("playerz");
            this.IsScannedSnowStalker = nbt.m_128471_("IsScannedSnowStalker");
            this.IsScannedHoverfish = nbt.m_128471_("IsScannedHoverfish");
            this.IsScannedEmperor = nbt.m_128471_("IsScannedEmperor");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("subnautica_flow", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "subnautica_flow_mapvars";
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                SubnauticaFlowMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "subnautica_flow_worldvars";
        public boolean worldstart = false;
        public double KhaaraSpreadCooldown = 0.0;
        public boolean allowentityspreadding = false;
        public double khaaratickingspeed = 0.0;
        public double hungerincrease = 1.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.worldstart = nbt.m_128471_("worldstart");
            this.KhaaraSpreadCooldown = nbt.m_128459_("KhaaraSpreadCooldown");
            this.allowentityspreadding = nbt.m_128471_("allowentityspreadding");
            this.khaaratickingspeed = nbt.m_128459_("khaaratickingspeed");
            this.hungerincrease = nbt.m_128459_("hungerincrease");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("worldstart", this.worldstart);
            nbt.m_128347_("KhaaraSpreadCooldown", this.KhaaraSpreadCooldown);
            nbt.m_128379_("allowentityspreadding", this.allowentityspreadding);
            nbt.m_128347_("khaaratickingspeed", this.khaaratickingspeed);
            nbt.m_128347_("hungerincrease", this.hungerincrease);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                SubnauticaFlowMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.scannedseamonkey = original.scannedseamonkey;
            clone.scannedbleeder = original.scannedbleeder;
            clone.scannedcrabsnake = original.scannedcrabsnake;
            clone.scannedgasopod = original.scannedgasopod;
            clone.scannedshadowleviathan = original.scannedshadowleviathan;
            clone.scannedlilypaddler = original.scannedlilypaddler;
            clone.psykey = original.psykey;
            clone.scannedsquidleviathan = original.scannedsquidleviathan;
            clone.peeper = original.peeper;
            clone.oculus = original.oculus;
            clone.khaaraactive = original.khaaraactive;
            clone.khaaratimer = original.khaaratimer;
            clone.khaaraspawncool = original.khaaraspawncool;
            clone.scannedkhaara = original.scannedkhaara;
            clone.cured = original.cured;
            clone.khaarastage5 = original.khaarastage5;
            clone.scannedpengwing = original.scannedpengwing;
            clone.playerx = original.playerx;
            clone.playery = original.playery;
            clone.playerz = original.playerz;
            clone.IsScannedSnowStalker = original.IsScannedSnowStalker;
            clone.IsScannedHoverfish = original.IsScannedHoverfish;
            clone.IsScannedEmperor = original.IsScannedEmperor;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    SubnauticaFlowMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    SubnauticaFlowMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                SubnauticaFlowMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

