/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.subnauticaflow.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.subnauticaflow.SubnauticaFlowMod;
import net.mcreator.subnauticaflow.procedures.TpBloodKelpProcedure;
import net.mcreator.subnauticaflow.procedures.TpBulbProcedure;
import net.mcreator.subnauticaflow.procedures.TpEarthProcedure;
import net.mcreator.subnauticaflow.procedures.TpFloatingProcedure;
import net.mcreator.subnauticaflow.procedures.TpGrassyProcedure;
import net.mcreator.subnauticaflow.procedures.TpJellyProcedure;
import net.mcreator.subnauticaflow.procedures.TpKelpForestProcedure;
import net.mcreator.subnauticaflow.procedures.TpLavaProcedure;
import net.mcreator.subnauticaflow.procedures.TpLostProcedure;
import net.mcreator.subnauticaflow.procedures.TpMushroomProcedure;
import net.mcreator.subnauticaflow.procedures.TpSafeShallowsProcedure;
import net.mcreator.subnauticaflow.world.inventory.RocketMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RocketButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public RocketButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public RocketButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(RocketButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(RocketButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            RocketButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = RocketMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            TpSafeShallowsProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            TpGrassyProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            TpKelpForestProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            TpMushroomProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            TpFloatingProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            TpBulbProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            TpBloodKelpProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            TpLostProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            TpLavaProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            TpJellyProcedure.execute((Entity)entity);
        }
        if (buttonID == 10) {
            TpEarthProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SubnauticaFlowMod.addNetworkMessage(RocketButtonMessage.class, RocketButtonMessage::buffer, RocketButtonMessage::new, RocketButtonMessage::handler);
    }
}

