/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.utils;

public class RomanNumeralUtil {
    private static final int MIN_VALUE = 1;
    private static final int MAX_VALUE = 5999;
    private static final String[] RN_M = new String[]{"", "M", "MM", "MMM", "MMMM", "MMMMM"};
    private static final String[] RN_C = new String[]{"", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM"};
    private static final String[] RN_X = new String[]{"", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC"};
    private static final String[] RN_I = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"};

    public static String generate(int number) {
        if (number < 1 || number > 5999) {
            throw new IllegalArgumentException(String.format("The number must be in the range [%d, %d]", 1, 5999));
        }
        return RN_M[number / 1000] + RN_C[number % 1000 / 100] + RN_X[number % 100 / 10] + RN_I[number % 10];
    }
}

