/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.items.tools.properties.mace;

import com.sofodev.armorplus.registry.items.tools.properties.mace.APMaceType;
import com.sofodev.armorplus.registry.items.tools.properties.mace.DestructionShape;
import com.sofodev.armorplus.registry.items.tools.properties.mace.IAPMace;
import com.sofodev.armorplus.registry.items.tools.properties.tool.APToolMaterial;
import java.util.Locale;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;

public enum APMaceMaterial implements IAPMace
{
    COAL_MACE(APToolMaterial.COAL_MAT, APMaceType.LIGHT, 5, 1),
    REDSTONE_MACE(APToolMaterial.REDSTONE_MAT, APMaceType.LIGHT, 5, 2),
    LAPIS_MACE(APToolMaterial.LAPIS_MAT, APMaceType.LIGHT, 5, 2),
    EMERALD_MACE(APToolMaterial.EMERALD_MAT, APMaceType.NORMAL, 10, 4, DestructionShape.PLUS),
    OBSIDIAN_MACE(APToolMaterial.OBSIDIAN_MAT, APMaceType.NORMAL, 10, 4, DestructionShape.PLUS),
    INFUSED_LAVA_MACE(APToolMaterial.INFUSED_LAVA_MAT, APMaceType.NORMAL, 12, 6, DestructionShape.PLUS),
    GUARDIAN_MACE(APToolMaterial.GUARDIAN_MAT, APMaceType.HEAVY, 15, 9, DestructionShape.PLUS),
    SUPER_STAR_MACE(APToolMaterial.SUPER_STAR_MAT, APMaceType.HEAVY, 15, 9, DestructionShape.PLUS),
    ENDER_DRAGON_MACE(APToolMaterial.ENDER_DRAGON_MAT, APMaceType.HEAVY, 17, 10, DestructionShape.SQUARE),
    SLAYER_MACE(APToolMaterial.SLAYER_MAT, APMaceType.HEAVY, 20, 12, DestructionShape.SQUARE);

    private final Tier material;
    private final Rarity rarity;
    private final APMaceType type;
    private final int cooldown;
    private final int range;
    private final boolean hasAOEDestruction;
    private final DestructionShape shape;

    private APMaceMaterial(APToolMaterial material, APMaceType type, int cooldown, int range) {
        this(material, type, cooldown, range, false, DestructionShape.SQUARE);
    }

    private APMaceMaterial(APToolMaterial material, APMaceType type, int cooldown, int range, DestructionShape shape) {
        this(material, type, cooldown, range, true, shape);
    }

    private APMaceMaterial(APToolMaterial material, APMaceType type, int cooldown, int range, boolean hasAOE, DestructionShape shape) {
        this.material = material.get();
        this.rarity = material.getRarity();
        this.type = type;
        this.cooldown = cooldown;
        this.range = range;
        this.hasAOEDestruction = hasAOE;
        this.shape = shape;
    }

    @Override
    public Tier get() {
        return this.material;
    }

    @Override
    public Rarity getRarity() {
        return this.rarity;
    }

    @Override
    public APMaceType getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name().toLowerCase(Locale.ENGLISH).replace("_mace", "");
    }

    @Override
    public int cooldown() {
        return this.cooldown;
    }

    @Override
    public int destructionRange() {
        return this.range;
    }

    @Override
    public boolean hasAOEDestruction() {
        return this.hasAOEDestruction;
    }

    @Override
    public DestructionShape getShape() {
        return this.shape;
    }

    public String toString() {
        return "APMaceMaterial{material=" + this.material + ", rarity=" + this.rarity + ", type=" + this.type + ", cooldown=" + this.cooldown + ", range=" + this.range + ", hasAOEDestruction=" + this.hasAOEDestruction + ", shape=" + this.shape + "}";
    }
}

