/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.items.tools;

import com.sofodev.armorplus.registry.items.tools.properties.mace.DestructionShape;
import com.sofodev.armorplus.registry.items.tools.properties.mace.IAPMace;
import com.sofodev.armorplus.registry.items.tools.render.APMaceRenderer;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class APMaceItem
extends SwordItem
implements GeoItem {
    private static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("animation.mace.attack");
    private static final RawAnimation SWIPE_ATTACK = RawAnimation.begin().thenPlay("animation.mace.swipe_attack");
    private static final RawAnimation SWING_ATTACK = RawAnimation.begin().thenPlay("animation.mace.swing_attack");
    private static final RawAnimation CHARGE = RawAnimation.begin().thenPlay("animation.mace.charge");
    private static final RawAnimation HOLD_CHARGE = RawAnimation.begin().thenPlay("animation.mace.hold_charge");
    public final IAPMace mat;
    public final String controllerName = "maceController";
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    Random random = new Random();

    public APMaceItem(IAPMace mat, Item.Properties props) {
        super(mat.get(), (int)(mat.get().m_6631_() + mat.getType().getDmg()), mat.getType().getAttackSpeed(), props);
        this.mat = mat;
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private APMaceRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new APMaceRenderer();
                }
                return this.renderer;
            }
        });
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return super.m_6832_(toRepair, repair);
    }

    public boolean m_41468_() {
        return super.m_41468_();
    }

    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public Rarity m_41460_(ItemStack stack) {
        return this.mat.getRarity();
    }

    public int m_8105_(ItemStack stack) {
        return (int)this.mat.getType().getChargeSpeed() * 2000;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity living, int timeLeft) {
        if (living instanceof Player) {
            int chargeTime;
            Player player = (Player)living;
            CompoundTag nbt = stack.m_41783_();
            if (nbt != null && nbt.m_128403_("key") && (float)(chargeTime = this.m_8105_(stack) - timeLeft) >= this.mat.getType().getChargeSpeed() && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)player.m_21120_(player.m_7655_()), (ServerLevel)serverLevel), "maceController", "animation.mace.swing_attack");
                boolean isOffHandEmpty = player.m_6844_(EquipmentSlot.OFFHAND).m_41619_();
                if (isOffHandEmpty) {
                    boolean isWestOrEast;
                    BlockPos destructionPos = new BlockPos((int)player.m_20182_().f_82479_, (int)player.m_20182_().f_82480_, (int)player.m_20182_().f_82481_);
                    Direction direction = player.m_6374_();
                    boolean isNorthOrSouth = direction == Direction.NORTH || direction == Direction.SOUTH;
                    boolean bl = isWestOrEast = direction == Direction.EAST || direction == Direction.WEST;
                    if (isNorthOrSouth) {
                        this.executeDestruction(player, this.mat, level, stack, destructionPos, direction, true);
                    } else if (isWestOrEast) {
                        this.executeDestruction(player, this.mat, level, stack, destructionPos, direction, false);
                    }
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack stack = this.setTag(player.m_21120_(hand));
            CompoundTag nbt = stack.m_41783_();
            if (nbt != null && nbt.m_128403_("key")) {
                this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)player.m_21120_(hand), (ServerLevel)serverLevel), "maceController", "animation.mace.hold_charge");
            }
            if (stack.m_41773_() >= stack.m_41776_() - 1) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack itemStack = this.setTag(stack);
            CompoundTag nbt = stack.m_41783_();
            if (nbt != null && nbt.m_128403_("key")) {
                this.triggerAnim((Entity)entity, GeoItem.getOrAssignId((ItemStack)entity.m_21120_(entity.m_7655_()), (ServerLevel)serverLevel), "maceController", "animation.mace.swing_attack");
            }
        }
        return true;
    }

    public ItemStack setTag(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        UUID randomUUID = UUID.randomUUID();
        if (tag == null) {
            tag = new CompoundTag();
            tag.m_128362_("key", randomUUID);
            stack.m_41751_(tag);
        }
        if (!tag.m_128403_("key")) {
            tag.m_128362_("key", randomUUID);
        }
        stack.m_41751_(tag);
        return stack;
    }

    public UseAnim m_6164_(ItemStack p_41452_) {
        return UseAnim.NONE;
    }

    private void executeDestruction(Player player, IAPMace mat, Level world, ItemStack stack, BlockPos destructionPos, Direction direction, boolean flag) {
        this.destroyBlocksInLineDirectional(mat, world, destructionPos, direction, flag);
        int damage = mat.destructionRange();
        stack.m_41622_(this.random.nextInt(damage) + damage * damage, (LivingEntity)player, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        player.m_36335_().m_41524_(stack.m_41720_(), mat.cooldown() * 20);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
    }

    private void destroyBlocksInLineDirectional(IAPMace mat, Level world, BlockPos destructionPos, Direction direction, boolean isNorthOrSouth) {
        IntStream.range(0, mat.destructionRange()).forEach(offset -> {
            if (mat.hasAOEDestruction()) {
                BlockPos eastOrSouth;
                BlockPos westOrNorth = isNorthOrSouth ? destructionPos.m_122024_() : destructionPos.m_122012_();
                BlockPos blockPos = eastOrSouth = isNorthOrSouth ? destructionPos.m_122029_() : destructionPos.m_122019_();
                if (mat.getShape() == DestructionShape.SQUARE) {
                    this.destroyBlockInLine(world, destructionPos, direction, offset);
                    this.destroyBlockInLine(world, westOrNorth, direction, offset);
                    this.destroyBlockInLine(world, eastOrSouth, direction, offset);
                } else if (mat.getShape() == DestructionShape.PLUS) {
                    this.destroyBlockInLine(world, destructionPos, direction, offset);
                    this.destroyBlockSingleLine(world, westOrNorth, direction, offset);
                    this.destroyBlockSingleLine(world, eastOrSouth, direction, offset);
                }
            } else {
                this.destroyBlockSingleLine(world, destructionPos, direction, offset);
            }
        });
    }

    private void destroyBlockInLine(Level world, BlockPos destructionPos, Direction direction, int offset) {
        BlockPos pos = this.directionalOffset(destructionPos, direction, offset);
        this.destroyBlock(world, pos);
        this.destroyBlock(world, pos.m_7494_());
        this.destroyBlock(world, pos.m_7494_().m_7494_());
    }

    private void destroyBlockSingleLine(Level world, BlockPos destructionPos, Direction direction, int i) {
        this.destroyBlock(world, this.directionalOffset(destructionPos, direction, i).m_7494_());
    }

    private void destroyBlock(Level world, BlockPos pos) {
        if (!world.m_8055_(pos).m_204336_(BlockTags.f_13070_)) {
            world.m_46961_(pos, true);
        }
    }

    private BlockPos directionalOffset(BlockPos pos, Direction direction, int offset) {
        return pos.m_5484_(direction, offset + 1);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, this.controllerName, 20, this::predicate).triggerableAnim("swing_attack", SWING_ATTACK)});
    }

    private <P extends Item> PlayState predicate(AnimationState<P> event) {
        ItemStack stack = (ItemStack)event.getData(DataTickets.ITEMSTACK);
        if (!stack.m_41619_()) {
            return stack.m_41794_() ? PlayState.STOP : PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object o) {
        return 0.0;
    }
}

