/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.items.materials;

import com.sofodev.armorplus.registry.items.APItem;
import com.sofodev.armorplus.utils.ToolTipUtils;
import com.sofodev.armorplus.utils.Utils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class LavaCrystalItem
extends APItem {
    private final boolean isInfused;
    private int[] burnTime = new int[]{20000, 22000};

    public LavaCrystalItem(boolean isInfused) {
        super(new Item.Properties().m_41486_());
        this.isInfused = isInfused;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!this.isInfused) {
            tooltip.add((Component)ToolTipUtils.translate("tooltip.armorplus.lava_crystal.how_to_infuse", new Object[0]).m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_131148_(TextColor.m_131268_((String)"#670067"))));
        } else {
            tooltip.add((Component)ToolTipUtils.translate("tooltip.armorplus.lava_crystal.lore", new Object[0]).m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_131148_(TextColor.m_131268_((String)"#670067"))));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        boolean isInLava = entity.m_20193_().m_6425_(entity.m_20183_()).m_205070_(FluidTags.f_13132_);
        if (!this.isInfused && isInLava) {
            entity.m_19983_(new ItemStack((ItemLike)Utils.getAPItem("infused_lava_crystal"), entity.m_32055_().m_41613_()));
            entity.m_32055_().m_41764_(0);
            return true;
        }
        return false;
    }

    public boolean m_41386_(DamageSource damageSource) {
        return super.m_41386_(damageSource);
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.create((String)"Lava Crystalic", (ChatFormatting)ChatFormatting.GOLD);
    }

    public int getBurnTime(ItemStack itemStack, RecipeType<?> recipeType) {
        return this.isInfused ? this.burnTime[1] : this.burnTime[0];
    }

    public boolean isInfused() {
        return this.isInfused;
    }
}

