/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.items.extras;

import com.sofodev.armorplus.registry.ModPotions;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

public class EffectData {
    private final MobEffect effect;
    private final int duration;
    private final int amplifier;

    public EffectData(MobEffect effect, int duration, int amplifier) {
        this.effect = effect;
        this.duration = duration;
        this.amplifier = amplifier;
    }

    public EffectData(MobEffect effect, int amplifier) {
        this(effect, 180, amplifier);
    }

    public EffectData(MobEffect effect) {
        this(effect, 180, 0);
    }

    public static EffectData create(MobEffect effect, int duration, int amplifier) {
        return new EffectData(effect, duration, amplifier);
    }

    public static EffectData create(MobEffect effect, int amplifier) {
        return new EffectData(effect, amplifier);
    }

    public static EffectData create(MobEffect effect) {
        return new EffectData(effect);
    }

    public MobEffectInstance getInstance() {
        return new MobEffectInstance(this.effect, this.duration, this.amplifier);
    }

    public MobEffect getEffect() {
        return this.effect != null ? this.effect : (MobEffect)ModPotions.EMPTY.get();
    }

    public int getDuration() {
        return this.duration;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public String toString() {
        return "EffectData{effect=" + this.effect + ", duration=" + this.duration + ", amplifier=" + this.amplifier + "}";
    }
}

