/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.items.extras;

import com.sofodev.armorplus.registry.items.extras.IBuff;
import com.sofodev.armorplus.utils.Utils;
import java.util.Locale;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Buff implements IBuff
{
    NONE(false, false),
    NIGHT_VISION,
    WATER_BREATHING,
    STRENGTH,
    SPEED,
    HASTE,
    JUMP_BOOST,
    REGENERATION,
    RESISTANCE,
    FIRE_RESISTANCE,
    SATURATION,
    INVISIBILITY,
    HEALTH_BOOST,
    ABSORPTION,
    SLOW_FALLING,
    FLIGHT(true){}
    ,
    WITHER_IMMUNITY(true){

        @Override
        public void onArmorTick(ItemStack stack, Level world, Player player) {
            if (!world.f_46443_) {
                player.m_21195_(MobEffects.f_19615_);
            }
        }
    }
    ,
    WATER_WEAKNESS(true){

        @Override
        public void onArmorTick(ItemStack stack, Level world, Player player) {
            int supply;
            boolean water;
            if (!world.f_46443_ && (water = player.m_5842_()) && (supply = player.m_20146_()) > 1 && supply <= player.m_6062_()) {
                player.m_20301_(supply / 2);
            }
        }
    }
    ,
    FIRE_WEAKNESS(true){

        @Override
        public void onArmorTick(ItemStack stack, Level world, Player player) {
            boolean fire;
            if (!world.f_46443_ && (fire = player.m_6060_())) {
                player.m_7311_(player.m_20094_() + 5);
            }
        }
    }
    ,
    NATURAL_IMMUNITY(true){

        @Override
        public void onArmorTick(ItemStack stack, Level world, Player player) {
            if (!player.m_21023_(FIRE_RESISTANCE.getEffect())) {
                player.m_7292_(new MobEffectInstance(FIRE_RESISTANCE.getEffect(), 60, 0, false, false));
            }
            if (!player.m_21023_(RESISTANCE.getEffect())) {
                player.m_7292_(new MobEffectInstance(RESISTANCE.getEffect(), 60, 0, false, false));
            }
            if (!world.f_46443_ && player.m_20094_() > 0) {
                player.m_20095_();
            }
        }
    }
    ,
    FIRE_EXTINGUISH(true){

        @Override
        public void onArmorTick(ItemStack stack, Level world, Player player) {
            if (!world.f_46443_ && player.m_20094_() > 0) {
                player.m_20095_();
            }
        }
    };

    private final boolean isEffect;
    private final MobEffect effect;
    private final boolean requireFullSet;

    private Buff(boolean isEffect, boolean requireFullSet) {
        this.isEffect = isEffect;
        this.effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(Utils.setVanillaLocation(this.name().toLowerCase(Locale.ENGLISH)));
        this.requireFullSet = requireFullSet;
    }

    private Buff(boolean requireFullSet) {
        this(false, requireFullSet);
    }

    private Buff() {
        this(true, true);
    }

    @Override
    public boolean isEffect() {
        return this.isEffect;
    }

    @Override
    public MobEffect getEffect() {
        return this.effect;
    }

    @Override
    public boolean requiresFullSet() {
        return this.requireFullSet;
    }

    public String toString() {
        return "Buff{isEffect=" + this.isEffect + ", effect=" + this.effect + ", requireFullSet=" + this.requireFullSet + "}";
    }
}

