/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.items.armors;

import com.sofodev.armorplus.registry.items.armors.APRepair;
import com.sofodev.armorplus.utils.Utils;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum APArmorProperties implements ArmorMaterial
{
    COAL_PROP(2, new int[]{1, 1, 2, 1}, 8, SoundEvents.f_11678_, new ItemLike[]{Items.f_42413_, Items.f_42200_}),
    REDSTONE_PROP(11, new int[]{1, 2, 3, 2}, 8, SoundEvents.f_11677_, new ItemLike[]{Items.f_42451_, Items.f_42153_}),
    LAPIS_PROP(11, new int[]{1, 2, 3, 2}, 8, SoundEvents.f_11677_, new ItemLike[]{Items.f_42534_, Items.f_41854_}),
    CHICKEN_PROP(1, new int[]{1, 1, 2, 1}, 8, SoundEvents.f_11678_, new ItemLike[]{Items.f_42402_}),
    SLIME_PROP(1, new int[]{1, 1, 2, 1}, 8, SoundEvents.f_11678_, new ItemLike[]{Items.f_42518_, Items.f_42204_}),
    EMERALD_PROP(35, new int[]{3, 6, 8, 3}, 16, SoundEvents.f_11673_, 1.0f, new ItemLike[]{Items.f_42616_, Items.f_42110_}),
    OBSIDIAN_PROP(40, new int[]{3, 6, 7, 3}, 16, SoundEvents.f_11673_, 2.0f, new ItemLike[]{Items.f_41999_}),
    INFUSED_LAVA_PROP(55, new int[]{3, 6, 8, 3}, 16, SoundEvents.f_11673_, 1.0f, "infused_lava_crystal"),
    GUARDIAN_PROP(80, new int[]{4, 7, 8, 3}, 30, SoundEvents.f_11679_, 2.0f, "guardian_scale"),
    SUPER_STAR_PROP(80, new int[]{4, 7, 8, 3}, 30, SoundEvents.f_11679_, 2.0f, "wither_bone"),
    ENDER_DRAGON_PROP(80, new int[]{4, 7, 8, 3}, 30, SoundEvents.f_11679_, 2.0f, "ender_dragon_scale"),
    ARDITE_PROP(55, new int[]{2, 3, 4, 2}, 16, SoundEvents.f_11677_, 1.0f, new ItemLike[]{Items.f_41852_}),
    COBALT_PROP(44, new int[]{2, 3, 4, 2}, 16, SoundEvents.f_11677_, 1.0f, new ItemLike[]{Items.f_41852_}),
    KNIGHT_SLIME_PROP(33, new int[]{2, 3, 4, 3}, 16, SoundEvents.f_11677_, 1.0f, new ItemLike[]{Items.f_41852_}),
    PIG_IRON_PROP(33, new int[]{2, 3, 4, 3}, 16, SoundEvents.f_11677_, 1.0f, new ItemLike[]{Items.f_41852_}),
    MANYULLYN_PROP(66, new int[]{3, 5, 5, 3}, 30, SoundEvents.f_11679_, 2.0f, new ItemLike[]{Items.f_41852_}),
    SLAYER_PROP(169, new int[]{4, 8, 9, 4}, 60, SoundEvents.f_11679_, 5.0f, "the_ultimate_material"),
    ENHANCED_CHAINMAIL_PROP(false, 20, new int[]{2, 5, 6, 3}, 15, SoundEvents.f_11672_, 1.0f, "chainmail"),
    ENHANCED_GOLD_PROP(false, 10, new int[]{2, 4, 5, 2}, 30, SoundEvents.f_11676_, 1.0f, new ItemLike[]{Items.f_42417_}),
    ENHANCED_IRON_PROP(false, 20, new int[]{2, 5, 6, 2}, 15, SoundEvents.f_11677_, 2.0f, new ItemLike[]{Items.f_42416_}),
    ENHANCED_DIAMOND_PROP(false, 35, new int[]{3, 6, 7, 3}, 20, SoundEvents.f_11673_, 3.0f, new ItemLike[]{Items.f_42415_}),
    ENHANCED_NETHERITE_PROP(false, 47, new int[]{3, 6, 8, 3}, 25, SoundEvents.f_11679_, 4.0f, new ItemLike[]{Items.f_42418_}),
    FROST_PROP(55, new int[]{3, 6, 8, 3}, 16, SoundEvents.f_11673_, 1.0f, "infused_frost_crystal"),
    FROST_LAVA_PROP(70, new int[]{4, 7, 8, 3}, 32, SoundEvents.f_11679_, 2.0f, new ItemLike[]{Items.f_41852_});

    private static final int[] MAX_DAMAGE_ARRAY;
    private final String name;
    private final int durability;
    private final float toughness;
    private final int[] damageReduction;
    private final int enchantability;
    private final SoundEvent soundEvent;
    private final APRepair repair;
    private final boolean special;

    private APArmorProperties(int durability, int[] damageReduction, int enchantability, SoundEvent soundEvent, ItemLike ... repair) {
        this(true, durability, damageReduction, enchantability, soundEvent, 0.0f, repair);
    }

    private APArmorProperties(int durability, int[] damageReduction, int enchantability, SoundEvent soundEvent, float toughness, ItemLike ... repair) {
        this(true, durability, damageReduction, enchantability, soundEvent, toughness, repair);
    }

    private APArmorProperties(boolean special, int durability, int[] damageReduction, int enchantability, SoundEvent soundEvent, float toughness, ItemLike ... repair) {
        this(special, durability, damageReduction, enchantability, soundEvent, toughness, new APRepair(repair));
    }

    private APArmorProperties(int durability, int[] damageReduction, int enchantability, SoundEvent soundEvent, String ... repair) {
        this(true, durability, damageReduction, enchantability, soundEvent, 0.0f, repair);
    }

    private APArmorProperties(int durability, int[] damageReduction, int enchantability, SoundEvent soundEvent, float toughness, String ... repair) {
        this(true, durability, damageReduction, enchantability, soundEvent, toughness, repair);
    }

    private APArmorProperties(boolean special, int durability, int[] damageReduction, int enchantability, SoundEvent soundEvent, float toughness, String ... repair) {
        this(special, durability, damageReduction, enchantability, soundEvent, toughness, new APRepair(repair));
    }

    private APArmorProperties(boolean special, int durability, int[] damageReduction, int enchantability, SoundEvent soundEvent, float toughness, APRepair repair) {
        this.special = special;
        this.name = this.name().toLowerCase(Locale.ENGLISH).replace("_prop", "").replace("enhanced_", "");
        this.durability = durability;
        this.toughness = toughness;
        this.damageReduction = damageReduction;
        this.enchantability = enchantability;
        this.soundEvent = soundEvent;
        this.repair = repair;
    }

    public int m_266425_(ArmorItem.Type slot) {
        return MAX_DAMAGE_ARRAY[slot.m_266308_().m_20749_()] * this.durability;
    }

    public int m_7366_(ArmorItem.Type slot) {
        return this.damageReduction[slot.m_266308_().m_20749_()];
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.soundEvent;
    }

    public Ingredient m_6230_() {
        return Ingredient.m_43921_(Utils.getRepairStacks(this.repair).stream());
    }

    @OnlyIn(value=Dist.CLIENT)
    public String m_6082_() {
        return this.special ? "armorplus:" + this.name : "minecraft:" + this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this == ENHANCED_NETHERITE_PROP ? 0.1f : 0.0f;
    }

    public String toString() {
        return "APArmorProperties{name='" + this.name + "', durability=" + this.durability + ", toughness=" + this.toughness + ", damageReduction=" + Arrays.toString(this.damageReduction) + ", enchantability=" + this.enchantability + ", soundEvent=" + this.soundEvent + ", repairMaterial=" + this.repair + ", special=" + this.special + "}";
    }

    static {
        MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    }
}

