/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.items.armors;

import com.sofodev.armorplus.config.ArmorPlusConfig;
import com.sofodev.armorplus.registry.items.armors.APArmorProperties;
import com.sofodev.armorplus.registry.items.armors.IAPArmor;
import com.sofodev.armorplus.registry.items.extras.Buff;
import com.sofodev.armorplus.registry.items.extras.BuffInstance;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum APArmorMaterial implements IAPArmor
{
    COAL((ArmorMaterial)APArmorProperties.COAL_PROP, ChatFormatting.GRAY, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.NIGHT_VISION, 0))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.coalMaterial;
        }
    }
    ,
    REDSTONE((ArmorMaterial)APArmorProperties.REDSTONE_PROP, ChatFormatting.DARK_RED, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.HASTE, 1))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.redstoneMaterial;
        }
    }
    ,
    LAPIS((ArmorMaterial)APArmorProperties.LAPIS_PROP, ChatFormatting.DARK_BLUE, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.WATER_BREATHING, 0))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.lapisMaterial;
        }
    }
    ,
    CHICKEN((ArmorMaterial)APArmorProperties.CHICKEN_PROP, ChatFormatting.WHITE, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.SPEED, 3))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.chickenMaterial;
        }
    }
    ,
    SLIME((ArmorMaterial)APArmorProperties.SLIME_PROP, ChatFormatting.GREEN, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.JUMP_BOOST, 3), new BuffInstance(Buff.SLOW_FALLING, 1))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.slimeMaterial;
        }
    }
    ,
    EMERALD((ArmorMaterial)APArmorProperties.EMERALD_PROP, ChatFormatting.DARK_GREEN, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.SPEED, 1))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.emeraldMaterial;
        }
    }
    ,
    OBSIDIAN((ArmorMaterial)APArmorProperties.OBSIDIAN_PROP, true, ChatFormatting.DARK_GRAY, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.RESISTANCE, 1))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.obsidianMaterial;
        }
    }
    ,
    INFUSED_LAVA((ArmorMaterial)APArmorProperties.INFUSED_LAVA_PROP, true, ChatFormatting.GOLD, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.FIRE_RESISTANCE, 0), new BuffInstance(Buff.FIRE_EXTINGUISH), new BuffInstance(Buff.WATER_WEAKNESS))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.infusedLavaMaterial;
        }
    }
    ,
    GUARDIAN((ArmorMaterial)APArmorProperties.GUARDIAN_PROP, true, ChatFormatting.BLUE, () -> APArmorMaterial.withBuffs(new BuffInstance(ArmorPlusConfig.guardianMaterial.enableNIGHT_VISION.get(), Buff.NIGHT_VISION, (int)ArmorPlusConfig.guardianMaterial.amplifierNIGHT_VISION.get()), new BuffInstance(ArmorPlusConfig.guardianMaterial.enableWATER_BREATHING.get(), Buff.WATER_BREATHING, (int)ArmorPlusConfig.guardianMaterial.amplifierWATER_BREATHING.get()), new BuffInstance(ArmorPlusConfig.guardianMaterial.enableSTRENGTH.get(), Buff.STRENGTH, (int)ArmorPlusConfig.guardianMaterial.amplifierSTRENGTH.get()), new BuffInstance(ArmorPlusConfig.guardianMaterial.enableSPEED.get(), Buff.SPEED, (int)ArmorPlusConfig.guardianMaterial.amplifierSPEED.get()), new BuffInstance(ArmorPlusConfig.guardianMaterial.enableHASTE.get(), Buff.HASTE, (int)ArmorPlusConfig.guardianMaterial.amplifierHASTE.get()), new BuffInstance(ArmorPlusConfig.guardianMaterial.enableJUMP_BOOST.get(), Buff.JUMP_BOOST, (int)ArmorPlusConfig.guardianMaterial.amplifierJUMP_BOOST.get()), new BuffInstance(ArmorPlusConfig.guardianMaterial.enableREGENERATION.get(), Buff.REGENERATION, (int)ArmorPlusConfig.guardianMaterial.amplifierREGENERATION.get(), 200), new BuffInstance(ArmorPlusConfig.guardianMaterial.enableRESISTANCE.get(), Buff.RESISTANCE, (int)ArmorPlusConfig.guardianMaterial.amplifierRESISTANCE.get()), new BuffInstance(ArmorPlusConfig.guardianMaterial.enableFIRE_RESISTANCE.get(), Buff.FIRE_RESISTANCE, (int)ArmorPlusConfig.guardianMaterial.amplifierFIRE_RESISTANCE.get()), new BuffInstance(ArmorPlusConfig.guardianMaterial.enableSATURATION.get(), Buff.SATURATION, (int)ArmorPlusConfig.guardianMaterial.amplifierSATURATION.get()), new BuffInstance(ArmorPlusConfig.guardianMaterial.enableINVISIBILITY.get(), Buff.INVISIBILITY, (int)ArmorPlusConfig.guardianMaterial.amplifierINVISIBILITY.get()), new BuffInstance(ArmorPlusConfig.guardianMaterial.enableHEALTH_BOOST.get(), Buff.HEALTH_BOOST, (int)ArmorPlusConfig.guardianMaterial.amplifierHEALTH_BOOST.get(), 200), new BuffInstance(ArmorPlusConfig.guardianMaterial.enableABSORPTION.get(), Buff.ABSORPTION, (int)ArmorPlusConfig.guardianMaterial.amplifierABSORPTION.get(), 200), new BuffInstance(ArmorPlusConfig.guardianMaterial.enableSLOW_FALLING.get(), Buff.SLOW_FALLING, (int)ArmorPlusConfig.guardianMaterial.amplifierSLOW_FALLING.get()), new BuffInstance(ArmorPlusConfig.guardianMaterial.enableFLIGHT.get(), Buff.FLIGHT), new BuffInstance(ArmorPlusConfig.guardianMaterial.enableWITHER_IMMUNITY.get(), Buff.WITHER_IMMUNITY), new BuffInstance(ArmorPlusConfig.guardianMaterial.enableNATURAL_IMMUNITY.get(), Buff.NATURAL_IMMUNITY), new BuffInstance(ArmorPlusConfig.guardianMaterial.enableFIRE_EXTINGUISH.get(), Buff.FIRE_EXTINGUISH))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.guardianMaterial;
        }
    }
    ,
    SUPER_STAR((ArmorMaterial)APArmorProperties.SUPER_STAR_PROP, true, ChatFormatting.WHITE, () -> APArmorMaterial.withBuffs(new BuffInstance(ArmorPlusConfig.superStarMaterial.enableNIGHT_VISION.get(), Buff.NIGHT_VISION, (int)ArmorPlusConfig.superStarMaterial.amplifierNIGHT_VISION.get()), new BuffInstance(ArmorPlusConfig.superStarMaterial.enableWATER_BREATHING.get(), Buff.WATER_BREATHING, (int)ArmorPlusConfig.superStarMaterial.amplifierWATER_BREATHING.get()), new BuffInstance(ArmorPlusConfig.superStarMaterial.enableSTRENGTH.get(), Buff.STRENGTH, (int)ArmorPlusConfig.superStarMaterial.amplifierSTRENGTH.get()), new BuffInstance(ArmorPlusConfig.superStarMaterial.enableSPEED.get(), Buff.SPEED, (int)ArmorPlusConfig.superStarMaterial.amplifierSPEED.get()), new BuffInstance(ArmorPlusConfig.superStarMaterial.enableHASTE.get(), Buff.HASTE, (int)ArmorPlusConfig.superStarMaterial.amplifierHASTE.get()), new BuffInstance(ArmorPlusConfig.superStarMaterial.enableJUMP_BOOST.get(), Buff.JUMP_BOOST, (int)ArmorPlusConfig.superStarMaterial.amplifierJUMP_BOOST.get()), new BuffInstance(ArmorPlusConfig.superStarMaterial.enableREGENERATION.get(), Buff.REGENERATION, (int)ArmorPlusConfig.superStarMaterial.amplifierREGENERATION.get(), 200), new BuffInstance(ArmorPlusConfig.superStarMaterial.enableRESISTANCE.get(), Buff.RESISTANCE, (int)ArmorPlusConfig.superStarMaterial.amplifierRESISTANCE.get()), new BuffInstance(ArmorPlusConfig.superStarMaterial.enableFIRE_RESISTANCE.get(), Buff.FIRE_RESISTANCE, (int)ArmorPlusConfig.superStarMaterial.amplifierFIRE_RESISTANCE.get()), new BuffInstance(ArmorPlusConfig.superStarMaterial.enableSATURATION.get(), Buff.SATURATION, (int)ArmorPlusConfig.superStarMaterial.amplifierSATURATION.get()), new BuffInstance(ArmorPlusConfig.superStarMaterial.enableINVISIBILITY.get(), Buff.INVISIBILITY, (int)ArmorPlusConfig.superStarMaterial.amplifierINVISIBILITY.get()), new BuffInstance(ArmorPlusConfig.superStarMaterial.enableHEALTH_BOOST.get(), Buff.HEALTH_BOOST, (int)ArmorPlusConfig.superStarMaterial.amplifierHEALTH_BOOST.get(), 200), new BuffInstance(ArmorPlusConfig.superStarMaterial.enableABSORPTION.get(), Buff.ABSORPTION, (int)ArmorPlusConfig.superStarMaterial.amplifierABSORPTION.get(), 200), new BuffInstance(ArmorPlusConfig.superStarMaterial.enableSLOW_FALLING.get(), Buff.SLOW_FALLING, (int)ArmorPlusConfig.superStarMaterial.amplifierSLOW_FALLING.get()), new BuffInstance(ArmorPlusConfig.superStarMaterial.enableFLIGHT.get(), Buff.FLIGHT), new BuffInstance(ArmorPlusConfig.superStarMaterial.enableWITHER_IMMUNITY.get(), Buff.WITHER_IMMUNITY), new BuffInstance(ArmorPlusConfig.superStarMaterial.enableNATURAL_IMMUNITY.get(), Buff.NATURAL_IMMUNITY), new BuffInstance(ArmorPlusConfig.superStarMaterial.enableFIRE_EXTINGUISH.get(), Buff.FIRE_EXTINGUISH))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.superStarMaterial;
        }
    }
    ,
    ENDER_DRAGON((ArmorMaterial)APArmorProperties.ENDER_DRAGON_PROP, true, ChatFormatting.DARK_PURPLE, () -> APArmorMaterial.withBuffs(new BuffInstance(ArmorPlusConfig.enderDragonMaterial.enableNIGHT_VISION.get(), Buff.NIGHT_VISION, (int)ArmorPlusConfig.enderDragonMaterial.amplifierNIGHT_VISION.get()), new BuffInstance(ArmorPlusConfig.enderDragonMaterial.enableWATER_BREATHING.get(), Buff.WATER_BREATHING, (int)ArmorPlusConfig.enderDragonMaterial.amplifierWATER_BREATHING.get()), new BuffInstance(ArmorPlusConfig.enderDragonMaterial.enableSTRENGTH.get(), Buff.STRENGTH, (int)ArmorPlusConfig.enderDragonMaterial.amplifierSTRENGTH.get()), new BuffInstance(ArmorPlusConfig.enderDragonMaterial.enableSPEED.get(), Buff.SPEED, (int)ArmorPlusConfig.enderDragonMaterial.amplifierSPEED.get()), new BuffInstance(ArmorPlusConfig.enderDragonMaterial.enableHASTE.get(), Buff.HASTE, (int)ArmorPlusConfig.enderDragonMaterial.amplifierHASTE.get()), new BuffInstance(ArmorPlusConfig.enderDragonMaterial.enableJUMP_BOOST.get(), Buff.JUMP_BOOST, (int)ArmorPlusConfig.enderDragonMaterial.amplifierJUMP_BOOST.get()), new BuffInstance(ArmorPlusConfig.enderDragonMaterial.enableREGENERATION.get(), Buff.REGENERATION, (int)ArmorPlusConfig.enderDragonMaterial.amplifierREGENERATION.get(), 200), new BuffInstance(ArmorPlusConfig.enderDragonMaterial.enableRESISTANCE.get(), Buff.RESISTANCE, (int)ArmorPlusConfig.enderDragonMaterial.amplifierRESISTANCE.get()), new BuffInstance(ArmorPlusConfig.enderDragonMaterial.enableFIRE_RESISTANCE.get(), Buff.FIRE_RESISTANCE, (int)ArmorPlusConfig.enderDragonMaterial.amplifierFIRE_RESISTANCE.get()), new BuffInstance(ArmorPlusConfig.enderDragonMaterial.enableSATURATION.get(), Buff.SATURATION, (int)ArmorPlusConfig.enderDragonMaterial.amplifierSATURATION.get()), new BuffInstance(ArmorPlusConfig.enderDragonMaterial.enableINVISIBILITY.get(), Buff.INVISIBILITY, (int)ArmorPlusConfig.enderDragonMaterial.amplifierINVISIBILITY.get()), new BuffInstance(ArmorPlusConfig.enderDragonMaterial.enableHEALTH_BOOST.get(), Buff.HEALTH_BOOST, (int)ArmorPlusConfig.enderDragonMaterial.amplifierHEALTH_BOOST.get(), 200), new BuffInstance(ArmorPlusConfig.enderDragonMaterial.enableABSORPTION.get(), Buff.ABSORPTION, (int)ArmorPlusConfig.enderDragonMaterial.amplifierABSORPTION.get(), 200), new BuffInstance(ArmorPlusConfig.enderDragonMaterial.enableSLOW_FALLING.get(), Buff.SLOW_FALLING, (int)ArmorPlusConfig.enderDragonMaterial.amplifierSLOW_FALLING.get()), new BuffInstance(ArmorPlusConfig.enderDragonMaterial.enableFLIGHT.get(), Buff.FLIGHT), new BuffInstance(ArmorPlusConfig.enderDragonMaterial.enableWITHER_IMMUNITY.get(), Buff.WITHER_IMMUNITY), new BuffInstance(ArmorPlusConfig.enderDragonMaterial.enableNATURAL_IMMUNITY.get(), Buff.NATURAL_IMMUNITY), new BuffInstance(ArmorPlusConfig.enderDragonMaterial.enableFIRE_EXTINGUISH.get(), Buff.FIRE_EXTINGUISH))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.enderDragonMaterial;
        }
    }
    ,
    ARDITE(APArmorProperties.ARDITE_PROP, ChatFormatting.RED),
    COBALT(APArmorProperties.COBALT_PROP, ChatFormatting.BLUE),
    KNIGHT_SLIME(APArmorProperties.KNIGHT_SLIME_PROP, ChatFormatting.LIGHT_PURPLE),
    PIG_IRON(APArmorProperties.PIG_IRON_PROP, ChatFormatting.LIGHT_PURPLE),
    MANYULLYN(APArmorProperties.MANYULLYN_PROP, ChatFormatting.DARK_PURPLE),
    SLAYER((ArmorMaterial)APArmorProperties.SLAYER_PROP, true, ChatFormatting.DARK_PURPLE, () -> APArmorMaterial.withBuffs(new BuffInstance(ArmorPlusConfig.slayerMaterial.enableNIGHT_VISION.get(), Buff.NIGHT_VISION, (int)ArmorPlusConfig.slayerMaterial.amplifierNIGHT_VISION.get()), new BuffInstance(ArmorPlusConfig.slayerMaterial.enableWATER_BREATHING.get(), Buff.WATER_BREATHING, (int)ArmorPlusConfig.slayerMaterial.amplifierWATER_BREATHING.get()), new BuffInstance(ArmorPlusConfig.slayerMaterial.enableSTRENGTH.get(), Buff.STRENGTH, (int)ArmorPlusConfig.slayerMaterial.amplifierSTRENGTH.get()), new BuffInstance(ArmorPlusConfig.slayerMaterial.enableSPEED.get(), Buff.SPEED, (int)ArmorPlusConfig.slayerMaterial.amplifierSPEED.get()), new BuffInstance(ArmorPlusConfig.slayerMaterial.enableHASTE.get(), Buff.HASTE, (int)ArmorPlusConfig.slayerMaterial.amplifierHASTE.get()), new BuffInstance(ArmorPlusConfig.slayerMaterial.enableJUMP_BOOST.get(), Buff.JUMP_BOOST, (int)ArmorPlusConfig.slayerMaterial.amplifierJUMP_BOOST.get()), new BuffInstance(ArmorPlusConfig.slayerMaterial.enableREGENERATION.get(), Buff.REGENERATION, (int)ArmorPlusConfig.slayerMaterial.amplifierREGENERATION.get(), 200), new BuffInstance(ArmorPlusConfig.slayerMaterial.enableRESISTANCE.get(), Buff.RESISTANCE, (int)ArmorPlusConfig.slayerMaterial.amplifierRESISTANCE.get()), new BuffInstance(ArmorPlusConfig.slayerMaterial.enableFIRE_RESISTANCE.get(), Buff.FIRE_RESISTANCE, (int)ArmorPlusConfig.slayerMaterial.amplifierFIRE_RESISTANCE.get()), new BuffInstance(ArmorPlusConfig.slayerMaterial.enableSATURATION.get(), Buff.SATURATION, (int)ArmorPlusConfig.slayerMaterial.amplifierSATURATION.get()), new BuffInstance(ArmorPlusConfig.slayerMaterial.enableINVISIBILITY.get(), Buff.INVISIBILITY, (int)ArmorPlusConfig.slayerMaterial.amplifierINVISIBILITY.get()), new BuffInstance(ArmorPlusConfig.slayerMaterial.enableHEALTH_BOOST.get(), Buff.HEALTH_BOOST, (int)ArmorPlusConfig.slayerMaterial.amplifierHEALTH_BOOST.get(), 200), new BuffInstance(ArmorPlusConfig.slayerMaterial.enableABSORPTION.get(), Buff.ABSORPTION, (int)ArmorPlusConfig.slayerMaterial.amplifierABSORPTION.get(), 200), new BuffInstance(ArmorPlusConfig.slayerMaterial.enableSLOW_FALLING.get(), Buff.SLOW_FALLING, (int)ArmorPlusConfig.slayerMaterial.amplifierSLOW_FALLING.get()), new BuffInstance(ArmorPlusConfig.slayerMaterial.enableFLIGHT.get(), Buff.FLIGHT), new BuffInstance(ArmorPlusConfig.slayerMaterial.enableWITHER_IMMUNITY.get(), Buff.WITHER_IMMUNITY), new BuffInstance(ArmorPlusConfig.slayerMaterial.enableNATURAL_IMMUNITY.get(), Buff.NATURAL_IMMUNITY), new BuffInstance(ArmorPlusConfig.slayerMaterial.enableFIRE_EXTINGUISH.get(), Buff.FIRE_EXTINGUISH))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.slayerMaterial;
        }
    }
    ,
    CHAINMAIL(APArmorProperties.ENHANCED_CHAINMAIL_PROP, ChatFormatting.GRAY),
    GOLDEN(APArmorProperties.ENHANCED_GOLD_PROP, ChatFormatting.GRAY),
    IRON(APArmorProperties.ENHANCED_IRON_PROP, ChatFormatting.GRAY),
    DIAMOND(APArmorProperties.ENHANCED_DIAMOND_PROP, ChatFormatting.GRAY),
    NETHERITE(APArmorProperties.ENHANCED_NETHERITE_PROP, true, ChatFormatting.GRAY, Collections::emptyList),
    FROST((ArmorMaterial)APArmorProperties.FROST_PROP, false, ChatFormatting.BLUE, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.FIRE_WEAKNESS))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.frostMaterial;
        }
    }
    ,
    FROST_LAVA((ArmorMaterial)APArmorProperties.FROST_LAVA_PROP, true, ChatFormatting.YELLOW, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.NATURAL_IMMUNITY))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.frostLavaMaterial;
        }
    };

    private final ArmorMaterial armor;
    private final boolean isImmuneToFire;
    private final Supplier<List<BuffInstance>> buffs;
    private final ChatFormatting formatting;

    private APArmorMaterial() {
        this((ArmorMaterial)ArmorMaterials.IRON, false, ChatFormatting.RESET, Collections::emptyList);
    }

    private APArmorMaterial(ArmorMaterial armor) {
        this(armor, false, ChatFormatting.RESET, Collections::emptyList);
    }

    private APArmorMaterial(ArmorMaterial armor, ChatFormatting formatting) {
        this(armor, false, formatting, Collections::emptyList);
    }

    private APArmorMaterial(ArmorMaterial armor, ChatFormatting formatting, Supplier<List<BuffInstance>> buffs) {
        this(armor, false, formatting, buffs);
    }

    private APArmorMaterial(ArmorMaterial armor, boolean isImmuneToFire, ChatFormatting formatting, Supplier<List<BuffInstance>> buffs) {
        this.armor = armor;
        this.isImmuneToFire = isImmuneToFire;
        this.buffs = buffs;
        this.formatting = formatting;
    }

    private static List<BuffInstance> withBuffs(BuffInstance ... buffs) {
        return Arrays.asList(buffs);
    }

    @Override
    public String getName() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public ArmorMaterial get() {
        return this.armor;
    }

    @Override
    public Item.Properties getProperties() {
        return new Item.Properties().m_41497_(Rarity.create((String)this.getName(), (ChatFormatting)this.getFormatting()));
    }

    @Override
    public boolean isImmuneToFire() {
        return this.isImmuneToFire;
    }

    @Override
    public ChatFormatting getFormatting() {
        return this.formatting;
    }

    @Override
    public Supplier<List<BuffInstance>> getBuffInstances() {
        return this.buffs;
    }

    @Override
    public ArmorPlusConfig.MaterialConfig config() {
        return IAPArmor.super.config();
    }

    public String toString() {
        return "APArmorMaterial{armor=" + this.armor + ", isImmuneToFire=" + this.isImmuneToFire + ", buffs=" + this.buffs + ", formatting=" + this.formatting + "}";
    }
}

