/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.items.armors;

import com.sofodev.armorplus.registry.items.armors.IAPArmor;
import com.sofodev.armorplus.registry.items.extras.Buff;
import com.sofodev.armorplus.registry.items.extras.BuffInstance;
import com.sofodev.armorplus.utils.ItemArmorUtility;
import com.sofodev.armorplus.utils.RomanNumeralUtil;
import com.sofodev.armorplus.utils.ToolTipUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class APArmorItem
extends ArmorItem {
    private IAPArmor mat;

    public APArmorItem(IAPArmor mat, ArmorItem.Type slot) {
        super(mat.get(), slot, mat.isImmuneToFire() ? mat.getProperties().m_41499_(mat.get().m_266425_(slot)).m_41486_() : mat.getProperties().m_41499_(mat.get().m_266425_(slot)));
        this.mat = mat;
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (!world.f_46443_ && this.mat.config().enableArmorEffects.get().booleanValue()) {
            if (this.mat.getBuffInstances().get() == null || this.mat.getBuffInstances().get().isEmpty()) {
                return;
            }
            this.mat.getBuffInstances().get().forEach(instance -> {
                if (instance.getBuff() instanceof Buff && instance.isEnabled()) {
                    if (instance.getBuff().requiresFullSet()) {
                        if (ItemArmorUtility.areExactMatch(this.mat, player)) {
                            instance.onArmorTick(stack, world, player);
                        }
                    } else {
                        instance.onArmorTick(stack, world, player);
                    }
                }
            });
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!this.mat.getBuffInstances().get().isEmpty()) {
            tooltip.add((Component)ToolTipUtils.translate(ChatFormatting.YELLOW, "tooltip.armorplus.condition", this.mat.config().enableArmorEffects.get() != false ? "" : "(DISABLED)"));
            tooltip.add((Component)ToolTipUtils.translate(ChatFormatting.GOLD, "tooltip.armorplus.condition.full_set", new Object[0]));
            tooltip.add((Component)ToolTipUtils.translate(ChatFormatting.GREEN, "tooltip.armorplus.provides", new Object[0]));
            for (BuffInstance buff : this.mat.getBuffInstances().get()) {
                if (buff.getBuff() == Buff.NONE) continue;
                int lvl = buff.getAmplifier() + 1;
                String theLvl = lvl > 0 ? " " + RomanNumeralUtil.generate(lvl) : "";
                tooltip.add((Component)ToolTipUtils.translate(ChatFormatting.DARK_AQUA, "tooltip.armorplus.buff", buff.getTranslatedName(), theLvl));
            }
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public ArmorMaterial m_40401_() {
        return this.mat.get();
    }

    public IAPArmor getMat() {
        return this.mat;
    }
}

