/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.enchantments;

import com.sofodev.armorplus.registry.enchantments.APEnchantment;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class LifeStealEnchantment
extends APEnchantment {
    public LifeStealEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.WEAPON, new EquipmentSlot[]{EquipmentSlot.MAINHAND}, 1, 3, 10, 30, true, true);
    }

    public void m_7675_(LivingEntity user, Entity attacker, int level) {
        if (level > Levels.limit()) {
            level = Levels.limit();
        }
        super.m_7675_(user, attacker, level);
    }

    public void m_7677_(LivingEntity user, Entity target, int level) {
        if (level > Levels.limit()) {
            level = Levels.limit();
        }
        Levels lvl = Levels.values()[level];
        if (user == null || target == null) {
            return;
        }
        ItemStack mainHand = user.m_21205_();
        Item handItem = mainHand.m_41720_();
        if (mainHand.m_41619_()) {
            return;
        }
        if (!this.isCorrectItem(handItem)) {
            user.m_5634_(lvl.healingFactor);
        } else if (handItem instanceof DiggerItem) {
            float damageDealt = ((DiggerItem)handItem).m_43314_().m_6631_();
            user.m_5634_((float)level * this.softCap(damageDealt, 10.0f, 1.0f) / 4.0f);
        } else if (handItem instanceof SwordItem) {
            float damageDealt = ((SwordItem)handItem).m_43299_();
            user.m_5634_((float)level * this.softCap(damageDealt, 10.0f, 1.0f) / 4.0f);
        }
    }

    private float softCap(float value, float max, float scale) {
        if (value <= max) {
            return value;
        }
        float space = max * scale;
        float offset = value - max;
        return max + space * offset / (space + offset);
    }

    private boolean isCorrectItem(Item item) {
        return item instanceof SwordItem || item instanceof DiggerItem;
    }

    public static enum Levels {
        ZERO(0.0f),
        ONE(0.5f),
        TWO(1.5f),
        THREE(2.5f);

        public final float healingFactor;

        private Levels(float healingFactor) {
            this.healingFactor = healingFactor;
        }

        public static int limit() {
            return Levels.values().length - 1;
        }
    }
}

