/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.blocks.castle;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StoneBrickSlabBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<SlabType> TYPE = BlockStateProperties.f_61397_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape BOTTOM_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape TOP_SHAPE = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public StoneBrickSlabBlock(Block block) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block).m_60999_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)SlabType.BOTTOM)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7923_(BlockState state) {
        return state.m_61143_(TYPE) != SlabType.DOUBLE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        SlabType slabtype = (SlabType)state.m_61143_(TYPE);
        switch (slabtype) {
            case DOUBLE: {
                return Shapes.m_83144_();
            }
            case TOP: {
                return TOP_SHAPE;
            }
        }
        return BOTTOM_SHAPE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        BlockState blockstate = context.m_43725_().m_8055_(blockpos);
        if (blockstate.m_60713_((Block)this)) {
            return (BlockState)((BlockState)blockstate.m_61124_(TYPE, (Comparable)SlabType.DOUBLE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE);
        }
        FluidState fluidstate = context.m_43725_().m_6425_(blockpos);
        BlockState nextState = (BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)SlabType.BOTTOM)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        Direction direction = context.m_43719_();
        return !(direction == Direction.DOWN || direction != Direction.UP && context.m_43720_().f_82480_ - (double)blockpos.m_123342_() > 0.5) ? nextState : (BlockState)nextState.m_61124_(TYPE, (Comparable)SlabType.TOP);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        ItemStack stack = useContext.m_43722_();
        SlabType slabtype = (SlabType)state.m_61143_(TYPE);
        if (slabtype != SlabType.DOUBLE && stack.m_41720_() == this.m_5456_()) {
            if (useContext.m_7058_()) {
                boolean flag = useContext.m_43720_().f_82480_ - (double)useContext.m_8083_().m_123342_() > 0.5;
                Direction direction = useContext.m_43719_();
                if (slabtype == SlabType.BOTTOM) {
                    return direction == Direction.UP || flag && direction.m_122434_().m_122479_();
                }
                return direction == Direction.DOWN || !flag && direction.m_122434_().m_122479_();
            }
            return true;
        }
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return state.m_61143_(TYPE) != SlabType.DOUBLE && super.m_7361_(worldIn, pos, state, fluidStateIn);
    }

    public boolean m_6044_(BlockGetter getter, BlockPos pos, BlockState state, Fluid fluidIn) {
        return state.m_61143_(TYPE) != SlabType.DOUBLE && super.m_6044_(getter, pos, state, fluidIn);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        switch (type) {
            case WATER: {
                return worldIn.m_6425_(pos).m_205070_(FluidTags.f_13131_);
            }
        }
        return false;
    }
}

