/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry;

import com.sofodev.armorplus.ArmorPlus;
import com.sofodev.armorplus.registry.entities.arrows.ArrowType;
import com.sofodev.armorplus.registry.items.APItemBase;
import com.sofodev.armorplus.registry.items.armors.APArmorItem;
import com.sofodev.armorplus.registry.items.armors.APArmorMaterial;
import com.sofodev.armorplus.registry.items.armors.IAPArmor;
import com.sofodev.armorplus.registry.items.arrows.APArrowItem;
import com.sofodev.armorplus.registry.items.materials.FrostCrystalItem;
import com.sofodev.armorplus.registry.items.materials.FrostLavaCrystalItem;
import com.sofodev.armorplus.registry.items.materials.LavaCrystalItem;
import com.sofodev.armorplus.registry.items.materials.MaterialItem;
import com.sofodev.armorplus.registry.items.special.SoulItem;
import com.sofodev.armorplus.registry.items.special.ThankYouItem;
import com.sofodev.armorplus.registry.items.tools.APBattleAxeItem;
import com.sofodev.armorplus.registry.items.tools.APBowItem;
import com.sofodev.armorplus.registry.items.tools.APMaceItem;
import com.sofodev.armorplus.registry.items.tools.APPickaxeItem;
import com.sofodev.armorplus.registry.items.tools.APSwordItem;
import com.sofodev.armorplus.registry.items.tools.properties.mace.APMaceMaterial;
import com.sofodev.armorplus.registry.items.tools.properties.tool.APToolMaterial;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="armorplus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"armorplus");
    public static final Set<RegistryObject<APArmorItem>> HELMETS = ModItems.registerArmorForSlot(ArmorItem.Type.HELMET);
    public static final Set<RegistryObject<APArmorItem>> CHESTPLATES = ModItems.registerArmorForSlot(ArmorItem.Type.CHESTPLATE);
    public static final Set<RegistryObject<APArmorItem>> LEGGINGS = ModItems.registerArmorForSlot(ArmorItem.Type.LEGGINGS);
    public static final Set<RegistryObject<APArmorItem>> BOOTS = ModItems.registerArmorForSlot(ArmorItem.Type.BOOTS);
    public static final Set<RegistryObject<Item>> SUPER_STAR_BASES = ModItems.registerArmorBases(APArmorMaterial.SUPER_STAR);
    public static final Set<RegistryObject<Item>> GUARDIAN_BASES = ModItems.registerArmorBases(APArmorMaterial.GUARDIAN);
    public static final Set<RegistryObject<Item>> ENDER_DRAGON_BASES = ModItems.registerArmorBases(APArmorMaterial.ENDER_DRAGON);
    public static final Set<RegistryObject<Item>> SLAYER_BASES = ModItems.registerArmorBases(APArmorMaterial.SLAYER);
    public static final RegistryObject<Item> GUARDIAN_SWORD_BASE = ModItems.registerBase(APToolMaterial.GUARDIAN_MAT, "sword");
    public static final RegistryObject<Item> GUARDIAN_BATTLE_AXE_BASE = ModItems.registerBase(APToolMaterial.GUARDIAN_MAT, "battle_axe");
    public static final RegistryObject<Item> GUARDIAN_PICKAXE_BASE = ModItems.registerBase(APToolMaterial.GUARDIAN_MAT, "pickaxe");
    public static final RegistryObject<Item> GUARDIAN_BOW_BASE = ModItems.registerBase(APToolMaterial.GUARDIAN_MAT, "bow");
    public static final RegistryObject<Item> SUPER_STAR_SWORD_BASE = ModItems.registerBase(APToolMaterial.SUPER_STAR_MAT, "sword");
    public static final RegistryObject<Item> SUPER_STAR_BATTLE_AXE_BASE = ModItems.registerBase(APToolMaterial.SUPER_STAR_MAT, "battle_axe");
    public static final RegistryObject<Item> SUPER_STAR_PICKAXE_BASE = ModItems.registerBase(APToolMaterial.SUPER_STAR_MAT, "pickaxe");
    public static final RegistryObject<Item> SUPER_STAR_BOW_BASE = ModItems.registerBase(APToolMaterial.SUPER_STAR_MAT, "bow");
    public static final RegistryObject<Item> ENDER_DRAGON_SWORD_BASE = ModItems.registerBase(APToolMaterial.ENDER_DRAGON_MAT, "sword");
    public static final RegistryObject<Item> ENDER_DRAGON_BATTLE_AXE_BASE = ModItems.registerBase(APToolMaterial.ENDER_DRAGON_MAT, "battle_axe");
    public static final RegistryObject<Item> ENDER_DRAGON_PICKAXE_BASE = ModItems.registerBase(APToolMaterial.ENDER_DRAGON_MAT, "pickaxe");
    public static final RegistryObject<Item> ENDER_DRAGON_BOW_BASE = ModItems.registerBase(APToolMaterial.ENDER_DRAGON_MAT, "bow");
    public static final RegistryObject<Item> SLAYER_SWORD_BASE = ModItems.registerBase(APToolMaterial.SLAYER_MAT, "sword");
    public static final RegistryObject<Item> SLAYER_BATTLE_AXE_BASE = ModItems.registerBase(APToolMaterial.SLAYER_MAT, "battle_axe");
    public static final RegistryObject<Item> SLAYER_PICKAXE_BASE = ModItems.registerBase(APToolMaterial.SLAYER_MAT, "pickaxe");
    public static final RegistryObject<Item> SLAYER_BOW_BASE = ModItems.registerBase(APToolMaterial.SLAYER_MAT, "bow");
    public static final RegistryObject<Item>[] SWORDS = new RegistryObject[ArmorPlus.AP_TOOL_MATERIAL_LENGTH];
    public static final RegistryObject<Item>[] BATTLE_AXES = new RegistryObject[ArmorPlus.AP_TOOL_MATERIAL_LENGTH];
    public static final RegistryObject<Item>[] PICKAXES = new RegistryObject[ArmorPlus.AP_TOOL_MATERIAL_LENGTH];
    public static final RegistryObject<Item>[] SHOVELS = new RegistryObject[ArmorPlus.AP_TOOL_MATERIAL_LENGTH];
    public static final RegistryObject<Item>[] BOWS = new RegistryObject[ArmorPlus.AP_TOOL_MATERIAL_LENGTH];
    public static final RegistryObject<Item>[] MACES = new RegistryObject[ArmorPlus.AP_MACE_MAT_LENGTH];
    public static final RegistryObject<ArrowItem> ITEM_COAL_ARROW = ModItems.registerArrow(ArrowType.COAL);
    public static final RegistryObject<ArrowItem> ITEM_LAPIS_ARROW = ModItems.registerArrow(ArrowType.LAPIS);
    public static final RegistryObject<ArrowItem> ITEM_REDSTONE_ARROW = ModItems.registerArrow(ArrowType.REDSTONE);
    public static final RegistryObject<ArrowItem> ITEM_EMERALD_ARROW = ModItems.registerArrow(ArrowType.EMERALD);
    public static final RegistryObject<ArrowItem> ITEM_OBSIDIAN_ARROW = ModItems.registerArrow(ArrowType.OBSIDIAN);
    public static final RegistryObject<ArrowItem> ITEM_INFUSED_LAVA_ARROW = ModItems.registerArrow(ArrowType.INFUSED_LAVA);
    public static final RegistryObject<ArrowItem> ITEM_GUARDIAN_ARROW = ModItems.registerArrow(ArrowType.GUARDIAN);
    public static final RegistryObject<ArrowItem> ITEM_SUPER_STAR_ARROW = ModItems.registerArrow(ArrowType.SUPER_STAR);
    public static final RegistryObject<ArrowItem> ITEM_ENDER_DRAGON_ARROW = ModItems.registerArrow(ArrowType.ENDER_DRAGON);
    public static final RegistryObject<Item> LAVA_CRYSTAL = ModItems.register("lava_crystal", () -> new LavaCrystalItem(false));
    public static final RegistryObject<Item> INFUSED_LAVA_CRYSTAL = ModItems.register("infused_lava_crystal", () -> new LavaCrystalItem(true));
    public static final RegistryObject<Item> FROST_CRYSTAL = ModItems.register("frost_crystal", () -> new FrostCrystalItem(false));
    public static final RegistryObject<Item> INFUSED_FROST_CRYSTAL = ModItems.register("infused_frost_crystal", () -> new FrostCrystalItem(true));
    public static final RegistryObject<Item> INFUSED_FROST_LAVA_CRYSTAL = ModItems.register("infused_frost_lava_crystal", FrostLavaCrystalItem::new);
    public static final RegistryObject<Item> CHAINMAIL = ModItems.register("chainmail", () -> new MaterialItem(ChatFormatting.GRAY, new Item.Properties()));
    public static final RegistryObject<Item> GUARDIAN_SCALE = ModItems.register("guardian_scale", () -> new MaterialItem(ChatFormatting.BLUE, new Item.Properties()));
    public static final RegistryObject<Item> WITHER_BONE = ModItems.register("wither_bone", () -> new MaterialItem(ChatFormatting.WHITE, new Item.Properties().m_41486_()));
    public static final RegistryObject<Item> ENDER_DRAGON_SCALE = ModItems.register("ender_dragon_scale", () -> new MaterialItem(ChatFormatting.DARK_PURPLE, new Item.Properties()));
    public static final RegistryObject<Item> THE_ULTIMATE_MATERIAL = ModItems.register("the_ultimate_material", () -> new MaterialItem(ChatFormatting.DARK_PURPLE, new Item.Properties().m_41486_()));
    public static final RegistryObject<Item> WITHER_BOSS_SOUL = ModItems.register("soul_wither_boss", () -> new SoulItem("wither"));
    public static final RegistryObject<Item> ELDER_GUARDIAN_SOUL = ModItems.register("soul_elder_guardian", () -> new SoulItem("elder_guardian"));
    public static final RegistryObject<Item> ENDER_DRAGON_SOUL = ModItems.register("soul_ender_dragon", () -> new SoulItem("ender_dragon"));
    public static final RegistryObject<Item> WITHER_SKELETON_SOUL = ModItems.register("soul_wither_skeleton", () -> new SoulItem(false, "wither_skeleton"));
    public static final RegistryObject<Item> GUARDIAN_SOUL = ModItems.register("soul_guardian", () -> new SoulItem(false, "guardian"));
    public static final RegistryObject<Item> ENDERMAN_SOUL = ModItems.register("soul_enderman", () -> new SoulItem(false, "enderman"));
    public static final RegistryObject<Item> BLAZE_SOUL = ModItems.register("soul_blaze", () -> new SoulItem(false, "blaze"));
    public static final RegistryObject<Item> SLAYER_SOUL = ModItems.register("soul_slayer", () -> new SoulItem(null));
    public static final RegistryObject<Item> ENHANCED_CHAINMAIL = ModItems.register("en_chainmail", () -> new MaterialItem(true, ChatFormatting.GRAY, new Item.Properties()));
    public static final RegistryObject<Item> ENHANCED_IRON = ModItems.register("en_iron", () -> new MaterialItem(true, ChatFormatting.GRAY, new Item.Properties()));
    public static final RegistryObject<Item> ENHANCED_GOLD = ModItems.register("en_gold", () -> new MaterialItem(true, ChatFormatting.GRAY, new Item.Properties()));
    public static final RegistryObject<Item> ENHANCED_DIAMOND = ModItems.register("en_diamond", () -> new MaterialItem(true, ChatFormatting.GRAY, new Item.Properties()));
    public static final RegistryObject<Item> ENHANCED_NETHERITE = ModItems.register("en_netherite", () -> new MaterialItem(true, ChatFormatting.GRAY, new Item.Properties().m_41486_()));
    public static final RegistryObject<Item> OBSIDIAN_STICK = ModItems.register("obsidian_stick", () -> new MaterialItem(false, ChatFormatting.DARK_PURPLE, new Item.Properties().m_41486_()));
    public static final RegistryObject<Item> WOODEN_ROD = ModItems.register("wooden_rod", () -> new MaterialItem(false, ChatFormatting.GRAY, new Item.Properties()));
    public static final RegistryObject<Item> LAVA_SHARD = ModItems.register("lava_shard", () -> new MaterialItem(false, ChatFormatting.GOLD, new Item.Properties()));
    public static final RegistryObject<Item> FROST_SHARD = ModItems.register("frost_shard", () -> new MaterialItem(false, ChatFormatting.AQUA, new Item.Properties()));
    public static final RegistryObject<Item> THANK_YOU_6M = ModItems.register("thank_you_6m", ThankYouItem::new);

    public static <ITEM extends Item> RegistryObject<ITEM> register(String name, DeferredRegister<Item> items, Supplier<ITEM> itemSupplier) {
        return items.register(name, itemSupplier);
    }

    public static <ITEM extends Item> RegistryObject<ITEM> register(String name, Supplier<ITEM> itemSupplier) {
        return ModItems.register(name, ITEMS, itemSupplier);
    }

    public static Set<RegistryObject<APArmorItem>> registerArmorForSlot(ArmorItem.Type slot) {
        return Arrays.stream(APArmorMaterial.values()).map(mat -> ModItems.register(String.format("%s_%s", mat.getName(), slot.m_266355_()), () -> new APArmorItem((IAPArmor)mat, slot))).collect(Collectors.toSet());
    }

    public static void registerToolForType(RegistryObject<Item>[] swords, RegistryObject<Item>[] axes, RegistryObject<Item>[] pickaxes, RegistryObject<Item>[] bows) {
        IntStream.range(0, ArmorPlus.AP_TOOL_MATERIAL_LENGTH).forEach(i -> {
            APToolMaterial mat = APToolMaterial.values()[i];
            swords[i] = ModItems.register(String.format("%s_sword", mat.getName()), () -> new APSwordItem(mat));
            axes[i] = ModItems.register(String.format("%s_battle_axe", mat.getName()), () -> new APBattleAxeItem(mat));
            pickaxes[i] = ModItems.register(String.format("%s_pickaxe", mat.getName()), () -> new APPickaxeItem(mat));
            bows[i] = ModItems.register(String.format("%s_bow", mat.getName()), () -> new APBowItem(mat));
        });
    }

    public static RegistryObject<Item> registerBase(APToolMaterial mat, String type) {
        return ModItems.register(String.format("%s_%s_base", mat.getName(), type), APItemBase::new);
    }

    public static void registerMaceForType(RegistryObject<Item>[] maces) {
        IntStream.range(0, ArmorPlus.AP_MACE_MAT_LENGTH).forEach(i -> {
            APMaceMaterial mat = APMaceMaterial.values()[i];
            maces[i] = ModItems.register(String.format("%s_mace", mat.getName()), () -> new APMaceItem(mat, new Item.Properties()));
        });
    }

    public static RegistryObject<ArrowItem> registerArrow(ArrowType type) {
        return ModItems.register(type.getItemArrowName(), () -> new APArrowItem(type));
    }

    private static Set<RegistryObject<Item>> registerArmorBases(APArmorMaterial material) {
        Stream<ArmorItem.Type> armorSlots = Arrays.stream(ArmorItem.Type.values());
        return armorSlots.map(slot -> ModItems.register(String.format("%s_%s_base", material.getName(), slot.m_266355_()), () -> new APItemBase())).collect(Collectors.toSet());
    }

    static {
        ModItems.registerToolForType(SWORDS, BATTLE_AXES, PICKAXES, BOWS);
        ModItems.registerMaceForType(MACES);
    }
}

