/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.events;

import com.sofodev.armorplus.ArmorPlus;
import com.sofodev.armorplus.config.ArmorPlusConfig;
import com.sofodev.armorplus.events.data.FlightData;
import com.sofodev.armorplus.registry.items.armors.APArmorItem;
import com.sofodev.armorplus.registry.items.armors.IAPArmor;
import com.sofodev.armorplus.registry.items.extras.Buff;
import com.sofodev.armorplus.registry.items.extras.BuffInstance;
import com.sofodev.armorplus.registry.items.extras.DeBuff;
import com.sofodev.armorplus.registry.items.extras.IBuff;
import com.sofodev.armorplus.registry.items.materials.FrostCrystalItem;
import com.sofodev.armorplus.registry.items.tools.APMaceItem;
import com.sofodev.armorplus.registry.items.tools.properties.mace.APMaceType;
import com.sofodev.armorplus.registry.items.tools.properties.tool.IAPTool;
import com.sofodev.armorplus.registry.items.tools.properties.tool.Tool;
import com.sofodev.armorplus.utils.ItemArmorUtility;
import com.sofodev.armorplus.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoItem;

@Mod.EventBusSubscriber(modid="armorplus")
public class ModGlobalEvents {
    public static final Random RAND = new Random();
    public static int waterTicks = 0;
    public static int thunderingTicks = 0;
    public static FlightData flightData = new FlightData(false, false, false);

    @SubscribeEvent
    public static void onArrowLooseEvent(ArrowLooseEvent e) {
        Level world = e.getLevel();
        if (!world.m_5776_()) {
            ItemStack bow = e.getBow();
            int charge = e.getCharge();
            ArmorPlus.LOGGER.info("Charge at: " + charge);
            boolean hasUnknownEnchant = false;
            Map enchantmentList = EnchantmentHelper.m_44831_((ItemStack)bow);
            if (!enchantmentList.isEmpty() && (hasUnknownEnchant = enchantmentList.containsKey(ForgeRegistries.ENCHANTMENTS.getValue(Utils.setRL("unknown"))))) {
                Player entity = e.getEntity();
                Direction direction = entity.m_6350_();
                BlockPos position = entity.m_20183_();
                int distance = 5 + charge / (charge / 2);
                IntStream.range(distance, charge).forEach(arg_0 -> ModGlobalEvents.lambda$onArrowLooseEvent$1(world, direction, position, bow, (LivingEntity)entity, arg_0));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent e) {
        Player player = e.player;
        Level world = player.m_9236_();
        if (!world.m_5776_()) {
            boolean thundering = world.m_46470_();
            if (thundering) {
                int chance;
                boolean hasUnknownEnchant = false;
                if ((++thunderingTicks + 1) % 20 == 0 && (chance = RAND.nextInt(100) + 1) == 100) {
                    for (ItemStack item : player.m_6168_()) {
                        LightningBolt lightningboltentity;
                        BlockPos blockpos;
                        Item itemHead = item.m_41720_();
                        if (!(itemHead instanceof ArmorItem)) continue;
                        ArmorItem armorItem = (ArmorItem)itemHead;
                        ArmorMaterial material = armorItem.m_40401_();
                        Map enchantmentList = EnchantmentHelper.m_44831_((ItemStack)item);
                        if (enchantmentList.isEmpty() || !(hasUnknownEnchant = enchantmentList.containsKey(ForgeRegistries.ENCHANTMENTS.getValue(Utils.setRL("unknown")))) || armorItem.m_40402_() != EquipmentSlot.HEAD || material != ArmorMaterials.IRON && material != ArmorMaterials.CHAIN && material != ArmorMaterials.GOLD || !world.m_45527_(blockpos = player.m_20183_()) || (lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(world)) == null) continue;
                        lightningboltentity.m_20219_(Vec3.m_82539_((Vec3i)blockpos));
                        lightningboltentity.m_20879_((ServerPlayer)player);
                        lightningboltentity.setDamage(0.0f);
                        world.m_7967_((Entity)lightningboltentity);
                    }
                }
            }
            for (ItemStack stack : player.m_6168_()) {
                Item item = stack.m_41720_();
                if (!(item instanceof APArmorItem)) {
                    return;
                }
                IAPArmor mat = ((APArmorItem)item).getMat();
                boolean areExactMatch = ItemArmorUtility.areExactMatch(mat, player);
                List<IBuff> buffList = mat.getBuffInstances().get().stream().map(BuffInstance::getBuff).toList();
                if (areExactMatch && mat.config().enableArmorEffects.get().booleanValue()) {
                    if (buffList.isEmpty()) continue;
                    if (buffList.contains(Buff.FLIGHT)) {
                        ModGlobalEvents.shouldApplyFlight(e, player);
                    }
                    if (!buffList.contains(Buff.WATER_WEAKNESS)) continue;
                    ModGlobalEvents.shouldApplyWaterWeakness(player);
                    continue;
                }
                ModGlobalEvents.attemptDisableFlight(e, player);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinWorldEvent(EntityJoinLevelEvent e) {
        boolean isRunning = false;
    }

    private static void shouldApplyFlight(TickEvent.PlayerTickEvent e, Player player) {
        if (e.phase == TickEvent.Phase.END && e.side.isServer() && (!player.m_150110_().f_35936_ || Utils.allowsFlightByDefault(player))) {
            player.m_150110_().f_35936_ = true;
            ModGlobalEvents.updateClientServerFlight(player, true);
        }
    }

    private static void attemptDisableFlight(TickEvent.PlayerTickEvent e, Player player) {
        if (e.phase == TickEvent.Phase.END && e.side.isServer()) {
            player.m_6168_().forEach(i -> {
                if (!i.m_41619_() || flightData.allowFlying() && flightData.wasFlyingAllowed()) {
                    if (player.m_150110_().f_35936_ && flightData.allowFlying() && flightData.wasFlyingAllowed() && !Utils.allowsFlightByDefault(player)) {
                        player.m_150110_().f_35936_ = false;
                        player.m_150110_().f_35935_ = false;
                        ModGlobalEvents.updateClientServerFlight(player, false);
                        flightData.setFlying(false);
                        flightData.setAllowFlying(false);
                    } else if (i.m_41720_() instanceof APArmorItem && ItemArmorUtility.areExactMatch(((APArmorItem)i.m_41720_()).getMat(), player) && player.m_150110_().f_35936_) {
                        player.m_150110_().f_35936_ = false;
                        player.m_150110_().f_35935_ = false;
                        ModGlobalEvents.updateClientServerFlight(player, false);
                        flightData.setFlying(false);
                        flightData.setAllowFlying(false);
                    }
                }
            });
        }
    }

    private static void updateClientServerFlight(Player player, boolean allowFlying) {
        ModGlobalEvents.updateClientServerFlight(player, allowFlying, allowFlying && player.m_150110_().f_35935_);
    }

    private static void updateClientServerFlight(Player player, boolean allowFlying, boolean isFlying) {
        player.m_150110_().f_35936_ = allowFlying;
        player.m_150110_().f_35935_ = isFlying;
        ModGlobalEvents.updateFlightData(player);
    }

    private static void updateFlightData(Player player) {
        flightData.setFlying(player.m_150110_().f_35935_);
        flightData.setAllowFlying(player.m_150110_().f_35936_);
        flightData.setWasFlyingAllowed(player.m_150110_().f_35936_);
    }

    private static void shouldApplyWaterWeakness(Player player) {
        if (player.m_20069_() && (++waterTicks + 1) % 20 == 0) {
            for (ItemStack stack : player.m_6168_()) {
                if (stack.m_41619_() || stack.getEquipmentSlot() == null) continue;
                stack.m_41622_(1, (LivingEntity)player, event -> event.m_21166_(stack.getEquipmentSlot()));
            }
        }
    }

    @SubscribeEvent
    public static void onAttackEntityEvent(AttackEntityEvent event) {
        Map enchantmentList;
        Level world = event.getEntity().m_9236_();
        Player player = event.getEntity();
        Entity target = event.getTarget();
        float attackDamage = (float)player.m_21133_(Attributes.f_22281_);
        double movedDistance = player.f_19787_ - player.f_19867_;
        boolean isMace = false;
        ItemStack stack = player.m_21205_();
        boolean hasUnknown = false;
        if (!world.m_5776_() && !stack.m_41619_() && stack.m_41720_() instanceof TridentItem && !(enchantmentList = EnchantmentHelper.m_44831_((ItemStack)stack)).isEmpty() && (hasUnknown = enchantmentList.containsKey(ForgeRegistries.ENCHANTMENTS.getValue(Utils.setRL("unknown"))))) {
            BlockPos position = target.m_20183_();
            LightningBolt northBolt = (LightningBolt)EntityType.f_20465_.m_20615_(world);
            LightningBolt southBolt = (LightningBolt)EntityType.f_20465_.m_20615_(world);
            LightningBolt westBolt = (LightningBolt)EntityType.f_20465_.m_20615_(world);
            LightningBolt eastBolt = (LightningBolt)EntityType.f_20465_.m_20615_(world);
            LightningBolt centreBolt = (LightningBolt)EntityType.f_20465_.m_20615_(world);
            if (northBolt != null && southBolt != null && westBolt != null && eastBolt != null && centreBolt != null) {
                northBolt.m_20219_(Vec3.m_82539_((Vec3i)position.m_122013_(2)));
                southBolt.m_20219_(Vec3.m_82539_((Vec3i)position.m_122020_(2)));
                westBolt.m_20219_(Vec3.m_82539_((Vec3i)position.m_122025_(2)));
                eastBolt.m_20219_(Vec3.m_82539_((Vec3i)position.m_122030_(2)));
                centreBolt.m_20219_(Vec3.m_82539_((Vec3i)position));
                world.m_7967_((Entity)northBolt);
                world.m_7967_((Entity)southBolt);
                world.m_7967_((Entity)westBolt);
                world.m_7967_((Entity)eastBolt);
                world.m_7967_((Entity)centreBolt);
            }
            player.m_7292_(new MobEffectInstance(DeBuff.SLOWNESS.getEffect(), Utils.convertToSeconds(4)));
            player.m_7292_(new MobEffectInstance(DeBuff.MINING_FATIGUE.getEffect(), Utils.convertToSeconds(4)));
        }
        if (player.m_20096_() && movedDistance < (double)player.m_6113_() && stack.m_41720_() instanceof APMaceItem) {
            isMace = true;
        }
        if (isMace) {
            APMaceItem mace = (APMaceItem)stack.m_41720_();
            float sweepingDamage = 1.0f + APMaceType.getMaceSweepingRatio(mace.mat.getType()) * attackDamage;
            for (LivingEntity entity : world.m_45976_(LivingEntity.class, target.m_20191_().m_82377_(1.0, 0.25, 1.0))) {
                boolean isReachable;
                boolean isNewTarget = entity != player && entity != target;
                boolean isValidTarget = !player.m_7307_((Entity)entity) && (!(entity instanceof ArmorStand) || !((ArmorStand)entity).m_31677_());
                boolean bl = isReachable = player.m_20280_((Entity)entity) < 15.0;
                if (!isNewTarget || !isValidTarget || !isReachable) continue;
                double ratioX = Mth.m_14177_((float)(player.m_146908_() * ((float)Math.PI / 180)));
                double ratioZ = -Mth.m_14177_((float)(player.m_146908_() * ((float)Math.PI / 180)));
                entity.m_147240_((double)0.4f, ratioX, ratioZ);
                entity.m_6469_(player.m_269291_().m_269075_(player), sweepingDamage);
            }
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                ItemStack newStack = mace.setTag(player.m_21205_());
                CompoundTag nbt = newStack.m_41783_();
                if (nbt != null && nbt.m_128403_("key")) {
                    mace.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)player.m_21205_(), (ServerLevel)serverLevel), mace.controllerName, "animation.mace.swipe_attack");
                }
            }
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, player.m_5720_(), 1.0f, 1.0f);
            player.m_36346_();
        }
    }

    @SubscribeEvent
    public static void onStructByLightningEvent(EntityStruckByLightningEvent event) {
        boolean infused;
        ItemEntity entity;
        Item item;
        Entity entity2;
        if (!event.getEntity().m_9236_().f_46443_ && (entity2 = event.getEntity()) instanceof ItemEntity && (item = (entity = (ItemEntity)entity2).m_32055_().m_41720_()) instanceof FrostCrystalItem && !(infused = ((FrostCrystalItem)item).isInfused())) {
            FrostCrystalItem infusedCrystal = (FrostCrystalItem)Utils.getAPItem("infused_frost_crystal");
            entity.m_5552_(new ItemStack((ItemLike)infusedCrystal, entity.m_32055_().m_41613_()), 1.0f);
            entity.m_32055_().m_41764_(0);
            event.getLightning().m_20874_(true);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDamageEvent(LivingDamageEvent event) {
        IAPTool mat;
        List<IBuff> buffList;
        ItemStack stack;
        Item item;
        Player player;
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Player) || (player = (Player)entity).m_9236_().m_5776_() || !((item = (stack = player.m_21205_()).m_41720_()) instanceof Tool) || !(buffList = (mat = ((Tool)item).getMat()).getBuffInstances().get().stream().map(BuffInstance::getBuff).toList()).isEmpty()) {
            // empty if block
        }
        ArrayList<ItemStack> armor = new ArrayList<ItemStack>();
        for (ItemStack slotStack : entity.m_6168_()) {
            armor.add(slotStack);
        }
        if (!armor.isEmpty()) {
            for (ItemStack stack2 : armor) {
                boolean hasSoulHarden;
                if (!stack2.m_41763_() || !(stack2.m_41720_() instanceof ArmorItem)) continue;
                ArmorItem item2 = (ArmorItem)stack2.m_41720_();
                Map enchantmentList = EnchantmentHelper.m_44831_((ItemStack)stack2);
                if (enchantmentList.isEmpty() || !(hasSoulHarden = enchantmentList.containsKey(ForgeRegistries.ENCHANTMENTS.getValue(Utils.setRL("soul_harden"))))) continue;
                int maxDamageValue = stack2.m_41776_();
                int currentDamageValue = maxDamageValue - stack2.m_41773_();
                int halfDamageValue = Math.min(maxDamageValue / 2, Math.floorDiv(maxDamageValue, 2));
                if (currentDamageValue == maxDamageValue) {
                    stack2.m_41721_(0);
                    continue;
                }
                stack2.m_41721_(stack2.m_41773_() - 1);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        ArrayList<ItemStack> armor = new ArrayList<ItemStack>();
        for (ItemStack slotStack : entity.m_6168_()) {
            armor.add(slotStack);
        }
        if (!armor.isEmpty()) {
            for (ItemStack stack : armor) {
                boolean hasSoulHarden;
                if (!stack.m_41763_() || !(stack.m_41720_() instanceof ArmorItem)) continue;
                ArmorItem item = (ArmorItem)stack.m_41720_();
                Map enchantmentList = EnchantmentHelper.m_44831_((ItemStack)stack);
                if (enchantmentList.isEmpty() || !(hasSoulHarden = enchantmentList.containsKey(ForgeRegistries.ENCHANTMENTS.getValue(Utils.setRL("soul_harden"))))) continue;
                int maxDamageValue = stack.m_41776_();
                int incomingDamageValue = stack.m_41773_();
                int currentDamageValue = maxDamageValue - incomingDamageValue;
                int halfDamageValue = Math.min(maxDamageValue / 2, Math.floorDiv(maxDamageValue, 2));
                if (currentDamageValue == maxDamageValue) {
                    stack.m_41721_(halfDamageValue);
                    continue;
                }
                if (incomingDamageValue >= halfDamageValue) {
                    stack.m_41721_(halfDamageValue);
                    continue;
                }
                stack.m_41721_(maxDamageValue);
                stack.m_41764_(0);
            }
        }
    }

    @SubscribeEvent
    public static void onMobDeathEvent(LivingDropsEvent event) {
        ServerPlayer player;
        ItemStack heldItem;
        boolean oneInFourChance = RAND.nextInt(4) == 0;
        int amountZeroToTwo = RAND.nextInt(3);
        int amountFourToSix = RAND.nextInt(3) + 4;
        LivingEntity entity = event.getEntity();
        Entity trueSource = event.getSource().m_7639_();
        boolean isSourcePlayer = trueSource instanceof ServerPlayer;
        boolean hasSoulStealer = false;
        if (isSourcePlayer && !(heldItem = (player = (ServerPlayer)trueSource).m_21205_()).m_41619_()) {
            Map enchantmentList = EnchantmentHelper.m_44831_((ItemStack)heldItem);
            hasSoulStealer = enchantmentList.containsKey(ForgeRegistries.ENCHANTMENTS.getValue(Utils.setRL("soul_stealer")));
        }
        if (entity != null) {
            if (entity instanceof WitherBoss) {
                if (ArmorPlusConfig.witherBossDrops.enableTrophyDrops.get().booleanValue()) {
                    ModGlobalEvents.dropTrophyItem(entity, EntityType.f_20496_, 0.2f);
                }
                if (ArmorPlusConfig.witherBossDrops.enableRegularDrops.get().booleanValue()) {
                    ModGlobalEvents.dropItem((Entity)entity, "wither_bone", amountFourToSix);
                }
                if (hasSoulStealer && ArmorPlusConfig.witherBossDrops.enableSoulDrops.get().booleanValue()) {
                    ModGlobalEvents.dropItem((Entity)entity, "soul_wither_boss", 1);
                }
            } else if (entity instanceof EnderDragon) {
                if (ArmorPlusConfig.enderDragonDrops.enableTrophyDrops.get().booleanValue()) {
                    ModGlobalEvents.dropTrophyItem(entity, EntityType.f_20565_, 0.1f);
                }
                if (ArmorPlusConfig.enderDragonDrops.enableRegularDrops.get().booleanValue()) {
                    ModGlobalEvents.dropItem((Entity)entity, "ender_dragon_scale", amountFourToSix);
                }
                if (hasSoulStealer && ArmorPlusConfig.enderDragonDrops.enableSoulDrops.get().booleanValue()) {
                    ModGlobalEvents.dropItem((Entity)entity, "soul_ender_dragon", 1);
                }
            } else if (entity instanceof ElderGuardian) {
                if (ArmorPlusConfig.elderGuardianDrops.enableTrophyDrops.get().booleanValue()) {
                    ModGlobalEvents.dropTrophyItem(entity, EntityType.f_20563_, 0.2f);
                }
                if (ArmorPlusConfig.elderGuardianDrops.enableRegularDrops.get().booleanValue()) {
                    ModGlobalEvents.dropItem((Entity)entity, "guardian_scale", amountFourToSix);
                }
                if (hasSoulStealer && ArmorPlusConfig.elderGuardianDrops.enableSoulDrops.get().booleanValue()) {
                    ModGlobalEvents.dropItem((Entity)entity, "soul_elder_guardian", 1);
                }
            } else if (entity instanceof WitherSkeleton) {
                if (ArmorPlusConfig.witherSkeletonDrops.enableRegularDrops.get().booleanValue()) {
                    ModGlobalEvents.dropItem((Entity)entity, "wither_bone", amountZeroToTwo);
                }
                if (hasSoulStealer && oneInFourChance && ArmorPlusConfig.witherSkeletonDrops.enableSoulDrops.get().booleanValue()) {
                    ModGlobalEvents.dropItem((Entity)entity, "soul_wither_skeleton", 1);
                }
            } else if (entity instanceof Guardian) {
                if (ArmorPlusConfig.guardianDrops.enableRegularDrops.get().booleanValue()) {
                    ModGlobalEvents.dropItem((Entity)entity, "guardian_scale", amountZeroToTwo);
                }
                if (hasSoulStealer && oneInFourChance && ArmorPlusConfig.guardianDrops.enableSoulDrops.get().booleanValue()) {
                    ModGlobalEvents.dropItem((Entity)entity, "soul_guardian", 1);
                }
            } else if (entity instanceof EnderMan) {
                if (ArmorPlusConfig.endermanDrops.enableRegularDrops.get().booleanValue()) {
                    // empty if block
                }
                if (hasSoulStealer && oneInFourChance && ArmorPlusConfig.endermanDrops.enableSoulDrops.get().booleanValue()) {
                    ModGlobalEvents.dropItem((Entity)entity, "soul_enderman", 1);
                }
            } else if (entity instanceof Blaze) {
                if (ArmorPlusConfig.blazeDrops.enableRegularDrops.get().booleanValue()) {
                    // empty if block
                }
                if (hasSoulStealer && oneInFourChance && ArmorPlusConfig.blazeDrops.enableSoulDrops.get().booleanValue()) {
                    ModGlobalEvents.dropItem((Entity)entity, "soul_blaze", 1);
                }
            }
        }
    }

    private static void dropTrophyItem(LivingEntity entity, EntityType<?> type, float scale) {
        ItemStack trophy = new ItemStack((ItemLike)Utils.getAPItem("trophy"));
        CompoundTag tag = new CompoundTag();
        SpawnData trophyEntity = new SpawnData();
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey(type);
        if (key == null) {
            key = new ResourceLocation("minecraft:pig");
        }
        trophyEntity.m_186567_().m_128359_("id", key.toString());
        tag.m_128365_("DisplayEntity", (Tag)trophyEntity.m_186567_().m_6426_());
        tag.m_128350_("EntityScale", scale);
        trophy.m_41751_(tag);
        entity.m_19983_(trophy);
    }

    private static void dropItem(Entity entity, String item, int amount) {
        entity.m_19983_(new ItemStack((ItemLike)Utils.getAPItem(item), amount));
    }

    private static /* synthetic */ void lambda$onArrowLooseEvent$1(Level world, Direction direction, BlockPos position, ItemStack bow, LivingEntity entity, int i) {
        LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(world);
        if (lightningboltentity != null) {
            switch (direction) {
                case NORTH: {
                    lightningboltentity.m_20219_(Vec3.m_82539_((Vec3i)position.m_122013_(i)));
                    break;
                }
                case SOUTH: {
                    lightningboltentity.m_20219_(Vec3.m_82539_((Vec3i)position.m_122020_(i)));
                    break;
                }
                case WEST: {
                    lightningboltentity.m_20219_(Vec3.m_82539_((Vec3i)position.m_122025_(i)));
                    break;
                }
                case EAST: {
                    lightningboltentity.m_20219_(Vec3.m_82539_((Vec3i)position.m_122030_(i)));
                }
            }
            world.m_7967_((Entity)lightningboltentity);
            bow.m_41622_(10, entity, event -> event.m_21190_(entity.m_7655_()));
        }
    }
}

