/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.data;

import com.sofodev.armorplus.registry.ModItems;
import com.sofodev.armorplus.utils.DataUtils;
import com.sofodev.armorplus.utils.Utils;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;

public class SmithingRecipeMaker
extends RecipeProvider {
    private DataGenerator generator;

    public SmithingRecipeMaker(DataGenerator generatorIn) {
        super(generatorIn.getPackOutput());
        this.generator = generatorIn;
    }

    public static SmithingRecipeMaker get(DataGenerator generator) {
        return new SmithingRecipeMaker(generator);
    }

    public void buildBaseToFullSmithing(Consumer<FinishedRecipe> consumer, Set<RegistryObject<Item>> bases, ItemLike soul) {
        bases.forEach(base -> this.buildBaseToFullSmithing(consumer, (RegistryObject<Item>)base, soul));
    }

    public void buildBaseToFullSmithing(Consumer<FinishedRecipe> consumer, RegistryObject<Item> base, ItemLike soul) {
        this.buildSmithing(consumer, (ItemLike)base.get(), soul, RecipeCategory.COMBAT, (ItemLike)DataUtils.quickModLookupItem(base.getId()));
    }

    @SafeVarargs
    public final void buildBaseToFullSmithing(Consumer<FinishedRecipe> consumer, ItemLike soul, RegistryObject<Item> ... bases) {
        Arrays.stream(bases).forEach(base -> this.buildSmithing(consumer, (ItemLike)base.get(), soul, RecipeCategory.COMBAT, (ItemLike)DataUtils.quickModLookupItem(base.getId())));
    }

    public void buildVanillaToEnhancedSmithing(Consumer<FinishedRecipe> consumer, ItemLike vanilla, RegistryObject<Item> mat) {
        this.buildSmithing(consumer, vanilla, (ItemLike)mat.get(), RecipeCategory.COMBAT, (ItemLike)Utils.getAPItem(DataUtils.getPath(vanilla)));
    }

    public void buildSmithing(Consumer<FinishedRecipe> consumer, ItemLike base, ItemLike addition, RecipeCategory category, ItemLike result) {
        String path = DataUtils.getPath(base);
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{base}), (Ingredient)Ingredient.f_43901_, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{addition}), (RecipeCategory)category, (Item)result.m_5456_()).m_266439_("has_req", (CriterionTriggerInstance)SmithingRecipeMaker.m_125977_((ItemLike)addition)).m_266371_(consumer, Utils.setRL("smithing/" + path));
    }

    protected void m_245200_(Consumer<FinishedRecipe> con) {
        this.registerSmithingRecipes(con);
    }

    private void registerSmithingRecipes(Consumer<FinishedRecipe> con) {
        SmithingRecipeMaker smither = new SmithingRecipeMaker(this.generator);
        smither.buildBaseToFullSmithing(con, ModItems.SUPER_STAR_BASES, (ItemLike)ModItems.WITHER_BOSS_SOUL.get());
        smither.buildBaseToFullSmithing(con, ModItems.GUARDIAN_BASES, (ItemLike)ModItems.ELDER_GUARDIAN_SOUL.get());
        smither.buildBaseToFullSmithing(con, ModItems.ENDER_DRAGON_BASES, (ItemLike)ModItems.ENDER_DRAGON_SOUL.get());
        smither.buildBaseToFullSmithing(con, ModItems.SLAYER_BASES, (ItemLike)ModItems.SLAYER_SOUL.get());
        smither.buildBaseToFullSmithing(con, (ItemLike)ModItems.WITHER_BOSS_SOUL.get(), ModItems.SUPER_STAR_SWORD_BASE, ModItems.SUPER_STAR_BATTLE_AXE_BASE, ModItems.SUPER_STAR_PICKAXE_BASE, ModItems.SUPER_STAR_BOW_BASE);
        smither.buildBaseToFullSmithing(con, (ItemLike)ModItems.ELDER_GUARDIAN_SOUL.get(), ModItems.GUARDIAN_SWORD_BASE, ModItems.GUARDIAN_BATTLE_AXE_BASE, ModItems.GUARDIAN_PICKAXE_BASE, ModItems.GUARDIAN_BOW_BASE);
        smither.buildBaseToFullSmithing(con, (ItemLike)ModItems.ENDER_DRAGON_SOUL.get(), ModItems.ENDER_DRAGON_SWORD_BASE, ModItems.ENDER_DRAGON_BATTLE_AXE_BASE, ModItems.ENDER_DRAGON_PICKAXE_BASE, ModItems.ENDER_DRAGON_BOW_BASE);
        smither.buildBaseToFullSmithing(con, (ItemLike)ModItems.SLAYER_SOUL.get(), ModItems.SLAYER_SWORD_BASE, ModItems.SLAYER_BATTLE_AXE_BASE, ModItems.SLAYER_PICKAXE_BASE, ModItems.SLAYER_BOW_BASE);
        smither.buildVanillaToEnhancedSmithing(con, (ItemLike)Items.f_42480_, ModItems.ENHANCED_NETHERITE);
        smither.buildVanillaToEnhancedSmithing(con, (ItemLike)Items.f_42481_, ModItems.ENHANCED_NETHERITE);
        smither.buildVanillaToEnhancedSmithing(con, (ItemLike)Items.f_42482_, ModItems.ENHANCED_NETHERITE);
        smither.buildVanillaToEnhancedSmithing(con, (ItemLike)Items.f_42483_, ModItems.ENHANCED_NETHERITE);
        smither.buildSmithing(con, (ItemLike)ModItems.INFUSED_LAVA_CRYSTAL.get(), (ItemLike)ModItems.INFUSED_FROST_CRYSTAL.get(), RecipeCategory.MISC, (ItemLike)ModItems.INFUSED_FROST_LAVA_CRYSTAL.get());
        smither.buildSmithing(con, (ItemLike)ModItems.INFUSED_FROST_CRYSTAL.get(), (ItemLike)ModItems.INFUSED_LAVA_CRYSTAL.get(), RecipeCategory.MISC, (ItemLike)ModItems.INFUSED_FROST_LAVA_CRYSTAL.get());
    }
}

