/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.data;

import com.sofodev.armorplus.ArmorPlus;
import com.sofodev.armorplus.data.CraftingRecipeMaker;
import com.sofodev.armorplus.data.recipe.Grid;
import com.sofodev.armorplus.data.recipe.GridInput;
import com.sofodev.armorplus.data.recipe.Result;
import com.sofodev.armorplus.registry.ModBlocks;
import com.sofodev.armorplus.registry.ModItems;
import com.sofodev.armorplus.utils.DataUtils;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;

public class Recipes
extends RecipeProvider
implements DataProvider,
IConditionBuilder {
    public static final List<TagKey<Item>> BRICK_COLORS = Stream.of(Tags.Items.DYES_BLACK, Tags.Items.DYES_BLUE, Tags.Items.DYES_GREEN, Tags.Items.DYES_PURPLE, Tags.Items.DYES_RED, Tags.Items.DYES_WHITE, Tags.Items.DYES_YELLOW, Tags.Items.DYES_ORANGE).collect(Collectors.toList());
    public static final List<ItemLike> MATERIALS_ORDERED = Stream.of(Items.f_42413_, Items.f_42451_, Items.f_42534_, Items.f_42616_, Items.f_41999_, (Item)ModItems.INFUSED_LAVA_CRYSTAL.get(), (Item)ModItems.GUARDIAN_SCALE.get(), (Item)ModItems.WITHER_BONE.get(), (Item)ModItems.ENDER_DRAGON_SCALE.get()).collect(Collectors.toList());
    public static final List<ItemLike> BLOCK_MATERIALS_ORDERED = Stream.of(Items.f_42200_, Items.f_42153_, Items.f_41854_, Items.f_42110_, (FeatureElement)ModBlocks.COMPRESSED_OBSIDIAN.get(), (FeatureElement)ModItems.INFUSED_LAVA_CRYSTAL.get(), (FeatureElement)ModItems.GUARDIAN_SCALE.get(), (FeatureElement)ModItems.WITHER_BONE.get(), (FeatureElement)ModItems.ENDER_DRAGON_SCALE.get()).collect(Collectors.toList());
    public static final List<ItemLike> LOW_TO_MID_TIER_MATERIAL_LIST = Stream.of(Items.f_42200_, Items.f_42153_, Items.f_41854_, Items.f_42110_, (FeatureElement)ModBlocks.COMPRESSED_OBSIDIAN.get()).collect(Collectors.toList());
    private DataGenerator generator;

    public Recipes(DataGenerator generatorIn) {
        super(generatorIn.getPackOutput());
        this.generator = generatorIn;
    }

    protected void m_245200_(Consumer<FinishedRecipe> con) {
        this.registerCraftingRecipes(con);
    }

    private void registerCraftingRecipes(Consumer<FinishedRecipe> con) {
        int i2;
        CraftingRecipeMaker crafter = new CraftingRecipeMaker(this.generator);
        int l = ArmorPlus.AP_STONE_BRICKS_LENGTH;
        for (i2 = 0; i2 < l; ++i2) {
            crafter.buildStoneBrick(con, ModBlocks.CASTLE_BLOCKS[i2], ModBlocks.CASTLE_BLOCK_TOWERS[i2], ModBlocks.CASTLE_BLOCK_CORNERS[i2], ModBlocks.CASTLE_BLOCK_WALLS[i2], ModBlocks.CASTLE_BLOCK_STAIRS[i2], ModBlocks.CASTLE_BLOCK_SLABS[i2]);
        }
        for (i2 = 0; i2 < l; ++i2) {
            crafter.buildStoneBrick(con, ModBlocks.STONE_BRICKS[i2], ModBlocks.STONE_BRICK_TOWERS[i2], ModBlocks.STONE_BRICK_CORNERS[i2], ModBlocks.STONE_BRICK_WALLS[i2], ModBlocks.STONE_BRICK_STAIRS[i2], ModBlocks.STONE_BRICK_SLABS[i2]);
        }
        for (i2 = 0; i2 < l; ++i2) {
            crafter.buildColoredBrick(con, ModBlocks.STONE_BRICKS[i2], BRICK_COLORS.get(i2));
        }
        for (i2 = 0; i2 < ArmorPlus.AP_TOOL_MATERIAL_LENGTH - 5; ++i2) {
            crafter.buildSword(con, ModItems.SWORDS[i2], LOW_TO_MID_TIER_MATERIAL_LIST.get(i2), (ItemLike)Items.f_42398_);
            crafter.buildBattleAxe(con, ModItems.BATTLE_AXES[i2], LOW_TO_MID_TIER_MATERIAL_LIST.get(i2), (ItemLike)Items.f_42398_);
            crafter.buildPickaxe(con, ModItems.PICKAXES[i2], LOW_TO_MID_TIER_MATERIAL_LIST.get(i2), (ItemLike)Items.f_42398_);
            crafter.buildBow(con, ModItems.BOWS[i2], LOW_TO_MID_TIER_MATERIAL_LIST.get(i2));
        }
        int lava = ArmorPlus.AP_TOOL_MATERIAL_LENGTH - 5;
        crafter.buildSword(con, ModItems.SWORDS[lava], (ItemLike)ModItems.INFUSED_LAVA_CRYSTAL.get(), (ItemLike)ModItems.OBSIDIAN_STICK.get());
        crafter.buildBattleAxe(con, ModItems.BATTLE_AXES[lava], (ItemLike)ModItems.INFUSED_LAVA_CRYSTAL.get(), (ItemLike)ModItems.OBSIDIAN_STICK.get());
        crafter.buildPickaxe(con, ModItems.PICKAXES[lava], (ItemLike)ModItems.INFUSED_LAVA_CRYSTAL.get(), (ItemLike)ModItems.OBSIDIAN_STICK.get());
        crafter.buildBow(con, ModItems.BOWS[lava], (ItemLike)ModItems.INFUSED_LAVA_CRYSTAL.get());
        crafter.buildSword(con, ModItems.GUARDIAN_SWORD_BASE, (ItemLike)ModItems.GUARDIAN_SCALE.get(), (ItemLike)Items.f_42192_, (ItemLike)ModItems.OBSIDIAN_STICK.get());
        crafter.buildSword(con, ModItems.SUPER_STAR_SWORD_BASE, (ItemLike)ModItems.WITHER_BONE.get(), (ItemLike)Items.f_42686_, (ItemLike)ModItems.OBSIDIAN_STICK.get());
        crafter.buildSword(con, ModItems.ENDER_DRAGON_SWORD_BASE, (ItemLike)ModItems.ENDER_DRAGON_SCALE.get(), (ItemLike)Items.f_42735_, (ItemLike)ModItems.OBSIDIAN_STICK.get());
        crafter.buildBattleAxe(con, ModItems.GUARDIAN_BATTLE_AXE_BASE, (ItemLike)ModItems.GUARDIAN_SCALE.get(), (ItemLike)Items.f_42192_, (ItemLike)ModItems.OBSIDIAN_STICK.get());
        crafter.buildBattleAxe(con, ModItems.SUPER_STAR_BATTLE_AXE_BASE, (ItemLike)ModItems.WITHER_BONE.get(), (ItemLike)ModItems.OBSIDIAN_STICK.get());
        crafter.buildBattleAxe(con, ModItems.ENDER_DRAGON_BATTLE_AXE_BASE, (ItemLike)ModItems.ENDER_DRAGON_SCALE.get(), (ItemLike)Items.f_42735_, (ItemLike)ModItems.OBSIDIAN_STICK.get());
        crafter.buildPickaxe(con, ModItems.GUARDIAN_PICKAXE_BASE, (ItemLike)ModItems.GUARDIAN_SCALE.get(), (ItemLike)Items.f_42192_, (ItemLike)ModItems.OBSIDIAN_STICK.get());
        crafter.buildPickaxe(con, ModItems.SUPER_STAR_PICKAXE_BASE, (ItemLike)ModItems.WITHER_BONE.get(), (ItemLike)Items.f_42686_, (ItemLike)ModItems.OBSIDIAN_STICK.get());
        crafter.buildPickaxe(con, ModItems.ENDER_DRAGON_PICKAXE_BASE, (ItemLike)ModItems.ENDER_DRAGON_SCALE.get(), (ItemLike)Items.f_42735_, (ItemLike)ModItems.OBSIDIAN_STICK.get());
        crafter.buildBow(con, ModItems.GUARDIAN_BOW_BASE, (ItemLike)Items.f_42192_, (ItemLike)ModItems.GUARDIAN_SCALE.get());
        crafter.buildBow(con, ModItems.SUPER_STAR_BOW_BASE, (ItemLike)Items.f_42686_, (ItemLike)ModItems.WITHER_BONE.get());
        crafter.buildBow(con, ModItems.ENDER_DRAGON_BOW_BASE, (ItemLike)Items.f_42735_, (ItemLike)ModItems.ENDER_DRAGON_SCALE.get());
        crafter.buildOrderedArrow(con, Arrays.asList(ModItems.ITEM_COAL_ARROW, ModItems.ITEM_REDSTONE_ARROW, ModItems.ITEM_LAPIS_ARROW, ModItems.ITEM_EMERALD_ARROW, ModItems.ITEM_OBSIDIAN_ARROW, ModItems.ITEM_INFUSED_LAVA_ARROW, ModItems.ITEM_GUARDIAN_ARROW, ModItems.ITEM_SUPER_STAR_ARROW, ModItems.ITEM_ENDER_DRAGON_ARROW));
        crafter.buildSoul(con, ModItems.WITHER_BOSS_SOUL, (ItemLike)ModItems.WITHER_SKELETON_SOUL.get(), (ItemLike)ModItems.WITHER_BONE.get(), (ItemLike)Items.f_42049_);
        crafter.buildSoul(con, ModItems.ELDER_GUARDIAN_SOUL, (ItemLike)ModItems.GUARDIAN_SOUL.get(), (ItemLike)ModItems.GUARDIAN_SCALE.get(), (ItemLike)Items.f_42192_);
        crafter.buildSoul(con, ModItems.ENDER_DRAGON_SOUL, (ItemLike)ModItems.ENDERMAN_SOUL.get(), (ItemLike)ModItems.ENDER_DRAGON_SCALE.get(), (ItemLike)Items.f_42102_);
        crafter.buildEnhanced(con, ModItems.ENHANCED_CHAINMAIL, (ItemLike)ModItems.CHAINMAIL.get());
        crafter.buildEnhanced(con, ModItems.ENHANCED_IRON, (ItemLike)Items.f_42416_);
        crafter.buildEnhanced(con, ModItems.ENHANCED_GOLD, (ItemLike)Items.f_42417_);
        crafter.buildEnhanced(con, ModItems.ENHANCED_DIAMOND, (ItemLike)Items.f_42415_);
        crafter.buildEnhanced(con, ModItems.ENHANCED_NETHERITE, (ItemLike)Items.f_42418_);
        String enGroup = "ap_en_";
        String enPath = "enhanced";
        crafter.buildArmorSet(con, "chainmail", (ItemLike)ModItems.ENHANCED_CHAINMAIL.get(), enGroup + "chainmail", enPath, "", "");
        crafter.buildArmorSet(con, "iron", (ItemLike)ModItems.ENHANCED_IRON.get(), enGroup + "iron", enPath, "", "");
        crafter.buildArmorSet(con, "golden", (ItemLike)ModItems.ENHANCED_GOLD.get(), enGroup + "gold", enPath, "", "");
        crafter.buildArmorSet(con, "diamond", (ItemLike)ModItems.ENHANCED_DIAMOND.get(), enGroup + "diamond", enPath, "", "");
        crafter.buildArmorSet(con, "chicken", (ItemLike)Items.f_42402_, "");
        crafter.buildArmorSet(con, "slime", (ItemLike)Items.f_42204_, "");
        crafter.buildArmorSet(con, "coal", (ItemLike)Items.f_42200_, "");
        crafter.buildArmorSet(con, "lapis", (ItemLike)Items.f_41854_, "");
        crafter.buildArmorSet(con, "redstone", (ItemLike)Items.f_42153_, "");
        crafter.buildArmorSet(con, "emerald", (ItemLike)Items.f_42110_, "");
        crafter.buildArmorSet(con, "obsidian", (ItemLike)ModBlocks.COMPRESSED_OBSIDIAN.get(), "");
        crafter.buildArmorSet(con, "infused_lava", (ItemLike)ModItems.INFUSED_LAVA_CRYSTAL.get(), "");
        crafter.buildArmorSet(con, "guardian", (ItemLike)ModItems.GUARDIAN_SCALE.get(), (ItemLike)Items.f_42192_, "_base");
        crafter.buildArmorSet(con, "super_star", (ItemLike)ModItems.WITHER_BONE.get(), (ItemLike)Items.f_42686_, "_base");
        crafter.buildArmorSet(con, "ender_dragon", (ItemLike)ModItems.ENDER_DRAGON_SCALE.get(), (ItemLike)Items.f_42735_, "_base");
        crafter.buildArmorSet(con, "frost", (ItemLike)ModItems.INFUSED_FROST_CRYSTAL.get(), "");
        crafter.buildArmorSet(con, "frost_lava", (ItemLike)ModItems.INFUSED_FROST_LAVA_CRYSTAL.get(), "");
        int bound = ModItems.MACES.length - 1;
        IntStream.range(0, bound).forEach(i -> {
            Item mace = (Item)ModItems.MACES[i].get();
            String path = DataUtils.getPath((ItemLike)mace).replace("item_", "").replace("_mace", "");
            ItemLike material = BLOCK_MATERIALS_ORDERED.get(i);
            crafter.build(con, RecipeCategory.COMBAT, Result.build((ItemLike)mace, "maces", path), GridInput.build(" DD", " SD", "S  ", 'S', 'D'), i > 4 ? (ItemLike)ModItems.OBSIDIAN_STICK.get() : (ItemLike)ModItems.WOODEN_ROD.get(), material);
            crafter.build(con, RecipeCategory.COMBAT, Result.build((ItemLike)mace, "maces", path).setSuffix("_alt"), GridInput.build("DD ", "DS ", "  S", 'S', 'D'), i > 4 ? (ItemLike)ModItems.OBSIDIAN_STICK.get() : (ItemLike)ModItems.WOODEN_ROD.get(), material);
        });
        crafter.buildStorage(con, (ItemLike)ModBlocks.COMPRESSED_LAVA_CRYSTAL.get(), (ItemLike)ModBlocks.LAVA_CRYSTAL.get());
        crafter.buildStorage(con, (ItemLike)ModBlocks.LAVA_CRYSTAL.get(), (ItemLike)ModItems.LAVA_CRYSTAL.get());
        crafter.buildStorage(con, (ItemLike)ModBlocks.COMPRESSED_INFUSED_LAVA_CRYSTAL.get(), (ItemLike)ModBlocks.INFUSED_LAVA_CRYSTAL.get());
        crafter.buildStorage(con, (ItemLike)ModBlocks.INFUSED_LAVA_CRYSTAL.get(), (ItemLike)ModItems.INFUSED_LAVA_CRYSTAL.get());
        crafter.buildStorage(con, (ItemLike)ModBlocks.COMPRESSED_OBSIDIAN.get(), (ItemLike)Items.f_41999_);
        crafter.buildStorage(con, (ItemLike)ModItems.LAVA_CRYSTAL.get(), (ItemLike)ModItems.LAVA_SHARD.get());
        crafter.buildStorage(con, (ItemLike)ModItems.FROST_CRYSTAL.get(), (ItemLike)ModItems.FROST_SHARD.get());
        crafter.build(con, RecipeCategory.MISC, Result.build((ItemLike)ModItems.THE_ULTIMATE_MATERIAL.get(), 1), (ItemLike)ModItems.INFUSED_FROST_LAVA_CRYSTAL.get(), (ItemLike)ModItems.WITHER_BONE.get(), (ItemLike)ModItems.ENDER_DRAGON_SCALE.get(), (ItemLike)ModItems.GUARDIAN_SCALE.get());
        crafter.buildComplexArmorSet(con, "slayer", (ItemLike)ModItems.THE_ULTIMATE_MATERIAL.get(), "super_star", "ender_dragon", "guardian", "_base");
        crafter.buildSword(con, ModItems.SLAYER_SWORD_BASE, (ItemLike)ModItems.THE_ULTIMATE_MATERIAL.get(), (ItemLike)ModItems.SUPER_STAR_SWORD_BASE.get(), (ItemLike)ModItems.ENDER_DRAGON_SWORD_BASE.get(), (ItemLike)ModItems.GUARDIAN_SWORD_BASE.get(), (ItemLike)ModItems.OBSIDIAN_STICK.get());
        crafter.buildBattleAxe(con, ModItems.SLAYER_BATTLE_AXE_BASE, (ItemLike)ModItems.THE_ULTIMATE_MATERIAL.get(), (ItemLike)ModItems.SUPER_STAR_BATTLE_AXE_BASE.get(), (ItemLike)ModItems.ENDER_DRAGON_BATTLE_AXE_BASE.get(), (ItemLike)ModItems.GUARDIAN_BATTLE_AXE_BASE.get(), (ItemLike)ModItems.OBSIDIAN_STICK.get());
        crafter.buildPickaxe(con, ModItems.SLAYER_PICKAXE_BASE, (ItemLike)ModItems.THE_ULTIMATE_MATERIAL.get(), (ItemLike)ModItems.SUPER_STAR_PICKAXE_BASE.get(), (ItemLike)ModItems.ENDER_DRAGON_PICKAXE_BASE.get(), (ItemLike)ModItems.GUARDIAN_PICKAXE_BASE.get(), (ItemLike)ModItems.OBSIDIAN_STICK.get());
        crafter.buildBow(con, ModItems.SLAYER_BOW_BASE, (ItemLike)ModItems.THE_ULTIMATE_MATERIAL.get(), (ItemLike)ModItems.SUPER_STAR_BOW_BASE.get(), (ItemLike)ModItems.ENDER_DRAGON_BOW_BASE.get(), (ItemLike)ModItems.GUARDIAN_BOW_BASE.get());
        crafter.build(con, RecipeCategory.MISC, Result.build((ItemLike)ModItems.SLAYER_SOUL.get(), 1).setGroup("slayer").setSuffix(""), (ItemLike)ModItems.ELDER_GUARDIAN_SOUL.get(), (ItemLike)ModItems.WITHER_BOSS_SOUL.get(), (ItemLike)ModItems.ENDER_DRAGON_SOUL.get());
        crafter.build(con, RecipeCategory.BUILDING_BLOCKS, Result.build((ItemLike)ModBlocks.SOUL_BOX.get()).setGroup("villager").setSuffix(""), GridInput.build("ASA", "SGS", "ASA", 'A', 'S', 'G'), new ItemLike[]{Items.f_41905_, Items.f_42049_, Items.f_42054_});
        crafter.build(con, RecipeCategory.MISC, Result.build((ItemLike)ModItems.OBSIDIAN_STICK.get(), 4).setGroup("materials").setSuffix(""), GridInput.build(Grid.build("X", "X", " "), 'X'), (ItemLike)Items.f_41999_);
        crafter.build(con, RecipeCategory.MISC, Result.build((ItemLike)ModItems.WOODEN_ROD.get(), 2).setGroup("materials").setSuffix(""), new ItemLike[]{Items.f_42398_, Items.f_42398_, Items.f_42398_, Items.f_42398_});
        crafter.build(con, RecipeCategory.BUILDING_BLOCKS, Result.build((ItemLike)ModBlocks.SNOW_BRICK.get(), 4).setGroup("snow_brick").setSuffix(""), GridInput.buildSmallSquare('X'), (ItemLike)Items.f_41981_);
        crafter.build(con, RecipeCategory.BUILDING_BLOCKS, Result.build((ItemLike)ModBlocks.SNOW_BRICK_STAIRS.get(), 4).setGroup("snow_brick_stairs").setSuffix(""), GridInput.buildStairs('X'), (ItemLike)ModBlocks.SNOW_BRICK.get());
        crafter.build(con, RecipeCategory.BUILDING_BLOCKS, Result.build((ItemLike)ModBlocks.SNOW_BRICK_SLAB.get(), 4).setGroup("snow_brick_slab").setSuffix(""), GridInput.buildSlab('X'), (ItemLike)ModBlocks.SNOW_BRICK.get());
    }
}

