/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.data;

import com.sofodev.armorplus.data.Recipes;
import com.sofodev.armorplus.data.recipe.Grid;
import com.sofodev.armorplus.data.recipe.GridInput;
import com.sofodev.armorplus.data.recipe.Input;
import com.sofodev.armorplus.data.recipe.Result;
import com.sofodev.armorplus.utils.DataUtils;
import com.sofodev.armorplus.utils.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CraftingRecipeMaker
extends RecipeProvider {
    public static final Logger LOGGER = LogManager.getLogger((String)"armorplus");

    public CraftingRecipeMaker(DataGenerator generatorIn) {
        super(generatorIn.getPackOutput());
    }

    public static CraftingRecipeMaker get(DataGenerator generator) {
        return new CraftingRecipeMaker(generator);
    }

    public void buildSword(Consumer<FinishedRecipe> con, RegistryObject<? extends Item> sword, ItemLike material, ItemLike handle) {
        String path = DataUtils.getPath(sword).replace("item_", "").replace("_sword", "").replace("_base", "");
        this.build(con, RecipeCategory.COMBAT, Result.build((ItemLike)sword.get(), path + "_swords", path), GridInput.build("M  ", "M  ", "S  ", 'S', 'M'), handle, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}));
    }

    public void buildSword(Consumer<FinishedRecipe> con, RegistryObject<? extends Item> sword, ItemLike material, ItemLike core, ItemLike handle) {
        String path = DataUtils.getPath(sword).replace("item_", "").replace("_sword", "").replace("_base", "");
        this.build(con, RecipeCategory.COMBAT, Result.build((ItemLike)sword.get(), path + "_swords", path), GridInput.build("M  ", "C  ", "S  ", 'S', 'M', 'C'), handle, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{core}));
    }

    public void buildSword(Consumer<FinishedRecipe> con, RegistryObject<? extends Item> sword, ItemLike material, ItemLike coreA, ItemLike coreB, ItemLike coreC, ItemLike handle) {
        String path = DataUtils.getPath(sword).replace("item_", "").replace("_sword", "").replace("_base", "");
        this.build(con, RecipeCategory.COMBAT, Result.build((ItemLike)sword.get(), path + "_swords", path), GridInput.build(" M ", "ABC", " S ", 'S', 'M', 'A', 'B', 'C'), handle, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreA}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreB}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreC}));
    }

    public void buildBattleAxe(Consumer<FinishedRecipe> con, RegistryObject<? extends Item> battleAxe, ItemLike material, ItemLike handle) {
        String path = DataUtils.getPath(battleAxe).replace("item_", "").replace("_battle_axe", "").replace("_base", "");
        this.build(con, RecipeCategory.TOOLS, Result.build((ItemLike)battleAxe.get(), path + "_battle_axes", path), GridInput.build("M M", "MSM", " S ", 'S', 'M'), handle, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}));
    }

    public void buildBattleAxe(Consumer<FinishedRecipe> con, RegistryObject<? extends Item> battleAxe, ItemLike material, ItemLike core, ItemLike handle) {
        String path = DataUtils.getPath(battleAxe).replace("item_", "").replace("_battle_axe", "").replace("_base", "");
        this.build(con, RecipeCategory.TOOLS, Result.build((ItemLike)battleAxe.get(), path + "_battle_axes", path), GridInput.build("M M", "MCM", " S ", 'S', 'M', 'C'), handle, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{core}));
    }

    public void buildBattleAxe(Consumer<FinishedRecipe> con, RegistryObject<? extends Item> battleAxe, ItemLike material, ItemLike coreA, ItemLike coreB, ItemLike coreC, ItemLike handle) {
        String path = DataUtils.getPath(battleAxe).replace("item_", "").replace("_battle_axe", "").replace("_base", "");
        this.build(con, RecipeCategory.TOOLS, Result.build((ItemLike)battleAxe.get(), path + "_battle_axes", path), GridInput.build("M M", "ABC", " S ", 'S', 'M', 'A', 'B', 'C'), handle, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreA}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreB}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreC}));
    }

    public void buildPickaxe(Consumer<FinishedRecipe> con, RegistryObject<? extends Item> battleAxe, ItemLike material, ItemLike handle) {
        String path = DataUtils.getPath(battleAxe).replace("item_", "").replace("_pickaxe", "").replace("_base", "");
        this.build(con, RecipeCategory.TOOLS, Result.build((ItemLike)battleAxe.get(), path + "_pickaxes", path), GridInput.build("MMM", " S ", " S ", 'S', 'M'), handle, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}));
    }

    public void buildPickaxe(Consumer<FinishedRecipe> con, RegistryObject<? extends Item> battleAxe, ItemLike material, ItemLike core, ItemLike handle) {
        String path = DataUtils.getPath(battleAxe).replace("item_", "").replace("_pickaxe", "").replace("_base", "");
        this.build(con, RecipeCategory.TOOLS, Result.build((ItemLike)battleAxe.get(), path + "_pickaxes", path), GridInput.build("MMM", " C ", " S ", 'S', 'M', 'C'), handle, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{core}));
    }

    public void buildPickaxe(Consumer<FinishedRecipe> con, RegistryObject<? extends Item> battleAxe, ItemLike material, ItemLike coreA, ItemLike coreB, ItemLike coreC, ItemLike handle) {
        String path = DataUtils.getPath(battleAxe).replace("item_", "").replace("_pickaxe", "").replace("_base", "");
        this.build(con, RecipeCategory.TOOLS, Result.build((ItemLike)battleAxe.get(), path + "_pickaxes", path), GridInput.build("AMC", " B ", " S ", 'S', 'M', 'A', 'B', 'C'), handle, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreA}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreB}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreC}));
    }

    public void buildBow(Consumer<FinishedRecipe> con, RegistryObject<? extends Item> bow, ItemLike material) {
        String path = DataUtils.getPath(bow).replace("item_", "").replace("_bow", "").replace("_base", "");
        this.build(con, RecipeCategory.COMBAT, Result.build((ItemLike)bow.get(), path + "_bows", path), GridInput.build("SM ", "S M", "SM ", 'S', 'M'), (ItemLike)Items.f_42401_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}));
        this.build(con, RecipeCategory.COMBAT, Result.build((ItemLike)bow.get(), path + "_bows", path).setSuffix("_alt"), GridInput.build(" MS", "M S", " MS", 'S', 'M'), (ItemLike)Items.f_42401_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}));
    }

    public void buildBow(Consumer<FinishedRecipe> con, RegistryObject<? extends Item> bow, ItemLike core, ItemLike material) {
        String path = DataUtils.getPath(bow).replace("item_", "").replace("_bow", "").replace("_base", "");
        this.build(con, RecipeCategory.COMBAT, Result.build((ItemLike)bow.get(), path + "_bows", path), GridInput.build("SM ", "S C", "SM ", 'S', 'M', 'C'), (ItemLike)Items.f_42401_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{core}));
        this.build(con, RecipeCategory.COMBAT, Result.build((ItemLike)bow.get(), path + "_bows", path).setSuffix("_alt"), GridInput.build(" MS", "C S", " MS", 'S', 'M', 'C'), (ItemLike)Items.f_42401_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{core}));
    }

    public void buildBow(Consumer<FinishedRecipe> con, RegistryObject<? extends Item> bow, ItemLike material, ItemLike coreA, ItemLike coreB, ItemLike coreC) {
        String path = DataUtils.getPath(bow).replace("item_", "").replace("_bow", "").replace("_base", "");
        this.build(con, RecipeCategory.COMBAT, Result.build((ItemLike)bow.get(), path + "_bows", path), GridInput.build("SAM", "SBM", "SCM", 'S', 'M', 'A', 'B', 'C'), (ItemLike)Items.f_42401_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreA}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreB}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreC}));
        this.build(con, RecipeCategory.COMBAT, Result.build((ItemLike)bow.get(), path + "_bows", path).setSuffix("_alt"), GridInput.build("MAS", "MBS", "MCS", 'S', 'M', 'A', 'B', 'C'), (ItemLike)Items.f_42401_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreA}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreB}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreC}));
    }

    public void buildArmorSet(Consumer<FinishedRecipe> con, String name, ItemLike material, String itemSuffix) {
        this.buildArmorSet(con, name, material, name, name, "", itemSuffix);
    }

    public void buildArmorSet(Consumer<FinishedRecipe> con, String name, ItemLike material, String group, String path, String suffix, String itemSuffix) {
        this.buildArmorSet(con, material, (ItemLike)Utils.getAPItem(name + "_helmet" + itemSuffix.trim()), (ItemLike)Utils.getAPItem(name + "_chestplate" + itemSuffix.trim()), (ItemLike)Utils.getAPItem(name + "_leggings" + itemSuffix.trim()), (ItemLike)Utils.getAPItem(name + "_boots" + itemSuffix.trim()), group, path, suffix);
    }

    public void buildArmorSet(Consumer<FinishedRecipe> con, ItemLike material, ItemLike head, ItemLike chest, ItemLike legs, ItemLike feet, String group, String path, String suffix) {
        this.buildArmorSet(con, Result.build(head, group, path).setSuffix(suffix), Result.build(chest, group, path).setSuffix(suffix), Result.build(legs, group, path).setSuffix(suffix), Result.build(feet, group, path).setSuffix(suffix), material);
    }

    public void buildArmorSet(Consumer<FinishedRecipe> con, String name, ItemLike material, ItemLike core, String itemSuffix) {
        this.buildArmorSet(con, name, material, core, name, name, "", itemSuffix);
    }

    public void buildArmorSet(Consumer<FinishedRecipe> con, String name, ItemLike material, ItemLike core, String group, String path, String suffix, String itemSuffix) {
        this.buildArmorSet(con, material, core, (ItemLike)Utils.getAPItem(name + "_helmet" + itemSuffix.trim()), (ItemLike)Utils.getAPItem(name + "_chestplate" + itemSuffix.trim()), (ItemLike)Utils.getAPItem(name + "_leggings" + itemSuffix.trim()), (ItemLike)Utils.getAPItem(name + "_boots" + itemSuffix.trim()), group, path, suffix);
    }

    public void buildArmorSet(Consumer<FinishedRecipe> con, ItemLike material, ItemLike core, ItemLike head, ItemLike chest, ItemLike legs, ItemLike feet, String group, String path, String suffix) {
        this.buildArmorSet(con, Result.build(head, group, path).setSuffix(suffix), Result.build(chest, group, path).setSuffix(suffix), Result.build(legs, group, path).setSuffix(suffix), Result.build(feet, group, path).setSuffix(suffix), material, core);
    }

    public void buildComplexArmorSet(Consumer<FinishedRecipe> con, String name, ItemLike material, String left, String middle, String right, String itemSuffix) {
        this.buildArmorSet(con, name, material, (ItemLike)Utils.getAPItem(left + "_helmet_base"), (ItemLike)Utils.getAPItem(middle + "_helmet_base"), (ItemLike)Utils.getAPItem(right + "_helmet_base"), (ItemLike)Utils.getAPItem(left + "_chestplate_base"), (ItemLike)Utils.getAPItem(middle + "_chestplate_base"), (ItemLike)Utils.getAPItem(right + "_chestplate_base"), (ItemLike)Utils.getAPItem(left + "_leggings_base"), (ItemLike)Utils.getAPItem(middle + "_leggings_base"), (ItemLike)Utils.getAPItem(right + "_leggings_base"), (ItemLike)Utils.getAPItem(left + "_boots_base"), (ItemLike)Utils.getAPItem(middle + "_boots_base"), (ItemLike)Utils.getAPItem(right + "_boots_base"), name, name, "", itemSuffix);
    }

    public void buildArmorSet(Consumer<FinishedRecipe> con, String name, ItemLike material, ItemLike coreHA, ItemLike coreHB, ItemLike coreHC, ItemLike coreCA, ItemLike coreCB, ItemLike coreCC, ItemLike coreLA, ItemLike coreLB, ItemLike coreLC, ItemLike coreBA, ItemLike coreBB, ItemLike coreBC, String group, String path, String suffix, String itemSuffix) {
        this.buildArmorSet(con, material, coreHA, coreHB, coreHC, coreCA, coreCB, coreCC, coreLA, coreLB, coreLC, coreBA, coreBB, coreBC, (ItemLike)Utils.getAPItem(name + "_helmet" + itemSuffix.trim()), (ItemLike)Utils.getAPItem(name + "_chestplate" + itemSuffix.trim()), (ItemLike)Utils.getAPItem(name + "_leggings" + itemSuffix.trim()), (ItemLike)Utils.getAPItem(name + "_boots" + itemSuffix.trim()), group, path, suffix);
    }

    public void buildArmorSet(Consumer<FinishedRecipe> con, ItemLike material, ItemLike coreHA, ItemLike coreHB, ItemLike coreHC, ItemLike coreCA, ItemLike coreCB, ItemLike coreCC, ItemLike coreLA, ItemLike coreLB, ItemLike coreLC, ItemLike coreBA, ItemLike coreBB, ItemLike coreBC, ItemLike head, ItemLike chest, ItemLike legs, ItemLike feet, String group, String path, String suffix) {
        this.buildArmorSet(con, Result.build(head, group, path).setSuffix(suffix), Result.build(chest, group, path).setSuffix(suffix), Result.build(legs, group, path).setSuffix(suffix), Result.build(feet, group, path).setSuffix(suffix), material, coreHA, coreHB, coreHC, coreCA, coreCB, coreCC, coreLA, coreLB, coreLC, coreBA, coreBB, coreBC);
    }

    public void buildEnhanced(Consumer<FinishedRecipe> con, RegistryObject<Item> enMaterial, ItemLike material) {
        this.buildFilling(con, Result.build((ItemLike)enMaterial.get(), "ap_en_mats", "enhanced"), material, (ItemLike)Items.f_42525_);
    }

    public void buildSoul(Consumer<FinishedRecipe> con, RegistryObject<Item> bossSoul, ItemLike lesserSoul, ItemLike mat, ItemLike extra) {
        this.build(con, RecipeCategory.MISC, Result.build((ItemLike)bossSoul.get(), 1, "ap_souls", "soul"), GridInput.build("ESE", "SXS", "ESE", 'S', 'X', 'E'), lesserSoul, Ingredient.m_43929_((ItemLike[])new ItemLike[]{mat}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{extra}));
    }

    public void buildOrderedArrow(Consumer<FinishedRecipe> con, List<RegistryObject<ArrowItem>> arrows) {
        IntStream.range(0, arrows.size()).forEach(i -> this.buildArrow(con, (RegistryObject<ArrowItem>)((RegistryObject)arrows.get(i)), Recipes.MATERIALS_ORDERED.get(i)));
    }

    public void buildArrow(Consumer<FinishedRecipe> con, RegistryObject<ArrowItem> arrow, ItemLike material) {
        String path = DataUtils.getPath(arrow).replace("item_", "").replace("_arrow", "");
        String group = "ap_arrows";
        this.buildFilling(con, Result.build((ItemLike)arrow.get(), 8, group, path), material, (ItemLike)Items.f_42412_);
    }

    public void buildColoredBrick(Consumer<FinishedRecipe> con, RegistryObject<Block> bricks, TagKey<Item> color) {
        this.buildFilling(con, Result.build((ItemLike)bricks.get(), 8, "colored_stone_bricks", "bricks"), (ItemLike)Items.f_42018_, Ingredient.m_204132_(color));
    }

    public void buildStoneBrick(Consumer<FinishedRecipe> con, RegistryObject<Block> bricks, RegistryObject<Block> tower, RegistryObject<Block> corner, RegistryObject<Block> wall, RegistryObject<Block> stairs, RegistryObject<Block> slab) {
        String group = "stone_brick";
        String pathWall = "wall";
        String pathTower = "tower";
        String pathCorner = "corner";
        String pathStairs = "stairs";
        String pathSlab = "slab";
        this.build(con, RecipeCategory.BUILDING_BLOCKS, Result.build((ItemLike)corner.get(), 4, this.getGroup("corner"), "corner"), GridInput.build("   ", "S  ", "SSS", 'S'), (ItemLike)bricks.get());
        this.build(con, RecipeCategory.BUILDING_BLOCKS, Result.build((ItemLike)wall.get(), 6, this.getGroup("wall"), "wall"), GridInput.build("   ", "SSS", "SSS", 'S'), (ItemLike)bricks.get());
        this.build(con, RecipeCategory.BUILDING_BLOCKS, Result.build((ItemLike)tower.get(), 8, this.getGroup("tower"), "tower"), GridInput.build("S S", "SSS", "SSS", 'S'), (ItemLike)bricks.get());
        this.build(con, RecipeCategory.BUILDING_BLOCKS, Result.build((ItemLike)stairs.get(), 4, this.getGroup("stairs"), "stairs"), GridInput.build("S  ", "SS ", "SSS", 'S'), (ItemLike)bricks.get());
        this.build(con, RecipeCategory.BUILDING_BLOCKS, Result.build((ItemLike)slab.get(), 6, this.getGroup("slab"), "slab"), GridInput.build("   ", "SSS", "   ", 'S'), (ItemLike)bricks.get());
    }

    private String getGroup(String form) {
        return "stone_brick_" + form;
    }

    public void buildStorage(Consumer<FinishedRecipe> con, ItemLike result, ItemLike item) {
        this.build(con, RecipeCategory.BUILDING_BLOCKS, Result.build(result, 1, "storage", "storage"), GridInput.buildBigSquare('X'), item);
        this.build(con, RecipeCategory.BUILDING_BLOCKS, Result.build(item, 9, "storage", "storage").setSuffix("_to_item"), result);
    }

    public void buildFilling(Consumer<FinishedRecipe> con, ItemLike result, ItemLike center, ItemLike filler) {
        this.buildFilling(con, Result.build(result), center, Ingredient.m_43929_((ItemLike[])new ItemLike[]{filler}));
    }

    public void buildFilling(Consumer<FinishedRecipe> con, ItemLike result, int count, ItemLike center, ItemLike filler) {
        this.buildFilling(con, Result.build(result, count), center, Ingredient.m_43929_((ItemLike[])new ItemLike[]{filler}));
    }

    public void buildFilling(Consumer<FinishedRecipe> con, Result result, ItemLike center, ItemLike filler) {
        this.buildFilling(con, result, center, Ingredient.m_43929_((ItemLike[])new ItemLike[]{filler}));
    }

    public void buildFilling(Consumer<FinishedRecipe> con, Result result, ItemLike center, Ingredient filler) {
        this.build(con, RecipeCategory.MISC, result, GridInput.build("SSS", "SXS", "SSS", 'X', 'S'), center, filler);
    }

    public void buildArmorSet(Consumer<FinishedRecipe> con, Result head, Result chest, Result legs, Result feet, ItemLike material) {
        this.buildHelmet(con, head, material);
        this.buildChestplate(con, chest, material);
        this.buildLeggings(con, legs, material);
        this.buildBoots(con, feet, material);
    }

    public void buildHelmet(Consumer<FinishedRecipe> con, Result result, ItemLike material) {
        this.build(con, RecipeCategory.COMBAT, result, GridInput.build("SSS", "S S", 'S'), material);
        this.build(con, RecipeCategory.COMBAT, result.setSuffix("_alt"), GridInput.build("   ", "SSS", "S S", 'S'), material);
    }

    public void buildChestplate(Consumer<FinishedRecipe> con, Result result, ItemLike material) {
        this.build(con, RecipeCategory.COMBAT, result, GridInput.build("S S", "SSS", "SSS", 'S'), material);
    }

    public void buildLeggings(Consumer<FinishedRecipe> con, Result result, ItemLike material) {
        this.build(con, RecipeCategory.COMBAT, result, GridInput.build("SSS", "S S", "S S", 'S'), material);
    }

    public void buildBoots(Consumer<FinishedRecipe> con, Result result, ItemLike material) {
        this.build(con, RecipeCategory.COMBAT, result, GridInput.build("S S", "S S", 'S'), material);
        this.build(con, RecipeCategory.COMBAT, result.setSuffix("_alt"), GridInput.build("   ", "S S", "S S", 'S'), material);
    }

    public void buildArmorSet(Consumer<FinishedRecipe> con, Result head, Result chest, Result legs, Result feet, ItemLike material, ItemLike core) {
        this.buildHelmet(con, head, material, core);
        this.buildChestplate(con, chest, material, core);
        this.buildLeggings(con, legs, material, core);
        this.buildBoots(con, feet, material, core);
    }

    public void buildHelmet(Consumer<FinishedRecipe> con, Result result, ItemLike material, ItemLike core) {
        this.build(con, RecipeCategory.COMBAT, result, GridInput.build("SCS", "S S", 'S', 'C'), material, Ingredient.m_43929_((ItemLike[])new ItemLike[]{core}));
        this.build(con, RecipeCategory.COMBAT, result.setSuffix("_alt"), GridInput.build("   ", "SCS", "S S", 'S', 'C'), material, Ingredient.m_43929_((ItemLike[])new ItemLike[]{core}));
    }

    public void buildChestplate(Consumer<FinishedRecipe> con, Result result, ItemLike material, ItemLike core) {
        this.build(con, RecipeCategory.COMBAT, result, GridInput.build("S S", "SCS", "SSS", 'S', 'C'), material, Ingredient.m_43929_((ItemLike[])new ItemLike[]{core}));
    }

    public void buildLeggings(Consumer<FinishedRecipe> con, Result result, ItemLike material, ItemLike core) {
        this.build(con, RecipeCategory.COMBAT, result, GridInput.build("SCS", "S S", "S S", 'S', 'C'), material, Ingredient.m_43929_((ItemLike[])new ItemLike[]{core}));
    }

    public void buildBoots(Consumer<FinishedRecipe> con, Result result, ItemLike material, ItemLike core) {
        this.build(con, RecipeCategory.COMBAT, result, GridInput.build("S S", "SCS", 'S', 'C'), material, Ingredient.m_43929_((ItemLike[])new ItemLike[]{core}));
        this.build(con, RecipeCategory.COMBAT, result.setSuffix("_alt"), GridInput.build("   ", "S S", "SCS", 'S', 'C'), material, Ingredient.m_43929_((ItemLike[])new ItemLike[]{core}));
    }

    public void buildArmorSet(Consumer<FinishedRecipe> con, Result head, Result chest, Result legs, Result feet, ItemLike material, ItemLike coreHA, ItemLike coreHB, ItemLike coreHC, ItemLike coreCA, ItemLike coreCB, ItemLike coreCC, ItemLike coreLA, ItemLike coreLB, ItemLike coreLC, ItemLike coreBA, ItemLike coreBB, ItemLike coreBC) {
        this.buildHelmet(con, head, material, coreHA, coreHB, coreHC);
        this.buildChestplate(con, chest, material, coreCA, coreCB, coreCC);
        this.buildLeggings(con, legs, material, coreLA, coreLB, coreLC);
        this.buildBoots(con, feet, material, coreBA, coreBB, coreBC);
    }

    public void buildHelmet(Consumer<FinishedRecipe> con, Result result, ItemLike material, ItemLike coreHA, ItemLike coreHB, ItemLike coreHC) {
        this.build(con, RecipeCategory.COMBAT, result, GridInput.build("ABC", "S S", 'S', 'A', 'B', 'C'), material, Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreHA}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreHB}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreHC}));
        this.build(con, RecipeCategory.COMBAT, result.setSuffix("_alt"), GridInput.build("   ", "ABC", "S S", 'S', 'A', 'B', 'C'), material, Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreHA}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreHB}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreHC}));
    }

    public void buildChestplate(Consumer<FinishedRecipe> con, Result result, ItemLike material, ItemLike coreCA, ItemLike coreCB, ItemLike coreCC) {
        this.build(con, RecipeCategory.COMBAT, result, GridInput.build("A C", "SBS", "SSS", 'S', 'A', 'B', 'C'), material, Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreCA}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreCB}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreCC}));
    }

    public void buildLeggings(Consumer<FinishedRecipe> con, Result result, ItemLike material, ItemLike coreLA, ItemLike coreLB, ItemLike coreLC) {
        this.build(con, RecipeCategory.COMBAT, result, GridInput.build("ABC", "S S", "S S", 'S', 'A', 'B', 'C'), material, Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreLA}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreLB}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreLC}));
    }

    public void buildBoots(Consumer<FinishedRecipe> con, Result result, ItemLike material, ItemLike coreBA, ItemLike coreBB, ItemLike coreBC) {
        this.build(con, RecipeCategory.COMBAT, result, GridInput.build("S S", "ABC", 'S', 'A', 'B', 'C'), material, Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreBA}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreBB}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreBC}));
        this.build(con, RecipeCategory.COMBAT, result.setSuffix("_alt"), GridInput.build("   ", "S S", "ABC", 'S', 'A', 'B', 'C'), material, Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreBA}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreBB}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{coreBC}));
    }

    public void build(Consumer<FinishedRecipe> consumer, RecipeCategory category, Result result, GridInput layout, ItemLike mainInput, Ingredient ... additional) {
        HashMap arrangedGrid = new HashMap();
        String path = DataUtils.getPath(result.getObject());
        Grid grid = layout.getGrid();
        Input input = layout.getSimpleInput();
        this.logGrid(result, path, grid);
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_246608_((RecipeCategory)category, (ItemLike)result.getObject(), (int)result.getCount());
        builder.m_126130_(grid.getFirstRow());
        builder.m_126130_(grid.getSecondRow());
        builder.m_126130_(grid.getThirdRow());
        builder.m_126127_(Character.valueOf(input.getA()), mainInput);
        IntStream.range(0, additional.length).forEach(i -> this.addIngredients(builder, input.getCharList().get(i + 1).charValue(), additional[i]));
        builder.m_126145_(Utils.setLocation(result.getGroup().orElse(path)));
        builder.m_126132_("has_req", (CriterionTriggerInstance)CraftingRecipeMaker.m_125977_((ItemLike)mainInput));
        builder.m_126140_(consumer, Utils.setRL("crafting/shaped/" + result.getPath().orElse("").trim() + result.getPrefix() + path + result.getSuffix()));
    }

    public void build(Consumer<FinishedRecipe> con, RecipeCategory category, Result result, GridInput layout, ItemLike input) {
        this.build(con, category, result, layout, input, Ingredient.f_43901_);
    }

    public void build(Consumer<FinishedRecipe> consumer, RecipeCategory category, Result result, GridInput layout, ItemLike ... inputs) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_246608_((RecipeCategory)category, (ItemLike)result.getObject(), (int)result.getCount());
        String path = DataUtils.getPath(result.getObject());
        Grid grid = layout.getGrid();
        Input input = layout.getSimpleInput();
        this.logGrid(result, path, grid);
        builder.m_126130_(grid.getFirstRow());
        builder.m_126130_(grid.getSecondRow());
        builder.m_126130_(grid.getThirdRow());
        IntStream.range(0, inputs.length).forEach(i -> this.addIngredients(builder, input.getCharList().get(i).charValue(), inputs[i]));
        boolean hasGroup = result.getGroup().isPresent();
        if (hasGroup) {
            builder.m_126145_(Utils.setLocation(result.getGroup().get()));
        }
        builder.m_126132_("has_req", (CriterionTriggerInstance)CraftingRecipeMaker.m_125977_((ItemLike)inputs[0]));
        builder.m_126140_(consumer, Utils.setRL("crafting/shaped/" + result.getPath().orElse("").trim() + result.getPrefix() + path + result.getSuffix()));
    }

    private void logGrid(Result result, String path, Grid grid) {
        LOGGER.info("Item: {}, count: {}", (Object)path, (Object)result.getCount());
        LOGGER.info("Building Pattern: [{}]", (Object)grid.getFirstRow());
        LOGGER.info("Building Pattern: [{}]", (Object)grid.getSecondRow());
        LOGGER.info("Building Pattern: [{}]", (Object)grid.getThirdRow());
    }

    private void addIngredients(ShapedRecipeBuilder builder, char character, Ingredient input) {
        if (!input.isSimple()) {
            builder.m_126124_(Character.valueOf(character), input);
        }
    }

    private void addIngredients(ShapedRecipeBuilder builder, char character, ItemLike input) {
        builder.m_126127_(Character.valueOf(character), input);
    }

    public void build(Consumer<FinishedRecipe> con, RecipeCategory category, Result result, ItemLike item) {
        this.build(con, category, result, item, Ingredient.f_43901_);
    }

    public void build(Consumer<FinishedRecipe> con, RecipeCategory category, Result result, ItemLike inputA, Ingredient ... inputs) {
        String path = DataUtils.getPath(result.getObject());
        LOGGER.info("Item: {}, count: {}", (Object)path, (Object)result.getCount());
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.m_246517_((RecipeCategory)category, (ItemLike)result.getObject(), (int)result.getCount());
        builder.m_126209_(inputA);
        Arrays.stream(inputs).forEach(ingredient -> this.addIngredients(builder, (Ingredient)ingredient));
        boolean hasGroup = result.getGroup().isPresent();
        if (hasGroup) {
            builder.m_126145_(Utils.setLocation(result.getGroup().get()));
        }
        builder.m_126132_("has_req", (CriterionTriggerInstance)CraftingRecipeMaker.m_125977_((ItemLike)inputA));
        builder.m_126140_(con, Utils.setRL("crafting/shapeless/" + result.getPath().orElse("").trim() + result.getPrefix() + path + result.getSuffix()));
    }

    public void build(Consumer<FinishedRecipe> con, RecipeCategory category, Result result, ItemLike ... item) {
        String path = DataUtils.getPath(result.getObject());
        LOGGER.info("Item: {}, count: {}", (Object)path, (Object)result.getCount());
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.m_246517_((RecipeCategory)category, (ItemLike)result.getObject(), (int)result.getCount());
        Arrays.stream(item).forEach(ingredient -> this.addIngredients(builder, (ItemLike)ingredient));
        boolean hasGroup = result.getGroup().isPresent();
        if (hasGroup) {
            builder.m_126145_(Utils.setLocation(result.getGroup().get()));
        }
        builder.m_126132_("has_req", (CriterionTriggerInstance)CraftingRecipeMaker.m_125977_((ItemLike)item[0]));
        builder.m_126140_(con, Utils.setRL("crafting/shapeless/" + result.getPath().orElse("").trim() + result.getPrefix() + path + result.getSuffix()));
    }

    private void addIngredients(ShapelessRecipeBuilder builder, Ingredient input) {
        if (!input.isSimple()) {
            builder.m_126184_(input);
        }
    }

    private void addIngredients(ShapelessRecipeBuilder builder, ItemLike input) {
        builder.m_126209_(input);
    }

    protected void m_245200_(Consumer<FinishedRecipe> output) {
    }
}

