/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus;

import com.sofodev.armorplus.config.ArmorPlusConfig;
import com.sofodev.armorplus.config.ConfigHelper;
import com.sofodev.armorplus.registry.ModBlocks;
import com.sofodev.armorplus.registry.ModCreativeTabs;
import com.sofodev.armorplus.registry.ModEnchantments;
import com.sofodev.armorplus.registry.ModEntities;
import com.sofodev.armorplus.registry.ModItems;
import com.sofodev.armorplus.registry.ModPoI;
import com.sofodev.armorplus.registry.ModPotions;
import com.sofodev.armorplus.registry.ModVillagerProfessions;
import com.sofodev.armorplus.registry.blocks.castle.BrickColor;
import com.sofodev.armorplus.registry.entities.arrows.APArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.APArrowRenderer;
import com.sofodev.armorplus.registry.items.armors.APArmorMaterial;
import com.sofodev.armorplus.registry.items.tools.properties.mace.APMaceMaterial;
import com.sofodev.armorplus.registry.items.tools.properties.tool.APToolProperties;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib.GeckoLib;

@Mod(value="armorplus")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="armorplus")
public class ArmorPlus {
    public static final String MODID = "armorplus";
    public static final String MODNAME = "ArmorPlus";
    public static final String VERSION = "1.20.2-20.0.0";
    public static final Logger LOGGER = LogManager.getLogger((String)"armorplus");
    public static final int AP_ARMOR_MATERIAL_LENGTH = APArmorMaterial.values().length;
    public static final int AP_TOOL_MATERIAL_LENGTH = APToolProperties.values().length;
    public static final int AP_STONE_BRICKS_LENGTH = BrickColor.values().length;
    public static final int AP_MACE_MAT_LENGTH = APMaceMaterial.values().length;
    public static Map<Block, ItemLike> SMELTING_MAP = new HashMap<Block, ItemLike>();
    public static ArmorPlusConfig config;
    public static ArmorPlus instance;

    public ArmorPlus() {
        instance = this;
        GeckoLib.initialize();
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext modLoadingCTX = ModLoadingContext.get();
        config = ConfigHelper.register(ModLoadingContext.get(), FMLJavaModLoadingContext.get(), ModConfig.Type.COMMON, ArmorPlusConfig::new);
        ModBlocks.BLOCKS.register(modEventBus);
        ModEntities.ENTITY_TYPES.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModCreativeTabs.CREATIVE_MODE_TABS.register(modEventBus);
        ModEnchantments.ENCHANTMENTS.register(modEventBus);
        ModBlocks.TILE_ENTITIES.register(modEventBus);
        ModPotions.EFFECTS.register(modEventBus);
        ModVillagerProfessions.PROFESSIONS.register(modEventBus);
        ModPoI.POI_TYPES.register(modEventBus);
        modEventBus.addListener(this::onCommonSetup);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.addListener(this::onClientSetup);
        }
    }

    private static Map<Block, ItemLike> registerSmeltingMap() {
        HashMap<Block, ItemLike> map = new HashMap<Block, ItemLike>();
        List<? extends String> input = ArmorPlusConfig.autoSmeltingInput.get();
        List<? extends String> output = ArmorPlusConfig.autoSmeltingOutput.get();
        if (input.size() != output.size()) {
            throw new IllegalArgumentException("autoSmeltingInput and autoSmeltingOutput in config/ap_config.toml must have the same size!");
        }
        for (int i = 0; i < input.size(); ++i) {
            String entryInput = input.get(i);
            String entryOutput = output.get(i);
            Block fromBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(entryInput));
            Item toItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entryOutput));
            if (fromBlock != null && toItem != null) {
                map.put(fromBlock, (ItemLike)toItem);
                continue;
            }
            LOGGER.error("Block with the registry name: " + entryInput + " or Item with the registry name: " + entryOutput + " don't exist. Failed to add auto smelt recipe");
        }
        return map;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void registerRenderingHandler(EntityType<? extends APArrowEntity> entityClass, String name) {
        EntityRenderers.m_174036_(entityClass, rm -> new APArrowRenderer(rm, name));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void registerBowOverrides() {
        Arrays.stream(ModItems.BOWS).forEach(bow -> {
            ItemProperties.register((Item)bow.map(Item::m_5456_).orElse(ItemStack.f_41583_.m_41720_()), (ResourceLocation)new ResourceLocation("pull"), (stack, level, player, val) -> {
                if (player == null) {
                    return 0.0f;
                }
                return player.m_21211_() != stack ? 0.0f : (float)(stack.m_41779_() - player.m_21212_()) / 20.0f;
            });
            ItemProperties.register((Item)bow.map(Item::m_5456_).orElse(ItemStack.f_41583_.m_41720_()), (ResourceLocation)new ResourceLocation("pulling"), (stack, level, player, val) -> player != null && player.m_6117_() && player.m_21211_() == stack ? 1.0f : 0.0f);
        });
    }

    public static ArmorPlus getInstance() {
        return instance;
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(this::afterSetup);
    }

    private void afterSetup() {
        SMELTING_MAP = ArmorPlus.registerSmeltingMap();
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        ArmorPlus.registerRenderingHandler((EntityType<? extends APArrowEntity>)((EntityType)ModEntities.COAL_ARROW.get()), "coal");
        ArmorPlus.registerRenderingHandler((EntityType<? extends APArrowEntity>)((EntityType)ModEntities.LAPIS_ARROW.get()), "lapis");
        ArmorPlus.registerRenderingHandler((EntityType<? extends APArrowEntity>)((EntityType)ModEntities.REDSTONE_ARROW.get()), "redstone");
        ArmorPlus.registerRenderingHandler((EntityType<? extends APArrowEntity>)((EntityType)ModEntities.EMERALD_ARROW.get()), "emerald");
        ArmorPlus.registerRenderingHandler((EntityType<? extends APArrowEntity>)((EntityType)ModEntities.OBSIDIAN_ARROW.get()), "obsidian");
        ArmorPlus.registerRenderingHandler((EntityType<? extends APArrowEntity>)((EntityType)ModEntities.INFUSED_LAVA_ARROW.get()), "lava");
        ArmorPlus.registerRenderingHandler((EntityType<? extends APArrowEntity>)((EntityType)ModEntities.GUARDIAN_ARROW.get()), "guardian");
        ArmorPlus.registerRenderingHandler((EntityType<? extends APArrowEntity>)((EntityType)ModEntities.SUPER_STAR_ARROW.get()), "super_star");
        ArmorPlus.registerRenderingHandler((EntityType<? extends APArrowEntity>)((EntityType)ModEntities.ENDER_DRAGON_ARROW.get()), "ender_dragon");
        ArmorPlus.registerBowOverrides();
    }

    private void setRenderLayer(List<RegistryObject<Block>> blocks) {
        blocks.forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.m_110463_()));
    }
}

