/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.world.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import reascer.wom.world.item.WomArmorMaterials;

public class ArtefactsItem
extends ArmorItem {
    private static final EnumMap<ArmorItem.Type, UUID> ARMOR_MODIFIER_UUID_PER_TYPE = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), p_266744_ -> {
        p_266744_.put(ArmorItem.Type.BOOTS, UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"));
        p_266744_.put(ArmorItem.Type.LEGGINGS, UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"));
        p_266744_.put(ArmorItem.Type.CHESTPLATE, UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"));
        p_266744_.put(ArmorItem.Type.HELMET, UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150"));
    });
    public static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){

        protected ItemStack m_7498_(BlockSource p_40408_, ItemStack p_40409_) {
            return ArtefactsItem.m_40398_(p_40408_, p_40409_) ? p_40409_ : super.m_7498_(p_40408_, p_40409_);
        }
    };
    protected final ArmorItem.Type type;
    private final int defense;
    private final int health;
    private final float toughness;
    protected final float knockbackResistance;
    protected final ArmorMaterial material;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public static boolean m_40398_(BlockSource p_40399_, ItemStack p_40400_) {
        BlockPos blockpos = p_40399_.m_7961_().m_121945_((Direction)p_40399_.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
        List list = p_40399_.m_7727_().m_6443_(LivingEntity.class, new AABB(blockpos), EntitySelector.f_20408_.and(new EntitySelector.MobCanWearArmorEntitySelector(p_40400_)));
        if (list.isEmpty()) {
            return false;
        }
        LivingEntity livingentity = (LivingEntity)list.get(0);
        EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)p_40400_);
        ItemStack itemstack = p_40400_.m_41620_(1);
        livingentity.m_8061_(equipmentslot, itemstack);
        if (livingentity instanceof Mob) {
            ((Mob)livingentity).m_21409_(equipmentslot, 2.0f);
            ((Mob)livingentity).m_21530_();
        }
        return true;
    }

    public ArtefactsItem(WomArmorMaterials p_40386_, ArmorItem.Type p_266831_, Item.Properties p_40388_) {
        super((ArmorMaterial)p_40386_, p_266831_, p_40388_);
        this.material = p_40386_;
        this.type = p_266831_;
        this.health = p_40386_.getAddHealthAmountArray(this.m_40402_());
        this.defense = p_40386_.m_7366_(p_266831_);
        this.toughness = p_40386_.m_6651_();
        this.knockbackResistance = p_40386_.m_6649_();
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)DISPENSE_ITEM_BEHAVIOR);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = ARMOR_MODIFIER_UUID_PER_TYPE.get(p_266831_);
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)this.defense, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor toughness", (double)this.toughness, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(uuid, "health modifier", (double)this.health, AttributeModifier.Operation.ADDITION));
        if (this.knockbackResistance > 0.0f) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", (double)this.knockbackResistance, AttributeModifier.Operation.ADDITION));
        }
        this.defaultModifiers = builder.build();
    }

    public ArmorItem.Type m_266204_() {
        return this.type;
    }

    public int m_6473_() {
        return this.material.m_6646_();
    }

    public ArmorMaterial m_40401_() {
        return this.material;
    }

    public boolean m_6832_(ItemStack p_40392_, ItemStack p_40393_) {
        return this.material.m_6230_().test(p_40393_) || super.m_6832_(p_40392_, p_40393_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_40395_, Player p_40396_, InteractionHand p_40397_) {
        return this.m_269277_((Item)this, p_40395_, p_40396_, p_40397_);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot p_40390_) {
        return p_40390_ == this.type.m_266308_() ? this.defaultModifiers : super.m_7167_(p_40390_);
    }

    public int m_40404_() {
        return this.defense;
    }

    public float m_40405_() {
        return this.toughness;
    }

    public EquipmentSlot m_40402_() {
        return this.type.m_266308_();
    }

    public SoundEvent m_150681_() {
        return this.m_40401_().m_7344_();
    }

    public static enum Type {
        HELMET(EquipmentSlot.HEAD, "helmet"),
        CHESTPLATE(EquipmentSlot.CHEST, "chestplate"),
        LEGGINGS(EquipmentSlot.LEGS, "leggings"),
        BOOTS(EquipmentSlot.FEET, "boots");

        private final EquipmentSlot slot;
        private final String name;

        private Type(EquipmentSlot p_266754_, String p_266886_) {
            this.slot = p_266754_;
            this.name = p_266886_;
        }

        public EquipmentSlot getSlot() {
            return this.slot;
        }

        public String getName() {
            return this.name;
        }
    }
}

