/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.weaponpassive;

import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.skill.WOMSkillDataKeys;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPPlayAnimation;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class SatsujinPassive
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("010e5bfa-e6a2-11ec-8fea-0242ac120002");

    public SatsujinPassive(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            StaticAnimation[] resetAnimations;
            for (StaticAnimation staticAnimation : resetAnimations = new StaticAnimation[]{WOMAnimations.KATANA_AUTO_1, WOMAnimations.KATANA_AUTO_2, WOMAnimations.KATANA_AUTO_3, WOMAnimations.KATANA_DASH, WOMAnimations.HERRSCHER_AUSROTTUNG, WOMAnimations.KATANA_SHEATHED_AUTO_1, WOMAnimations.KATANA_SHEATHED_AUTO_2, WOMAnimations.KATANA_SHEATHED_AUTO_3, WOMAnimations.KATANA_GUARD, WOMAnimations.KATANA_GUARD_HIT, Animations.BIPED_HIT_SHORT, Animations.BIPED_HIT_LONG}) {
                if (!event.getAnimation().equals((Object)staticAnimation)) continue;
                container.getSkill().setConsumptionSynchronize((ServerPlayerPatch)event.getPlayerPatch(), 0.0f);
                container.getSkill().setStackSynchronize((ServerPlayerPatch)event.getPlayerPatch(), 0);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> this.onReset(container));
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
    }

    public void onReset(SkillContainer container) {
        PlayerPatch executer = container.getExecuter();
        if (!executer.isLogicalClient() && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SHEATH.get())).booleanValue()) {
            ServerPlayerPatch playerpatch = (ServerPlayerPatch)executer;
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SHEATH.get(), (Object)false, (ServerPlayer)playerpatch.getOriginal());
            playerpatch.modifyLivingMotionByCurrentItem();
            container.getSkill().setConsumptionSynchronize(playerpatch, 0.0f);
        }
    }

    public void setConsumption(SkillContainer container, float value) {
        PlayerPatch executer = container.getExecuter();
        if (!executer.isLogicalClient() && this.consumption < value) {
            ServerPlayer serverPlayer = (ServerPlayer)executer.getOriginal();
            if (!((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SHEATH.get())).booleanValue()) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SHEATH.get(), (Object)true, serverPlayer);
                boolean flag = false;
                if (container.getExecuter().getSkill(WOMSkills.MEDITATION) == null) {
                    flag = true;
                } else if ((Integer)container.getExecuter().getSkill(WOMSkills.MEDITATION).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) == 0) {
                    flag = true;
                }
                if (flag) {
                    ((ServerPlayerPatch)executer).modifyLivingMotionByCurrentItem();
                    SPPlayAnimation msg3 = new SPPlayAnimation(WOMAnimations.KATANA_SHEATHE, serverPlayer.m_19879_(), 0.0f);
                    EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf((Object)msg3, (ServerPlayer)serverPlayer);
                }
            } else {
                ((ServerPlayerPatch)executer).modifyLivingMotionByCurrentItem();
            }
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SHEATH.get(), (Object)true, serverPlayer);
        }
        super.setConsumption(container, value);
    }

    public boolean shouldDeactivateAutomatically(PlayerPatch<?> executer) {
        return true;
    }

    public float getCooldownRegenPerSecond(PlayerPatch<?> player) {
        return ((Player)player.getOriginal()).m_6117_() ? 0.0f : 1.0f;
    }
}

