/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.passive;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class CriticalKnowledgeSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("1d807798-1a3f-11ed-861d-0242ac120002");
    private float critDamage = 60.0f;
    private float critRate = 20.0f;

    public CriticalKnowledgeSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID, event -> {
            int fire = 0;
            int blast = 0;
            for (ItemStack ArmorPiece : ((Player)container.getExecuter().getOriginal()).m_6168_()) {
                fire += ArmorPiece.getEnchantmentLevel(Enchantments.f_44966_);
                blast += ArmorPiece.getEnchantmentLevel(Enchantments.f_44968_);
            }
            this.critRate = (float)fire / 16.0f * 80.0f + 20.0f;
            this.critDamage = (1.0f + 0.15f * (float)blast) * 100.0f;
            int chance = Math.abs(new Random().nextInt()) % 100;
            if ((float)chance < this.critRate) {
                event.getTarget().m_6469_((DamageSource)event.getDamageSource(), event.getAttackDamage() * (1.0f + 0.15f * (float)blast));
                if (!((ServerPlayerPatch)event.getPlayerPatch()).isLogicalClient()) {
                    ServerPlayerPatch executer = (ServerPlayerPatch)event.getPlayerPatch();
                    event.getTarget().m_5496_(SoundEvents.f_11928_, 1.5f, 0.5f);
                    event.getTarget().m_5496_(SoundEvents.f_11934_, 1.5f, 2.0f);
                    ((ServerLevel)((ServerPlayer)executer.getOriginal()).m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123797_, event.getTarget().m_20185_(), event.getTarget().m_20186_() + 1.2, event.getTarget().m_20189_(), 30, 0.1, 0.1, 0.1, 1.0);
                }
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(String.format("%.0f", Float.valueOf(this.critRate)));
        list.add(String.format("%.0f", Float.valueOf(this.critDamage)));
        return list;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        int fire = 0;
        int blast = 0;
        for (ItemStack ArmorPiece : ((Player)container.getExecuter().getOriginal()).m_6168_()) {
            fire += ArmorPiece.getEnchantmentLevel(Enchantments.f_44966_);
            blast += ArmorPiece.getEnchantmentLevel(Enchantments.f_44968_);
        }
        this.critRate = (float)fire / 16.0f * 80.0f + 20.0f;
        this.critDamage = (1.0f + 0.15f * (float)blast) * 100.0f;
    }
}

