/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.EnumUtils;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class RenderResizableCuboid {
    private static final int[] combinedARGB = new int[EnumUtils.DIRECTIONS.length];
    private static final Vector3f NORMAL = (Vector3f)Util.m_137469_((Object)new Vector3f(1.0f, 1.0f, 1.0f), Vector3f::normalize);
    private static final int X_AXIS_MASK = 1 << Direction.Axis.X.ordinal();
    private static final int Y_AXIS_MASK = 1 << Direction.Axis.Y.ordinal();
    private static final int Z_AXIS_MASK = 1 << Direction.Axis.Z.ordinal();

    private RenderResizableCuboid() {
    }

    public static void renderCube(MekanismRenderer.Model3D cube, PoseStack matrix, VertexConsumer buffer, int argb, int light, int overlay, FaceDisplay faceDisplay, Camera camera, @Nullable Vec3 renderPos) {
        Arrays.fill(combinedARGB, argb);
        RenderResizableCuboid.renderCube(cube, matrix, buffer, combinedARGB, light, overlay, faceDisplay, camera, renderPos);
    }

    public static void renderCube(MekanismRenderer.Model3D cube, PoseStack matrix, VertexConsumer buffer, int[] colors, int light, int overlay, FaceDisplay faceDisplay, Camera camera, @Nullable Vec3 renderPos) {
        MekanismRenderer.Model3D.SpriteInfo[] sprites = new MekanismRenderer.Model3D.SpriteInfo[6];
        int axisToRender = 0;
        if (renderPos != null && faceDisplay != FaceDisplay.BOTH) {
            Vec3 camPos = camera.m_90583_();
            Vec3 minPos = renderPos.m_82520_((double)cube.minX, (double)cube.minY, (double)cube.minZ);
            Vec3 maxPos = renderPos.m_82520_((double)cube.maxX, (double)cube.maxY, (double)cube.maxZ);
            for (Direction direction : EnumUtils.DIRECTIONS) {
                MekanismRenderer.Model3D.SpriteInfo sprite = cube.getSpriteToRender(direction);
                if (sprite == null) continue;
                Direction.Axis axis = direction.m_122434_();
                Direction.AxisDirection axisDirection = direction.m_122421_();
                double planeLocation = switch (axisDirection) {
                    default -> throw new IncompatibleClassChangeError();
                    case Direction.AxisDirection.POSITIVE -> axis.m_6150_(maxPos.f_82479_, maxPos.f_82480_, maxPos.f_82481_);
                    case Direction.AxisDirection.NEGATIVE -> axis.m_6150_(minPos.f_82479_, minPos.f_82480_, minPos.f_82481_);
                };
                double cameraPosition = axis.m_6150_(camPos.f_82479_, camPos.f_82480_, camPos.f_82481_);
                if (faceDisplay.front == (axisDirection == Direction.AxisDirection.POSITIVE)) {
                    if (!(cameraPosition >= planeLocation)) continue;
                    sprites[direction.ordinal()] = sprite;
                    axisToRender |= 1 << axis.ordinal();
                    continue;
                }
                if (!(cameraPosition <= planeLocation)) continue;
                sprites[direction.ordinal()] = sprite;
                axisToRender |= 1 << axis.ordinal();
            }
        } else {
            for (Vec3 direction : EnumUtils.DIRECTIONS) {
                MekanismRenderer.Model3D.SpriteInfo sprite = cube.getSpriteToRender((Direction)direction);
                if (sprite == null) continue;
                sprites[direction.ordinal()] = sprite;
                axisToRender |= 1 << direction.m_122434_().ordinal();
            }
        }
        if (axisToRender == 0) {
            return;
        }
        int xShift = Mth.m_14143_((float)cube.minX);
        int yShift = Mth.m_14143_((float)cube.minY);
        int zShift = Mth.m_14143_((float)cube.minZ);
        float minX = cube.minX - (float)xShift;
        float minY = cube.minY - (float)yShift;
        float minZ = cube.minZ - (float)zShift;
        float maxX = cube.maxX - (float)xShift;
        float maxY = cube.maxY - (float)yShift;
        float maxZ = cube.maxZ - (float)zShift;
        int xDelta = RenderResizableCuboid.calculateDelta(minX, maxX);
        int yDelta = RenderResizableCuboid.calculateDelta(minY, maxY);
        int zDelta = RenderResizableCuboid.calculateDelta(minZ, maxZ);
        float[] xBounds = RenderResizableCuboid.getBlockBounds(xDelta, minX, maxX);
        float[] yBounds = RenderResizableCuboid.getBlockBounds(yDelta, minY, maxY);
        float[] zBounds = RenderResizableCuboid.getBlockBounds(zDelta, minZ, maxZ);
        matrix.m_85836_();
        matrix.m_252880_((float)xShift, (float)yShift, (float)zShift);
        PoseStack.Pose lastMatrix = matrix.m_85850_();
        Matrix4f matrix4f = lastMatrix.m_252922_();
        NormalData normal = new NormalData(lastMatrix.m_252943_(), NORMAL, faceDisplay);
        Vector3f from = new Vector3f();
        Vector3f to = new Vector3f();
        int xIncrement = 1;
        int yIncrement = 1;
        int zIncrement = 1;
        if (axisToRender == X_AXIS_MASK) {
            xIncrement = Math.max(xDelta, 1);
        } else if (axisToRender == Y_AXIS_MASK) {
            yIncrement = Math.max(yDelta, 1);
        } else if (axisToRender == Z_AXIS_MASK) {
            zIncrement = Math.max(zDelta, 1);
        }
        for (int y = 0; y <= yDelta; y += yIncrement) {
            MekanismRenderer.Model3D.SpriteInfo upSprite = y == yDelta ? sprites[Direction.UP.ordinal()] : null;
            MekanismRenderer.Model3D.SpriteInfo downSprite = y == 0 ? sprites[Direction.DOWN.ordinal()] : null;
            from.y = yBounds[y];
            to.y = yBounds[y + 1];
            for (int z = 0; z <= zDelta; z += zIncrement) {
                MekanismRenderer.Model3D.SpriteInfo northSprite = z == 0 ? sprites[Direction.NORTH.ordinal()] : null;
                MekanismRenderer.Model3D.SpriteInfo southSprite = z == zDelta ? sprites[Direction.SOUTH.ordinal()] : null;
                from.z = zBounds[z];
                to.z = zBounds[z + 1];
                for (int x = 0; x <= xDelta; x += xIncrement) {
                    MekanismRenderer.Model3D.SpriteInfo westSprite = x == 0 ? sprites[Direction.WEST.ordinal()] : null;
                    MekanismRenderer.Model3D.SpriteInfo eastSprite = x == xDelta ? sprites[Direction.EAST.ordinal()] : null;
                    from.x = xBounds[x];
                    to.x = xBounds[x + 1];
                    RenderResizableCuboid.putTexturedQuad(buffer, matrix4f, westSprite, from, to, Direction.WEST, colors, light, overlay, faceDisplay, normal);
                    RenderResizableCuboid.putTexturedQuad(buffer, matrix4f, eastSprite, from, to, Direction.EAST, colors, light, overlay, faceDisplay, normal);
                    RenderResizableCuboid.putTexturedQuad(buffer, matrix4f, northSprite, from, to, Direction.NORTH, colors, light, overlay, faceDisplay, normal);
                    RenderResizableCuboid.putTexturedQuad(buffer, matrix4f, southSprite, from, to, Direction.SOUTH, colors, light, overlay, faceDisplay, normal);
                    RenderResizableCuboid.putTexturedQuad(buffer, matrix4f, upSprite, from, to, Direction.UP, colors, light, overlay, faceDisplay, normal);
                    RenderResizableCuboid.putTexturedQuad(buffer, matrix4f, downSprite, from, to, Direction.DOWN, colors, light, overlay, faceDisplay, normal);
                }
            }
        }
        matrix.m_85849_();
    }

    private static float[] getBlockBounds(int delta, float start, float end) {
        float[] bounds = new float[2 + delta];
        bounds[0] = start;
        int offset = (int)start;
        for (int i = 1; i <= delta; ++i) {
            bounds[i] = i + offset;
        }
        bounds[delta + 1] = end;
        return bounds;
    }

    private static int calculateDelta(float min, float max) {
        int delta = (int)(max - (float)((int)min));
        if ((double)max % 1.0 == 0.0) {
            --delta;
        }
        return delta;
    }

    private static void putTexturedQuad(VertexConsumer buffer, Matrix4f matrix, @Nullable MekanismRenderer.Model3D.SpriteInfo spriteInfo, Vector3f from, Vector3f to, Direction face, int[] colors, int light, int overlay, FaceDisplay faceDisplay, NormalData normal) {
        Bounds uBounds;
        if (spriteInfo == null) {
            return;
        }
        float x1 = from.x();
        float y1 = from.y();
        float z1 = from.z();
        float x2 = to.x();
        float y2 = to.y();
        float z2 = to.z();
        Bounds vBounds = switch (face.m_122434_()) {
            case Direction.Axis.Z -> {
                uBounds = Bounds.calculate(x2, x1);
                yield Bounds.calculate(y1, y2);
            }
            case Direction.Axis.X -> {
                uBounds = Bounds.calculate(z2, z1);
                yield Bounds.calculate(y1, y2);
            }
            default -> {
                uBounds = Bounds.calculate(x1, x2);
                yield Bounds.calculate(z2, z1);
            }
        };
        float minU = spriteInfo.getU(uBounds.min());
        float maxU = spriteInfo.getU(uBounds.max());
        float minV = spriteInfo.getV(1.0f - vBounds.max());
        float maxV = spriteInfo.getV(1.0f - vBounds.min());
        int argb = colors[face.ordinal()];
        switch (face) {
            case DOWN: {
                RenderResizableCuboid.drawFace(buffer, matrix, argb, minU, maxU, minV, maxV, light, overlay, faceDisplay, normal, x1, y1, z2, x1, y1, z1, x2, y1, z1, x2, y1, z2);
                break;
            }
            case UP: {
                RenderResizableCuboid.drawFace(buffer, matrix, argb, minU, maxU, minV, maxV, light, overlay, faceDisplay, normal, x1, y2, z1, x1, y2, z2, x2, y2, z2, x2, y2, z1);
                break;
            }
            case NORTH: {
                RenderResizableCuboid.drawFace(buffer, matrix, argb, minU, maxU, minV, maxV, light, overlay, faceDisplay, normal, x1, y1, z1, x1, y2, z1, x2, y2, z1, x2, y1, z1);
                break;
            }
            case SOUTH: {
                RenderResizableCuboid.drawFace(buffer, matrix, argb, minU, maxU, minV, maxV, light, overlay, faceDisplay, normal, x2, y1, z2, x2, y2, z2, x1, y2, z2, x1, y1, z2);
                break;
            }
            case WEST: {
                RenderResizableCuboid.drawFace(buffer, matrix, argb, minU, maxU, minV, maxV, light, overlay, faceDisplay, normal, x1, y1, z2, x1, y2, z2, x1, y2, z1, x1, y1, z1);
                break;
            }
            case EAST: {
                RenderResizableCuboid.drawFace(buffer, matrix, argb, minU, maxU, minV, maxV, light, overlay, faceDisplay, normal, x2, y1, z1, x2, y2, z1, x2, y2, z2, x2, y1, z2);
            }
        }
    }

    private static void drawFace(VertexConsumer buffer, Matrix4f matrix, int argb, float minU, float maxU, float minV, float maxV, int light, int overlay, FaceDisplay faceDisplay, NormalData normal, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        int red = FastColor.ARGB32.m_13665_((int)argb);
        int green = FastColor.ARGB32.m_13667_((int)argb);
        int blue = FastColor.ARGB32.m_13669_((int)argb);
        int alpha = FastColor.ARGB32.m_13655_((int)argb);
        if (faceDisplay.front) {
            buffer.m_252986_(matrix, x1, y1, z1).m_6122_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(overlay).m_85969_(light).m_5601_(normal.front.x(), normal.front.y(), normal.front.z()).m_5752_();
            buffer.m_252986_(matrix, x2, y2, z2).m_6122_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(overlay).m_85969_(light).m_5601_(normal.front.x(), normal.front.y(), normal.front.z()).m_5752_();
            buffer.m_252986_(matrix, x3, y3, z3).m_6122_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(overlay).m_85969_(light).m_5601_(normal.front.x(), normal.front.y(), normal.front.z()).m_5752_();
            buffer.m_252986_(matrix, x4, y4, z4).m_6122_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(overlay).m_85969_(light).m_5601_(normal.front.x(), normal.front.y(), normal.front.z()).m_5752_();
        }
        if (faceDisplay.back) {
            buffer.m_252986_(matrix, x4, y4, z4).m_6122_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(overlay).m_85969_(light).m_5601_(normal.back.x(), normal.back.y(), normal.back.z()).m_5752_();
            buffer.m_252986_(matrix, x3, y3, z3).m_6122_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(overlay).m_85969_(light).m_5601_(normal.back.x(), normal.back.y(), normal.back.z()).m_5752_();
            buffer.m_252986_(matrix, x2, y2, z2).m_6122_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(overlay).m_85969_(light).m_5601_(normal.back.x(), normal.back.y(), normal.back.z()).m_5752_();
            buffer.m_252986_(matrix, x1, y1, z1).m_6122_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(overlay).m_85969_(light).m_5601_(normal.back.x(), normal.back.y(), normal.back.z()).m_5752_();
        }
    }

    public static enum FaceDisplay {
        FRONT(true, false),
        BACK(false, true),
        BOTH(true, true);

        private final boolean front;
        private final boolean back;

        private FaceDisplay(boolean front, boolean back) {
            this.front = front;
            this.back = back;
        }
    }

    private record NormalData(Vector3f front, Vector3f back) {
        private NormalData(Matrix3f normalMatrix, Vector3f normal, FaceDisplay faceDisplay) {
            this(faceDisplay.front ? NormalData.calculate(normalMatrix, normal.x(), normal.y(), normal.z()) : new Vector3f(), faceDisplay.back ? NormalData.calculate(normalMatrix, -normal.x(), -normal.y(), -normal.z()) : new Vector3f());
        }

        private static Vector3f calculate(Matrix3f normalMatrix, float x, float y, float z) {
            Vector3f matrixAdjustedNormal = new Vector3f(x, y, z);
            return matrixAdjustedNormal.mul((Matrix3fc)normalMatrix);
        }
    }

    private record Bounds(float min, float max) {
        public static Bounds calculate(float min, float max) {
            boolean bigger = min > max;
            min %= 1.0f;
            max %= 1.0f;
            if (bigger) {
                return new Bounds(min == 0.0f ? 1.0f : min, max);
            }
            return new Bounds(min, max == 0.0f ? 1.0f : max);
        }
    }
}

