/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;

public class CombatBehaviorGoal<T extends MobPatch<?>>
extends Goal {
    protected final Mob mob;
    protected final T mobpatch;
    protected final CombatBehaviors<T> combatBehaviors;

    public CombatBehaviorGoal(T mobpatch, CombatBehaviors<T> combatBehaviors) {
        this.mob = (Mob)((EntityPatch)mobpatch).getOriginal();
        this.mobpatch = mobpatch;
        this.combatBehaviors = combatBehaviors;
        this.m_7021_(EnumSet.noneOf(Goal.Flag.class));
    }

    public boolean m_8036_() {
        return this.isValidTarget(this.mob.m_5448_());
    }

    public boolean m_8045_() {
        return this.m_8036_() && !((LivingEntityPatch)this.mobpatch).getEntityState().hurt();
    }

    public void m_8037_() {
        if (this.isValidTarget(this.mob.m_5448_())) {
            CombatBehaviors.Behavior<T> result;
            EntityState state = ((LivingEntityPatch)this.mobpatch).getEntityState();
            this.combatBehaviors.tick();
            if (this.combatBehaviors.hasActivatedMove()) {
                CombatBehaviors.Behavior<T> result2;
                if (state.canBasicAttack() && (result2 = this.combatBehaviors.tryProceed()) != null) {
                    result2.execute(this.mobpatch);
                }
            } else if (!state.inaction() && (result = this.combatBehaviors.selectRandomBehaviorSeries()) != null) {
                result.execute(this.mobpatch);
            }
        }
    }

    protected boolean isValidTarget(LivingEntity attackTarget) {
        return attackTarget != null && attackTarget.m_6084_() && !attackTarget.m_5833_() && (!(attackTarget instanceof Player) || !((Player)attackTarget).m_7500_());
    }
}

