/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.item;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.data.reloader.ItemCapabilityReloadListener;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.api.forgeevent.WeaponCapabilityPresetRegistryEvent;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.data.conditions.EpicFightConditions;
import yesman.epicfight.data.conditions.entity.LivingEntityCondition;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.server.SPDatapackSync;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.StyleEntry;
import yesman.epicfight.world.capabilities.item.WeaponCapability;
import yesman.epicfight.world.capabilities.item.WeaponCapabilityPresets;
import yesman.epicfight.world.capabilities.item.WeaponCategory;

public class WeaponTypeReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().create();
    private static final Map<ResourceLocation, Function<Item, CapabilityItem.Builder>> PRESETS = Maps.newHashMap();
    private static final Map<ResourceLocation, CompoundTag> TAGMAP = Maps.newHashMap();

    public static void registerDefaultWeaponTypes() {
        HashMap typeEntry = Maps.newHashMap();
        typeEntry.put(new ResourceLocation("epicfight", "axe"), WeaponCapabilityPresets.AXE);
        typeEntry.put(new ResourceLocation("epicfight", "fist"), WeaponCapabilityPresets.FIST);
        typeEntry.put(new ResourceLocation("epicfight", "hoe"), WeaponCapabilityPresets.HOE);
        typeEntry.put(new ResourceLocation("epicfight", "pickaxe"), WeaponCapabilityPresets.PICKAXE);
        typeEntry.put(new ResourceLocation("epicfight", "shovel"), WeaponCapabilityPresets.SHOVEL);
        typeEntry.put(new ResourceLocation("epicfight", "sword"), WeaponCapabilityPresets.SWORD);
        typeEntry.put(new ResourceLocation("epicfight", "spear"), WeaponCapabilityPresets.SPEAR);
        typeEntry.put(new ResourceLocation("epicfight", "greatsword"), WeaponCapabilityPresets.GREATSWORD);
        typeEntry.put(new ResourceLocation("epicfight", "uchigatana"), WeaponCapabilityPresets.UCHIGATANA);
        typeEntry.put(new ResourceLocation("epicfight", "tachi"), WeaponCapabilityPresets.TACHI);
        typeEntry.put(new ResourceLocation("epicfight", "longsword"), WeaponCapabilityPresets.LONGSWORD);
        typeEntry.put(new ResourceLocation("epicfight", "dagger"), WeaponCapabilityPresets.DAGGER);
        typeEntry.put(new ResourceLocation("epicfight", "bow"), WeaponCapabilityPresets.BOW);
        typeEntry.put(new ResourceLocation("epicfight", "crossbow"), WeaponCapabilityPresets.CROSSBOW);
        typeEntry.put(new ResourceLocation("epicfight", "trident"), WeaponCapabilityPresets.TRIDENT);
        typeEntry.put(new ResourceLocation("epicfight", "shield"), WeaponCapabilityPresets.SHIELD);
        WeaponCapabilityPresetRegistryEvent weaponCapabilityPresetRegistryEvent = new WeaponCapabilityPresetRegistryEvent(typeEntry);
        ModLoader.get().postEvent((Event)weaponCapabilityPresetRegistryEvent);
        weaponCapabilityPresetRegistryEvent.getTypeEntry().forEach(PRESETS::put);
    }

    public WeaponTypeReloadListener() {
        super(GSON, "capabilities/weapons/types");
    }

    protected void apply(Map<ResourceLocation, JsonElement> packEntry, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        WeaponTypeReloadListener.registerDefaultWeaponTypes();
        for (Map.Entry<ResourceLocation, JsonElement> entry : packEntry.entrySet()) {
            CompoundTag nbt = null;
            try {
                nbt = TagParser.m_129359_((String)entry.getValue().toString());
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
            try {
                WeaponCapability.Builder builder = WeaponTypeReloadListener.deserializeWeaponCapabilityBuilder(nbt);
                PRESETS.put(entry.getKey(), itemstack -> builder);
                TAGMAP.put(entry.getKey(), nbt);
            }
            catch (Exception e) {
                EpicFightMod.LOGGER.warn("Error while deserializing weapon type datapack: " + entry.getKey());
                e.printStackTrace();
            }
        }
    }

    public static Function<Item, CapabilityItem.Builder> get(String typeName) {
        ResourceLocation rl = new ResourceLocation(typeName);
        if (!PRESETS.containsKey(rl)) {
            throw new IllegalArgumentException("Can't find weapon type: " + rl);
        }
        return PRESETS.get(rl);
    }

    private static WeaponCapability.Builder deserializeWeaponCapabilityBuilder(CompoundTag tag) {
        SoundEvent sound;
        WeaponCapability.Builder builder = WeaponCapability.builder();
        builder.category(WeaponCategory.ENUM_MANAGER.get(tag.m_128461_("category")));
        builder.collider(ItemCapabilityReloadListener.deserializeCollider(tag.m_128469_("collider")));
        if (tag.m_128441_("hit_particle")) {
            ParticleType particleType = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation(tag.m_128461_("hit_particle")));
            if (particleType == null) {
                EpicFightMod.LOGGER.warn("Can't find particle type " + tag.m_128461_("hit_particle"));
            } else if (!(particleType instanceof HitParticleType)) {
                EpicFightMod.LOGGER.warn(tag.m_128461_("hit_particle") + " is not a hit particle type");
            } else {
                builder.hitParticle((HitParticleType)particleType);
            }
        }
        if (tag.m_128441_("swing_sound")) {
            sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(tag.m_128461_("swing_sound")));
            if (sound == null) {
                EpicFightMod.LOGGER.warn("Can't find swing sound " + tag.m_128461_("swing_sound"));
            } else {
                builder.swingSound(sound);
            }
        }
        if (tag.m_128441_("hit_sound")) {
            sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(tag.m_128461_("hit_sound")));
            if (sound == null) {
                EpicFightMod.LOGGER.warn("Can't find hit sound " + tag.m_128461_("hit_sound"));
            } else {
                builder.hitSound(sound);
            }
        }
        CompoundTag combosTag = tag.m_128469_("combos");
        for (Object key : combosTag.m_128431_()) {
            Style style = Style.ENUM_MANAGER.get((String)key);
            ListTag comboAnimations = combosTag.m_128437_((String)key, 8);
            StaticAnimation[] animArray = new StaticAnimation[comboAnimations.size()];
            for (int i = 0; i < comboAnimations.size(); ++i) {
                animArray[i] = EpicFightMod.getInstance().animationManager.findAnimationByPath(comboAnimations.m_128778_(i));
            }
            builder.newStyleCombo(style, animArray);
        }
        CompoundTag innateSkillsTag = tag.m_128469_("innate_skills");
        for (Object key : innateSkillsTag.m_128431_()) {
            Style style = Style.ENUM_MANAGER.get((String)key);
            builder.innateSkill(style, arg_0 -> WeaponTypeReloadListener.lambda$deserializeWeaponCapabilityBuilder$1(innateSkillsTag, (String)key, arg_0));
        }
        CompoundTag livingmotionModifierTag = tag.m_128469_("livingmotion_modifier");
        for (String sStyle : livingmotionModifierTag.m_128431_()) {
            Style style = Style.ENUM_MANAGER.get(sStyle);
            CompoundTag styleAnimationTag = livingmotionModifierTag.m_128469_(sStyle);
            for (String sLivingmotion : styleAnimationTag.m_128431_()) {
                LivingMotion livingmotion = LivingMotion.ENUM_MANAGER.get(sLivingmotion);
                StaticAnimation animation = EpicFightMod.getInstance().animationManager.findAnimationByPath(styleAnimationTag.m_128461_(sLivingmotion));
                builder.livingMotionModifier(style, livingmotion, animation);
            }
        }
        CompoundTag stylesTag = tag.m_128469_("styles");
        StyleEntry styleEntry = new StyleEntry();
        stylesTag.m_128437_("cases", 10);
        for (Tag caseTag : stylesTag.m_128437_("cases", 10)) {
            CompoundTag caseCompTag = (CompoundTag)caseTag;
            Function conditionProvider = EpicFightConditions.getConditionOrThrow(new ResourceLocation(caseCompTag.m_128461_("condition")));
            LivingEntityCondition condition = (LivingEntityCondition)Condition.ConditionBuilder.builder(conditionProvider).setTag(caseCompTag.m_128469_("predicate")).build();
            Style style = Style.ENUM_MANAGER.get(caseCompTag.m_128461_("style"));
            styleEntry.putNewEntry(condition, style);
        }
        styleEntry.elseStyle = Style.ENUM_MANAGER.get(stylesTag.m_128461_("default"));
        builder.styleProvider(styleEntry::getStyle);
        CompoundTag offhandValidatorTag = tag.m_128469_("offhand_item_compatible_predicate");
        Function conditionProvider = EpicFightConditions.getConditionOrThrow(new ResourceLocation(offhandValidatorTag.m_128461_("condition")));
        builder.weaponCombinationPredicator(((LivingEntityCondition)Condition.ConditionBuilder.builder(conditionProvider).setTag(offhandValidatorTag.m_128469_("predicate")).build())::predicate);
        return builder;
    }

    public static int getTagCount() {
        return TAGMAP.size();
    }

    public static Stream<CompoundTag> getWeaponTypeDataStream() {
        Stream<CompoundTag> tagStream = TAGMAP.entrySet().stream().map(entry -> {
            ((CompoundTag)entry.getValue()).m_128359_("registry_name", ((ResourceLocation)entry.getKey()).toString());
            return (CompoundTag)entry.getValue();
        });
        return tagStream;
    }

    public static void clear() {
        PRESETS.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void processServerPacket(SPDatapackSync packet) {
        if (packet.getType() == SPDatapackSync.Type.WEAPON_TYPE) {
            PRESETS.clear();
            WeaponTypeReloadListener.registerDefaultWeaponTypes();
            for (CompoundTag tag : packet.getTags()) {
                PRESETS.put(new ResourceLocation(tag.m_128461_("registry_name")), itemstack -> WeaponTypeReloadListener.deserializeWeaponCapabilityBuilder(tag));
            }
            ItemCapabilityReloadListener.weaponTypeProcessedCheck();
        }
    }

    private static /* synthetic */ Skill lambda$deserializeWeaponCapabilityBuilder$1(CompoundTag innateSkillsTag, String key, ItemStack itemstack) {
        return SkillManager.getSkill(innateSkillsTag.m_128461_(key));
    }
}

