/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.boss;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.network.EpicFightDataSerializers;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.DroppedNetherStar;
import yesman.epicfight.world.entity.WitherGhostClone;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviorGoal;

public class WitherPatch
extends MobPatch<WitherBoss> {
    private static final EntityDataAccessor<Boolean> DATA_ARMOR_ACTIVED = SynchedEntityData.m_135353_(WitherBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_GHOST = SynchedEntityData.m_135353_(WitherBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_TRANSPARENCY = SynchedEntityData.m_135353_(WitherBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Vec3> DATA_LASER_DESTINATION_A = SynchedEntityData.m_135353_(WitherBoss.class, (EntityDataSerializer)((EntityDataSerializer)EpicFightDataSerializers.VEC3.get()));
    private static final EntityDataAccessor<Vec3> DATA_LASER_DESTINATION_B = SynchedEntityData.m_135353_(WitherBoss.class, (EntityDataSerializer)((EntityDataSerializer)EpicFightDataSerializers.VEC3.get()));
    private static final EntityDataAccessor<Vec3> DATA_LASER_DESTINATION_C = SynchedEntityData.m_135353_(WitherBoss.class, (EntityDataSerializer)((EntityDataSerializer)EpicFightDataSerializers.VEC3.get()));
    private static final List<EntityDataAccessor<Vec3>> DATA_LASER_TARGET_POSITIONS = ImmutableList.of(DATA_LASER_DESTINATION_A, DATA_LASER_DESTINATION_B, DATA_LASER_DESTINATION_C);
    private static final EntityDataAccessor<Integer> DATA_LASER_TARGET_A = SynchedEntityData.m_135353_(WitherBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_LASER_TARGET_B = SynchedEntityData.m_135353_(WitherBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_LASER_TARGET_C = SynchedEntityData.m_135353_(WitherBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final List<EntityDataAccessor<Integer>> DATA_LASER_TARGETS = ImmutableList.of(DATA_LASER_TARGET_A, DATA_LASER_TARGET_B, DATA_LASER_TARGET_C);
    public static final TargetingConditions WTIHER_TARGETING_CONDITIONS = TargetingConditions.m_148352_().m_26883_(20.0).m_26888_(livingentity -> livingentity.m_6336_() != MobType.f_21641_ && livingentity.m_5789_());
    public static final TargetingConditions WTIHER_GHOST_TARGETING_CONDITIONS = WTIHER_TARGETING_CONDITIONS.m_148354_().m_148355_();
    private boolean blockedNow;
    private int deathTimerExt;
    private int blockingCount;
    private int blockingStartTick;
    private LivingEntityPatch<?> blockingEntity;

    @Override
    public void onConstructed(WitherBoss witherBoss) {
        super.onConstructed(witherBoss);
        ((WitherBoss)this.original).m_20088_().m_135372_(DATA_ARMOR_ACTIVED, (Object)false);
        ((WitherBoss)this.original).m_20088_().m_135372_(DATA_GHOST, (Object)false);
        ((WitherBoss)this.original).m_20088_().m_135372_(DATA_TRANSPARENCY, (Object)0);
        ((WitherBoss)this.original).m_20088_().m_135372_(DATA_LASER_DESTINATION_A, (Object)new Vec3(Double.NaN, Double.NaN, Double.NaN));
        ((WitherBoss)this.original).m_20088_().m_135372_(DATA_LASER_DESTINATION_C, (Object)new Vec3(Double.NaN, Double.NaN, Double.NaN));
        ((WitherBoss)this.original).m_20088_().m_135372_(DATA_LASER_DESTINATION_B, (Object)new Vec3(Double.NaN, Double.NaN, Double.NaN));
        ((WitherBoss)this.original).m_20088_().m_135372_(DATA_LASER_TARGET_A, (Object)0);
        ((WitherBoss)this.original).m_20088_().m_135372_(DATA_LASER_TARGET_B, (Object)0);
        ((WitherBoss)this.original).m_20088_().m_135372_(DATA_LASER_TARGET_C, (Object)0);
    }

    @Override
    public void initAI() {
        super.initAI();
        ((WitherBoss)this.original).f_21345_.m_25352_(1, (Goal)new WitherChasingGoal());
        ((WitherBoss)this.original).f_21345_.m_25352_(0, (Goal)new WitherGhostAttackGoal());
        ((WitherBoss)this.original).f_21345_.m_25352_(0, new CombatBehaviorGoal<WitherPatch>(this, MobCombatBehaviors.WITHER.build(this)));
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((WitherBoss)this.original).m_21051_((Attribute)EpicFightAttributes.IMPACT.get()).m_22100_(3.0);
    }

    @Override
    public void initAnimator(ClientAnimator clientAnimator) {
        clientAnimator.addLivingAnimation(LivingMotions.IDLE, Animations.WITHER_IDLE);
        clientAnimator.addLivingAnimation(LivingMotions.DEATH, Animations.WITHER_DEATH);
        clientAnimator.setCurrentMotionsAsDefault();
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        this.currentLivingMotion = ((WitherBoss)this.original).m_21223_() <= 0.0f ? LivingMotions.DEATH : LivingMotions.IDLE;
    }

    @Override
    public void tick(LivingEvent.LivingTickEvent event) {
        if (((WitherBoss)this.original).m_21223_() <= 0.0f && ((WitherBoss)this.original).f_20919_ > 1 && this.deathTimerExt < 17) {
            ++this.deathTimerExt;
            --((WitherBoss)this.original).f_20919_;
        }
        if (!this.getEntityState().inaction()) {
            int targetId = ((WitherBoss)this.original).m_31512_(0);
            Entity target = ((WitherBoss)this.original).m_9236_().m_6815_(targetId);
            if (target != null) {
                Vec3 vec3 = target.m_20182_().m_82546_(((WitherBoss)this.original).m_20182_()).m_82541_();
                float yrot = MathUtils.rotlerp(((WitherBoss)this.original).m_146908_(), (float)Mth.m_14136_((double)vec3.f_82481_, (double)vec3.f_82479_) * 57.295776f - 90.0f, 10.0f);
                ((WitherBoss)this.original).m_146922_(yrot);
            }
        }
        super.tick(event);
    }

    @Override
    public void clientTick(LivingEvent.LivingTickEvent event) {
        super.clientTick(event);
        ((WitherBoss)this.original).m_20334_(0.0, 0.0, 0.0);
        int transparencyCount = this.getTransparency();
        if (transparencyCount != 0) {
            this.setTransparency(transparencyCount + (transparencyCount > 0 ? -1 : 1));
        }
    }

    @Override
    public void serverTick(LivingEvent.LivingTickEvent event) {
        super.serverTick(event);
        if (((WitherBoss)this.original).m_21223_() <= ((WitherBoss)this.original).m_21233_() * 0.5f) {
            if (!this.isArmorActivated() && !this.getEntityState().inaction() && ((WitherBoss)this.original).m_31502_() <= 0 && ((WitherBoss)this.original).m_6084_()) {
                this.playAnimationSynchronized(Animations.WITHER_SPELL_ARMOR, 0.0f);
            }
        } else if (this.isArmorActivated()) {
            this.setArmorActivated(false);
        }
        if (this.animator.getPlayerFor(null).getAnimation().equals(Animations.WITHER_CHARGE) && this.getEntityState().attacking() && ForgeEventFactory.getMobGriefingEvent((Level)((WitherBoss)this.original).m_9236_(), (Entity)this.original)) {
            int x = Mth.m_14107_((double)((WitherBoss)this.original).m_20185_());
            int y = Mth.m_14107_((double)((WitherBoss)this.original).m_20186_());
            int z = Mth.m_14107_((double)((WitherBoss)this.original).m_20189_());
            boolean flag = false;
            for (int j = -1; j <= 1; ++j) {
                for (int k2 = -1; k2 <= 1; ++k2) {
                    for (int k = 0; k <= 3; ++k) {
                        int l2 = x + j;
                        int l = y + k;
                        int i1 = z + k2;
                        BlockPos blockpos = new BlockPos(l2, l, i1);
                        BlockState blockstate = ((WitherBoss)this.original).m_9236_().m_8055_(blockpos);
                        if (!blockstate.canEntityDestroy((BlockGetter)((WitherBoss)this.original).m_9236_(), blockpos, this.original) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)((LivingEntity)this.original), (BlockPos)blockpos, (BlockState)blockstate)) continue;
                        flag = ((WitherBoss)this.original).m_9236_().m_46953_(blockpos, true, this.original) || flag;
                    }
                }
            }
            if (flag) {
                ((WitherBoss)this.original).m_9236_().m_5898_(null, 1022, ((WitherBoss)this.original).m_20183_(), 0);
            }
        }
        if (this.blockedNow) {
            if (this.blockingCount < 0) {
                this.playAnimationSynchronized(Animations.WITHER_NEUTRALIZED, 0.0f);
                ((WitherBoss)this.original).m_5496_((SoundEvent)EpicFightSounds.NEUTRALIZE_BOSSES.get(), 5.0f, 1.0f);
                this.blockedNow = false;
                this.blockingEntity = null;
            } else if (((WitherBoss)this.original).f_19797_ % 4 == (this.blockingStartTick - 1) % 4) {
                if (((WitherBoss)this.original).m_20182_().m_82557_(((LivingEntity)this.blockingEntity.getOriginal()).m_20182_()) < 9.0) {
                    EpicFightDamageSource extendedSource = this.getDamageSource(Animations.WITHER_CHARGE, InteractionHand.MAIN_HAND);
                    extendedSource.setStunType(StunType.KNOCKDOWN).setImpact(4.0f).setInitialPosition(this.lastAttackPosition);
                    AttackResult attackResult = this.tryHarm((Entity)this.blockingEntity.getOriginal(), extendedSource, this.blockingCount);
                    if (attackResult.resultType == AttackResult.ResultType.SUCCESS) {
                        ((LivingEntity)this.blockingEntity.getOriginal()).m_6469_((DamageSource)extendedSource, 4.0f);
                        this.blockedNow = false;
                        this.blockingEntity = null;
                    }
                } else {
                    this.blockedNow = false;
                    this.blockingEntity = null;
                }
            }
        }
    }

    @Override
    public void onAttackBlocked(DamageSource damageSource, LivingEntityPatch<?> opponent) {
        EpicFightDamageSource extendedDamageSource;
        if (damageSource instanceof EpicFightDamageSource && Animations.WITHER_CHARGE.equals((extendedDamageSource = (EpicFightDamageSource)damageSource).getAnimation())) {
            if (!this.blockedNow) {
                this.blockedNow = true;
                this.blockingStartTick = ((WitherBoss)this.original).f_19797_;
                this.blockingEntity = opponent;
                this.playAnimationSynchronized(Animations.WITHER_BLOCKED, 0.0f);
            }
            --this.blockingCount;
            Vec3 lookAngle = ((LivingEntity)opponent.getOriginal()).m_20154_();
            lookAngle = lookAngle.m_82492_(0.0, lookAngle.f_82480_, 0.0);
            lookAngle.m_82490_(0.1);
            ((WitherBoss)this.original).m_146884_(((LivingEntity)opponent.getOriginal()).m_20182_().m_82549_(lookAngle));
        }
    }

    @Override
    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        Entity entity;
        DynamicAnimation animation = ((Animator)this.getAnimator()).getPlayerFor(null).getAnimation();
        if ((animation.equals(Animations.WITHER_CHARGE) || animation.equals(Animations.WITHER_BLOCKED)) && (entity = damageSource.m_7640_()) instanceof AbstractArrow) {
            return AttackResult.blocked(0.0f);
        }
        return super.tryHurt(damageSource, amount);
    }

    @Override
    public void onDeath(LivingDeathEvent event) {
        super.onDeath(event);
        if (!this.isLogicalClient() && ((WitherBoss)this.original).m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            Vec3 startMovement = ((WitherBoss)this.original).m_20154_().m_82490_(0.4).m_82520_(0.0, 0.63, 0.0);
            DroppedNetherStar itemEntity = new DroppedNetherStar(((WitherBoss)this.original).m_9236_(), ((WitherBoss)this.original).m_20182_().m_82520_(0.0, (double)((WitherBoss)this.original).m_20206_() * 0.5, 0.0), startMovement);
            ((WitherBoss)this.original).m_9236_().m_7967_((Entity)itemEntity);
        }
    }

    @Override
    public boolean onDrop(LivingDropsEvent event) {
        event.getDrops().removeIf(itemEntity -> itemEntity.m_32055_().m_150930_(Items.f_42686_));
        return false;
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        float yRot;
        float prevYRot;
        Entity entity = ((WitherBoss)this.original).m_20202_();
        if (entity instanceof LivingEntity) {
            LivingEntity ridingEntity = (LivingEntity)entity;
            prevYRot = ridingEntity.f_20884_;
            yRot = ridingEntity.f_20883_;
        } else {
            prevYRot = this.isLogicalClient() ? ((WitherBoss)this.original).f_20884_ : ((WitherBoss)this.original).f_19859_;
            yRot = this.isLogicalClient() ? ((WitherBoss)this.original).f_20883_ : ((WitherBoss)this.original).m_146908_();
        }
        return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, prevYRot, yRot, partialTicks, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public StaticAnimation getHitAnimation(StunType stunType) {
        return null;
    }

    public void startCharging() {
        this.setLastAttackPosition();
        this.blockingCount = 3;
    }

    public void setArmorActivated(boolean set) {
        ((WitherBoss)this.original).m_20088_().m_135381_(DATA_ARMOR_ACTIVED, (Object)set);
    }

    public boolean isArmorActivated() {
        return (Boolean)((WitherBoss)this.original).m_20088_().m_135370_(DATA_ARMOR_ACTIVED);
    }

    public void setGhost(boolean set) {
        ((WitherBoss)this.original).m_20088_().m_135381_(DATA_GHOST, (Object)set);
        ((WitherBoss)this.original).m_20242_(set);
        this.setTransparency(set ? 40 : -40);
        ((WitherBoss)this.original).m_6842_(set);
    }

    public boolean isGhost() {
        return (Boolean)((WitherBoss)this.original).m_20088_().m_135370_(DATA_GHOST);
    }

    public void setTransparency(int set) {
        ((WitherBoss)this.original).m_20088_().m_135381_(DATA_TRANSPARENCY, (Object)set);
    }

    public int getTransparency() {
        return (Integer)((WitherBoss)this.original).m_20088_().m_135370_(DATA_TRANSPARENCY);
    }

    public void setLaserTargetPosition(int head, Vec3 pos) {
        ((WitherBoss)this.original).m_20088_().m_135381_(DATA_LASER_TARGET_POSITIONS.get(head), (Object)pos);
    }

    public Vec3 getLaserTargetPosition(int head) {
        return (Vec3)((WitherBoss)this.original).m_20088_().m_135370_(DATA_LASER_TARGET_POSITIONS.get(head));
    }

    public void setLaserTarget(int head, Entity target) {
        ((WitherBoss)this.original).m_20088_().m_135381_(DATA_LASER_TARGETS.get(head), (Object)(target != null ? target.m_19879_() : -1));
    }

    public Entity getLaserTargetEntity(int head) {
        int laserTarget = (Integer)((WitherBoss)this.original).m_20088_().m_135370_(DATA_LASER_TARGETS.get(head));
        return laserTarget > 0 ? ((WitherBoss)this.original).m_9236_().m_6815_(laserTarget) : null;
    }

    public Entity getAlternativeTargetEntity(int head) {
        int id = ((WitherBoss)this.original).m_31512_(head);
        return id > 0 ? ((WitherBoss)this.original).m_9236_().m_6815_(id) : null;
    }

    public double getHeadX(int index) {
        if (index <= 0) {
            return ((WitherBoss)this.original).m_20185_();
        }
        float f = (((WitherBoss)this.original).m_146908_() + (float)(180 * (index - 1))) * ((float)Math.PI / 180);
        float f1 = Mth.m_14089_((float)f);
        return ((WitherBoss)this.original).m_20185_() + (double)f1 * 1.3;
    }

    public double getHeadY(int index) {
        return index <= 0 ? ((WitherBoss)this.original).m_20186_() + 3.0 : ((WitherBoss)this.original).m_20186_() + 2.2;
    }

    public double getHeadZ(int index) {
        if (index <= 0) {
            return ((WitherBoss)this.original).m_20189_();
        }
        float f = (((WitherBoss)this.original).m_146908_() + (float)(180 * (index - 1))) * ((float)Math.PI / 180);
        float f1 = Mth.m_14031_((float)f);
        return ((WitherBoss)this.original).m_20189_() + (double)f1 * 1.3;
    }

    public class WitherChasingGoal
    extends Goal {
        public WitherChasingGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return ((WitherBoss)WitherPatch.this.original).m_31512_(0) > 0;
        }

        public void m_8037_() {
            WitherBoss witherBoss = (WitherBoss)WitherPatch.this.getOriginal();
            Vec3 vec3 = witherBoss.m_20184_().m_82542_(1.0, 0.6, 1.0);
            Entity entity = witherBoss.m_9236_().m_6815_(((WitherBoss)WitherPatch.this.original).m_31512_(0));
            if (!WitherPatch.this.getEntityState().hurt() && !WitherPatch.this.blockedNow) {
                if (entity != null) {
                    double followingRange;
                    Vec3 vec31 = new Vec3(entity.m_20185_() - witherBoss.m_20185_(), 0.0, entity.m_20189_() - witherBoss.m_20189_());
                    double d0 = vec3.f_82480_;
                    if (witherBoss.m_20186_() < entity.m_20186_() || !witherBoss.m_7090_() && witherBoss.m_20186_() < entity.m_20186_() + 5.0 && !((Animator)WitherPatch.this.getAnimator()).getPlayerFor(null).getAnimation().getProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL).orElse(false).booleanValue()) {
                        d0 = Math.max(0.0, d0);
                        d0 += 0.3 - d0 * (double)0.6f;
                    }
                    vec3 = new Vec3(vec3.f_82479_, d0, vec3.f_82481_);
                    double d = followingRange = witherBoss.m_7090_() ? 9.0 : 49.0;
                    if (vec31.m_165925_() > followingRange && !WitherPatch.this.getEntityState().inaction()) {
                        Vec3 vec32 = vec31.m_82541_();
                        vec3 = vec3.m_82520_(vec32.f_82479_ * 0.3 - vec3.f_82479_ * 0.6, 0.0, vec32.f_82481_ * 0.3 - vec3.f_82481_ * 0.6);
                    }
                }
                witherBoss.m_20256_(vec3);
            }
        }
    }

    public class WitherGhostAttackGoal
    extends Goal {
        private int ghostSummonCount;
        private int maxGhostSpawn;
        private int summonInverval;
        private int cooldown;

        public WitherGhostAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return --this.cooldown < 0 && WitherPatch.this.isArmorActivated() && !WitherPatch.this.getEntityState().inaction() && ((WitherBoss)WitherPatch.this.original).m_5448_() != null;
        }

        public boolean m_8045_() {
            return this.ghostSummonCount <= this.maxGhostSpawn;
        }

        public void m_8056_() {
            WitherPatch.this.playAnimationSynchronized(Animations.WITHER_GHOST_STANDBY, 0.0f);
            WitherPatch.this.updateEntityState();
            WitherPatch.this.setGhost(true);
            List<LivingEntity> nearbyEnemies = this.getNearbyTargets();
            this.ghostSummonCount = 0;
            this.summonInverval = 25;
            this.maxGhostSpawn = Mth.m_14045_((int)(nearbyEnemies.size() / 2), (int)2, (int)4);
        }

        public void m_8037_() {
            if (--this.summonInverval <= 0) {
                LivingEntity target;
                if (this.ghostSummonCount < this.maxGhostSpawn) {
                    List<LivingEntity> nearbyEnemies = this.getNearbyTargets();
                    if (nearbyEnemies.size() > 0) {
                        LivingEntity randomTarget = nearbyEnemies.get(((WitherBoss)WitherPatch.this.original).m_217043_().m_188503_(nearbyEnemies.size()));
                        Vec3 summonPosition = randomTarget.m_20182_().m_82549_(new Vec3(0.0, 0.0, 6.0).m_82524_(((WitherBoss)WitherPatch.this.original).m_217043_().m_188501_() * 360.0f));
                        WitherGhostClone ghostclone = new WitherGhostClone((ServerLevel)((WitherBoss)WitherPatch.this.original).m_9236_(), summonPosition, randomTarget);
                        ((WitherBoss)WitherPatch.this.original).m_9236_().m_7967_((Entity)ghostclone);
                    } else {
                        this.ghostSummonCount = this.maxGhostSpawn + 1;
                    }
                }
                ++this.ghostSummonCount;
                int n = this.summonInverval = this.ghostSummonCount < this.maxGhostSpawn ? 25 : 35;
                if (this.ghostSummonCount == this.maxGhostSpawn && (target = ((WitherBoss)WitherPatch.this.original).m_5448_()) != null) {
                    Vec3 summonPosition = target.m_20182_().m_82549_(new Vec3(0.0, 0.0, 6.0).m_82524_(((WitherBoss)WitherPatch.this.original).m_217043_().m_188501_() * 360.0f)).m_82520_(0.0, 5.0, 0.0);
                    ((WitherBoss)WitherPatch.this.original).m_146884_(summonPosition);
                    ((WitherBoss)WitherPatch.this.original).m_7618_(EntityAnchorArgument.Anchor.FEET, ((WitherBoss)WitherPatch.this.original).m_5448_().m_20182_());
                }
            }
        }

        public void m_8041_() {
            this.cooldown = 300;
            if (((WitherBoss)WitherPatch.this.original).m_5448_() != null) {
                WitherPatch.this.playSound(SoundEvents.f_12554_, -0.1f, 0.1f);
                WitherPatch.this.playAnimationSynchronized(Animations.WITHER_CHARGE, 0.0f);
            } else {
                WitherPatch.this.playAnimationSynchronized(Animations.OFF_ANIMATION_HIGHEST, 0.0f);
            }
            WitherPatch.this.setGhost(false);
        }

        public List<LivingEntity> getNearbyTargets() {
            return ((WitherBoss)WitherPatch.this.original).m_9236_().m_45971_(LivingEntity.class, WTIHER_GHOST_TARGETING_CONDITIONS, (LivingEntity)WitherPatch.this.original, ((WitherBoss)WitherPatch.this.original).m_20191_().m_82377_(20.0, 5.0, 20.0));
        }
    }
}

