/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.weaponinnate;

import com.google.common.collect.Maps;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationProvider;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class BladeRushSkill
extends WeaponInnateSkill {
    private static final UUID EVENT_UUID = UUID.fromString("444a1a6a-c2f1-11eb-8529-0242ac130003");
    private final AnimationProvider[] comboAnimations = new AnimationProvider[3];
    private final Map<EntityType<?>, StaticAnimation> tryAnimations;

    public static Builder createBladeRushBuilder() {
        return new Builder().setCategory(SkillCategories.WEAPON_INNATE).setResource(Skill.Resource.WEAPON_INNATE_ENERGY).putTryAnimation(EntityType.f_20501_, Animations.BLADE_RUSH_TRY).putTryAnimation(EntityType.f_20458_, Animations.BLADE_RUSH_TRY).putTryAnimation(EntityType.f_20562_, Animations.BLADE_RUSH_TRY).putTryAnimation(EntityType.f_20524_, Animations.BLADE_RUSH_TRY).putTryAnimation(EntityType.f_20481_, Animations.BLADE_RUSH_TRY).putTryAnimation(EntityType.f_20558_, Animations.BLADE_RUSH_TRY);
    }

    public BladeRushSkill(Builder builder) {
        super(builder);
        this.comboAnimations[0] = () -> Animations.BLADE_RUSH_COMBO1;
        this.comboAnimations[1] = () -> Animations.BLADE_RUSH_COMBO2;
        this.comboAnimations[2] = () -> Animations.BLADE_RUSH_COMBO3;
        this.tryAnimations = builder.tryAnimations;
    }

    @Override
    public FriendlyByteBuf gatherArguments(LocalPlayerPatch executer, ControllEngine controllEngine) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeBoolean(true);
        return buf;
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID, event -> {
            if (event.getDamageSource().getAnimation().between(Animations.BLADE_RUSH_COMBO1, Animations.BLADE_RUSH_COMBO3) && event.getTarget().m_6084_() && this.tryAnimations.containsKey(event.getTarget().m_6095_())) {
                MobEffectInstance effectInstance = event.getTarget().m_21124_((MobEffect)EpicFightMobEffects.INSTABILITY.get());
                int amp = effectInstance == null ? 0 : effectInstance.m_19564_() + 1;
                event.getTarget().m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.INSTABILITY.get(), 100, amp));
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID);
    }

    @Override
    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        LivingEntity target = executer.getTarget();
        boolean execute = false;
        if (target != null) {
            LivingEntityPatch entitypatch;
            if (target.m_21023_((MobEffect)EpicFightMobEffects.INSTABILITY.get()) && target.m_21124_((MobEffect)EpicFightMobEffects.INSTABILITY.get()).m_19564_() >= 2) {
                execute = true;
            }
            if ((entitypatch = EpicFightCapabilities.getEntityPatch((Entity)target, LivingEntityPatch.class)) != null && entitypatch.getEntityState().hurtLevel() > 1 && this.tryAnimations.containsKey(target.m_6095_())) {
                execute = true;
            }
        }
        if (execute) {
            executer.getSkill(this).getDataManager().setData((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get(), 0);
            executer.playAnimationSynchronized(Animations.BLADE_RUSH_TRY, 0.0f);
        } else {
            int animationId = (Integer)executer.getSkill(this).getDataManager().getDataValue((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get());
            executer.getSkill(this).getDataManager().setDataF((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get(), v -> (v + 1) % this.comboAnimations.length);
            executer.playAnimationSynchronized(this.comboAnimations[animationId].get(), 0.0f);
        }
        super.executeOnServer(executer, args);
    }

    @Override
    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        List<Component> list = super.getTooltipOnItem(itemStack, cap, playerCap);
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(0), "Each Strike:");
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(1), "Execution:");
        return list;
    }

    @Override
    public WeaponInnateSkill registerPropertiesToAnimation() {
        ((AttackAnimation)Animations.BLADE_RUSH_COMBO1).phases[0].addProperties(((Map)this.properties.get(0)).entrySet());
        ((AttackAnimation)Animations.BLADE_RUSH_COMBO2).phases[0].addProperties(((Map)this.properties.get(0)).entrySet());
        ((AttackAnimation)Animations.BLADE_RUSH_COMBO3).phases[0].addProperties(((Map)this.properties.get(0)).entrySet());
        ((AttackAnimation)Animations.BLADE_RUSH_EXECUTE_BIPED).phases[0].addProperties(((Map)this.properties.get(1)).entrySet());
        return this;
    }

    @Override
    public boolean checkExecuteCondition(PlayerPatch<?> executer) {
        return executer.getTarget() != null && executer.getTarget().m_6084_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onScreen(LocalPlayerPatch playerpatch, float resolutionX, float resolutionY) {
    }

    public static class Builder
    extends Skill.Builder<BladeRushSkill> {
        private final Map<EntityType<?>, StaticAnimation> tryAnimations = Maps.newHashMap();

        public Builder putTryAnimation(EntityType<?> entityType, StaticAnimation tryAnimation) {
            this.tryAnimations.put(entityType, tryAnimation);
            return this;
        }

        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setCreativeTab(CreativeModeTab tab) {
            this.tab = tab;
            return this;
        }
    }
}

