/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.passive;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;

public abstract class PassiveSkill
extends Skill {
    private final Map<Attribute, AttributeModifier> passiveStats = Maps.newHashMap();

    public static Skill.Builder<PassiveSkill> createPassiveBuilder() {
        return new Skill.Builder().setCategory(SkillCategories.PASSIVE).setResource(Skill.Resource.NONE);
    }

    public PassiveSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.passiveStats.clear();
        if (parameters.m_128441_("attribute_modifiers")) {
            ListTag attributeList = parameters.m_128437_("attribute_modifiers", 10);
            for (Tag tag : attributeList) {
                CompoundTag comp = (CompoundTag)tag;
                String attribute = comp.m_128461_("attribute");
                Attribute attr = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(attribute));
                AttributeModifier modifier = ParseUtil.toAttributeModifier(comp);
                this.passiveStats.put(attr, modifier);
            }
        }
    }

    @Override
    public void onInitiate(SkillContainer container) {
        for (Map.Entry<Attribute, AttributeModifier> stat : this.passiveStats.entrySet()) {
            AttributeInstance attr = ((Player)container.getExecuter().getOriginal()).m_21051_(stat.getKey());
            if (attr.m_22109_(stat.getValue())) continue;
            attr.m_22118_(stat.getValue());
        }
    }

    @Override
    public void onRemoved(SkillContainer container) {
        for (Map.Entry<Attribute, AttributeModifier> stat : this.passiveStats.entrySet()) {
            AttributeInstance attr = ((Player)container.getExecuter().getOriginal()).m_21051_(stat.getKey());
            if (!attr.m_22109_(stat.getValue())) continue;
            attr.m_22130_(stat.getValue());
        }
    }

    public Set<Map.Entry<Attribute, AttributeModifier>> getModfierEntry() {
        return this.passiveStats.entrySet();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        String remainTime = String.format("%.0f", Float.valueOf(container.getMaxResource() - container.getResource()));
        guiGraphics.drawString(gui.font, remainTime, x + 12.0f - (float)(4 * remainTime.length()), y + 6.0f, 0xFFFFFF, true);
        poseStack.m_85849_();
    }
}

