/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.mover;

import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationProvider;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class PhantomAscentSkill
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("051a9bb2-7541-11ee-b962-0242ac120002");
    private final AnimationProvider[] animations = new AnimationProvider[2];
    private int extraJumps;

    public PhantomAscentSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
        this.animations[0] = () -> Animations.BIPED_PHANTOM_ASCENT_FORWARD;
        this.animations[1] = () -> Animations.BIPED_PHANTOM_ASCENT_BACKWARD;
    }

    @Override
    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.extraJumps = parameters.m_128451_("extra_jumps");
        this.consumption = 0.2f;
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        PlayerEventListener listener = container.getExecuter().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            if (((LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20202_() != null || !((LocalPlayerPatch)event.getPlayerPatch()).isBattleMode() || ((LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal()).m_150110_().f_35935_ || ((LocalPlayerPatch)event.getPlayerPatch()).isChargingSkill() || ((LocalPlayerPatch)event.getPlayerPatch()).getEntityState().inaction()) {
                return;
            }
            boolean jumpPressed = Minecraft.m_91087_().f_91066_.f_92089_.m_90857_();
            boolean jumpPressedPrev = (Boolean)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.JUMP_KEY_PRESSED_LAST_TICK.get());
            if (jumpPressed && !jumpPressedPrev) {
                if (container.getStack() < 1) {
                    return;
                }
                int jumpCounter = (Integer)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.JUMP_COUNT.get());
                if (jumpCounter > 0 || ((LocalPlayerPatch)event.getPlayerPatch()).currentLivingMotion == LivingMotions.FALL) {
                    if (jumpCounter < this.extraJumps + 1) {
                        container.setResource(0.0f);
                        if (jumpCounter == 0 && ((LocalPlayerPatch)event.getPlayerPatch()).currentLivingMotion == LivingMotions.FALL) {
                            container.getDataManager().setData((SkillDataKey)SkillDataKeys.JUMP_COUNT.get(), 2);
                        } else {
                            container.getDataManager().setDataF((SkillDataKey)SkillDataKeys.JUMP_COUNT.get(), v -> v + 1);
                        }
                        container.getDataManager().setDataSync((SkillDataKey)SkillDataKeys.PROTECT_NEXT_FALL.get(), Boolean.valueOf(true), (LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal());
                        Input input = event.getMovementInput();
                        float f = Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)((LivingEntity)container.getExecuter().getOriginal()))), (float)0.0f, (float)1.0f);
                        input.m_214106_(false, f);
                        int forward = event.getMovementInput().f_108568_ ? 1 : 0;
                        int backward = event.getMovementInput().f_108569_ ? -1 : 0;
                        int left = event.getMovementInput().f_108570_ ? 1 : 0;
                        int right = event.getMovementInput().f_108571_ ? -1 : 0;
                        int vertic = forward + backward;
                        int horizon = left + right;
                        int degree = -(90 * horizon * (1 - Math.abs(vertic)) + 45 * vertic * horizon);
                        int scale = forward == 0 && backward == 0 && left == 0 && right == 0 ? 0 : (vertic < 0 ? -1 : 1);
                        Vec3 forwardHorizontal = Vec3.m_82503_((Vec2)new Vec2(0.0f, ((Player)container.getExecuter().getOriginal()).m_5675_(1.0f)));
                        Vec3 jumpDir = OpenMatrix4f.transform(OpenMatrix4f.createRotatorDeg(-degree, Vec3f.Y_AXIS), forwardHorizontal.m_82490_(0.15 * (double)scale));
                        Vec3 deltaMove = ((Player)container.getExecuter().getOriginal()).m_20184_();
                        ((Player)container.getExecuter().getOriginal()).m_20334_(deltaMove.f_82479_ + jumpDir.f_82479_, 0.6 + (double)((Player)container.getExecuter().getOriginal()).m_285755_(), deltaMove.f_82481_ + jumpDir.f_82481_);
                        ((LocalPlayerPatch)event.getPlayerPatch()).playAnimationClientPreemptive(this.animations[vertic < 0 ? 1 : 0].get(), 0.0f);
                        ((LocalPlayerPatch)event.getPlayerPatch()).changeModelYRot(degree);
                    }
                } else {
                    container.getDataManager().setData((SkillDataKey)SkillDataKeys.JUMP_COUNT.get(), 1);
                }
            }
            container.getDataManager().setData((SkillDataKey)SkillDataKeys.JUMP_KEY_PRESSED_LAST_TICK.get(), jumpPressed);
        });
        listener.addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            if (((DamageSource)event.getDamageSource()).m_269533_(DamageTypeTags.f_268549_) && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.PROTECT_NEXT_FALL.get())).booleanValue()) {
                float damage = event.getAmount();
                if (damage < 2.5f) {
                    event.setAmount(0.0f);
                    event.setCanceled(true);
                }
                container.getDataManager().setData((SkillDataKey)SkillDataKeys.PROTECT_NEXT_FALL.get(), false);
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.FALL_EVENT, EVENT_UUID, event -> {
            container.getDataManager().setData((SkillDataKey)SkillDataKeys.JUMP_COUNT.get(), 0);
            if (((EntityPatch)event.getPlayerPatch()).isLogicalClient()) {
                container.getDataManager().setData((SkillDataKey)SkillDataKeys.JUMP_KEY_PRESSED_LAST_TICK.get(), false);
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        PlayerEventListener listener = container.getExecuter().getEventListener();
        listener.removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.FALL_EVENT, EVENT_UUID);
    }

    @Override
    public boolean canExecute(PlayerPatch<?> executer) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(this.extraJumps);
        return list;
    }
}

