/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.guard;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.ExtendableEnum;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.guard.GuardSkill;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.entity.eventlistener.HurtEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class ParryingSkill
extends GuardSkill {
    private static final int PARRY_WINDOW = 8;

    public static GuardSkill.Builder createActiveGuardBuilder() {
        return GuardSkill.createGuardBuilder().addAdvancedGuardMotion(CapabilityItem.WeaponCategories.SWORD, (itemCap, playerpatch) -> {
            StaticAnimation[] staticAnimationArray;
            if (itemCap.getStyle((LivingEntityPatch<?>)playerpatch) == CapabilityItem.Styles.ONE_HAND) {
                StaticAnimation[] staticAnimationArray2 = new StaticAnimation[2];
                staticAnimationArray2[0] = Animations.SWORD_GUARD_ACTIVE_HIT1;
                staticAnimationArray = staticAnimationArray2;
                staticAnimationArray2[1] = Animations.SWORD_GUARD_ACTIVE_HIT2;
            } else {
                StaticAnimation[] staticAnimationArray3 = new StaticAnimation[2];
                staticAnimationArray3[0] = Animations.SWORD_GUARD_ACTIVE_HIT2;
                staticAnimationArray = staticAnimationArray3;
                staticAnimationArray3[1] = Animations.SWORD_GUARD_ACTIVE_HIT3;
            }
            return staticAnimationArray;
        }).addAdvancedGuardMotion(CapabilityItem.WeaponCategories.LONGSWORD, (itemCap, playerpatch) -> new StaticAnimation[]{Animations.LONGSWORD_GUARD_ACTIVE_HIT1, Animations.LONGSWORD_GUARD_ACTIVE_HIT2}).addAdvancedGuardMotion(CapabilityItem.WeaponCategories.UCHIGATANA, (itemCap, playerpatch) -> new StaticAnimation[]{Animations.SWORD_GUARD_ACTIVE_HIT1, Animations.SWORD_GUARD_ACTIVE_HIT2}).addAdvancedGuardMotion(CapabilityItem.WeaponCategories.TACHI, (itemCap, playerpatch) -> new StaticAnimation[]{Animations.LONGSWORD_GUARD_ACTIVE_HIT1, Animations.LONGSWORD_GUARD_ACTIVE_HIT2});
    }

    public ParryingSkill(GuardSkill.Builder builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {
            int lastActive;
            CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND);
            if (this.isHoldingWeaponAvailable((PlayerPatch<?>)event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD) && this.isExecutableState((PlayerPatch<?>)event.getPlayerPatch())) {
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
            }
            if (((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19797_ - (lastActive = ((Integer)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.LAST_ACTIVE.get())).intValue()) > 16) {
                container.getDataManager().setData((SkillDataKey)SkillDataKeys.LAST_ACTIVE.get(), ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19797_);
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
    }

    @Override
    public void guard(SkillContainer container, CapabilityItem itemCapability, HurtEvent.Pre event, float knockback, float impact, boolean advanced) {
        DamageSource damageSource;
        if (this.isHoldingWeaponAvailable((PlayerPatch<?>)event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.ADVANCED_GUARD) && this.isBlockableSource(damageSource = (DamageSource)event.getDamageSource(), true)) {
            ServerPlayer playerentity = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            boolean successParrying = playerentity.f_19797_ - (Integer)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.LAST_ACTIVE.get()) < 8;
            float penalty = ((Float)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.PENALTY.get())).floatValue();
            ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.CLASH.get(), -0.05f, 0.1f);
            ((HitParticleType)((Object)EpicFightParticles.HIT_BLUNT.get())).spawnParticleWithArgument((ServerLevel)playerentity.m_9236_(), HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, (Entity)playerentity, damageSource.m_7640_());
            if (successParrying) {
                event.setParried(true);
                penalty = 0.1f;
                knockback *= 0.4f;
            } else {
                container.getDataManager().setDataSync((SkillDataKey)SkillDataKeys.PENALTY.get(), Float.valueOf(penalty += this.getPenalizer(itemCapability)), playerentity);
            }
            Entity entity = damageSource.m_7640_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)livingentity) * 0.1f;
            }
            ((ServerPlayerPatch)event.getPlayerPatch()).knockBackEntity(damageSource.m_7640_().m_20182_(), knockback);
            float consumeAmount = penalty * impact;
            ((ServerPlayerPatch)event.getPlayerPatch()).consumeStaminaAlways(consumeAmount);
            GuardSkill.BlockType blockType = successParrying ? GuardSkill.BlockType.ADVANCED_GUARD : (((ServerPlayerPatch)event.getPlayerPatch()).hasStamina(0.0f) ? GuardSkill.BlockType.GUARD : GuardSkill.BlockType.GUARD_BREAK);
            StaticAnimation animation = this.getGuardMotion((PlayerPatch<?>)event.getPlayerPatch(), itemCapability, blockType);
            if (animation != null) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(animation, 0.0f);
            }
            if (blockType == GuardSkill.BlockType.GUARD_BREAK) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_MOBS.get(), 3.0f, 0.0f, 0.1f);
            }
            this.dealEvent((PlayerPatch<?>)event.getPlayerPatch(), event, advanced);
            return;
        }
        super.guard(container, itemCapability, event, knockback, impact, false);
    }

    @Override
    protected boolean isBlockableSource(DamageSource damageSource, boolean advanced) {
        return damageSource.m_269533_(DamageTypeTags.f_268524_) && advanced || super.isBlockableSource(damageSource, false);
    }

    @Override
    @Nullable
    protected StaticAnimation getGuardMotion(PlayerPatch<?> playerpatch, CapabilityItem itemCapability, GuardSkill.BlockType blockType) {
        StaticAnimation[] motions;
        StaticAnimation animation = itemCapability.getGuardMotion(this, blockType, playerpatch);
        if (animation != null) {
            return animation;
        }
        if (blockType == GuardSkill.BlockType.ADVANCED_GUARD && (motions = (StaticAnimation[])this.getGuradMotionMap(blockType).getOrDefault(itemCapability.getWeaponCategory(), (a, b) -> null).apply(itemCapability, playerpatch)) != null) {
            SkillDataManager dataManager = playerpatch.getSkill(this).getDataManager();
            int motionCounter = (Integer)dataManager.getDataValue((SkillDataKey)SkillDataKeys.PARRY_MOTION_COUNTER.get());
            dataManager.setDataF((SkillDataKey)SkillDataKeys.PARRY_MOTION_COUNTER.get(), v -> v + 1);
            return motions[motionCounter %= motions.length];
        }
        return super.getGuardMotion(playerpatch, itemCapability, blockType);
    }

    @Override
    public Skill getPriorSkill() {
        return EpicFightSkills.GUARD;
    }

    @Override
    protected boolean isAdvancedGuard() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.clear();
        StringBuilder sb = new StringBuilder();
        Iterator iter = this.advancedGuardMotions.keySet().iterator();
        while (iter.hasNext()) {
            sb.append(WeaponCategory.ENUM_MANAGER.toTranslated((ExtendableEnum)iter.next()));
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        list.add(sb.toString());
        return list;
    }
}

